
#include "Radar_F2R3.h"

RadarF2R3DataBufferUnion      RadarF2R3Data;
RadarF2R3ReceivingCtrlStruct  RadarF2R3ReceivingCtrl;

void Radar_F2R3_Init(void)
{
  RadarF2R3ReceivingCtrl.Timer      = 0;
  RadarF2R3ReceivingCtrl.Enable     = 0;
  RadarF2R3ReceivingCtrl.Complete   = 0;
  RadarF2R3ReceivingCtrl.Ptr        = 0;
  RadarF2R3ReceivingCtrl.Counter    = 0;
  
  RADAR_VALID            = 0;
  RADAR_SELF_TEST_PASSED = 0;
  RADAR_SYS_FAULT        = 0;
  RADAR_SOUND            = RADAR_SND_MUTE;
  
  RADAR_SENSOR_FL   = 0;
  RADAR_SENSOR_FM   = 0;
  RADAR_SENSOR_FR   = 0;
  RADAR_SENSOR_RL   = 0;
  RADAR_SENSOR_RM   = 0;
  RADAR_SENSOR_RR   = 0;
}

//10ms
void Radar_F2R3_Receiving_Service(void)
{
  uint8_t  i;
  uint8_t  CheckSum;
  uint8_t  Sensor;
  uint16_t Counter;
  
  if (RadarF2R3ReceivingCtrl.Enable)
  {
    RADAR_SYS_FAULT = 0;
    
    if (RadarF2R3ReceivingCtrl.LostTimer < 0xFFFF)
      RadarF2R3ReceivingCtrl.LostTimer++;
    
    if (RadarF2R3ReceivingCtrl.InvalidTimer < 0xFFFF)
      RadarF2R3ReceivingCtrl.InvalidTimer++;    
    
    if (RadarF2R3ReceivingCtrl.Complete)
    {
      RadarF2R3ReceivingCtrl.Complete = 0;
      RadarF2R3ReceivingCtrl.LostTimer = 0;
      
      CheckSum = 0;
      for (i = 0; i < 4; i++)
        CheckSum += RadarF2R3Data.Byte[i];
      
      if ((CheckSum == RadarF2R3Data.Frame.CheckSum) && \
          (RadarF2R3Data.Frame.Config == RADAR_CONFIGURATION))
      {
        RadarF2R3ReceivingCtrl.InvalidTimer = 0;
        
        //ݽ
        RADAR_VALID      = 0;
        
        if (RadarF2R3Data.Frame.R_SYS_ST == RADAR_SYS_ST_ENABLE)
        {
          RADAR_VALID     |= RADAR_REAR_VALID_FLAG;
          
          RADAR_SENSOR_RL  = RadarF2R3DataConvTable[RadarF2R3Data.Msg.RL];
          RADAR_SENSOR_RM  = RadarF2R3DataConvTable[RadarF2R3Data.Msg.RM];
          RADAR_SENSOR_RR  = RadarF2R3DataConvTable[RadarF2R3Data.Msg.RR];
        }
        else if (RadarF2R3Data.Frame.R_SYS_ST == RADAR_SYS_ST_FAIL)
        {
          RADAR_VALID     |= RADAR_REAR_FAULT_FLAG;
          
          if (RadarF2R3Data.Failure.RL)
            RADAR_SENSOR_RL = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_RL = 0;
          
          if ((RadarF2R3Data.Failure.RLM) || (RadarF2R3Data.Failure.RRM)) 
            RADAR_SENSOR_RM = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_RM = 0;
          
          if (RadarF2R3Data.Failure.RR)
            RADAR_SENSOR_RR = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_RR = 0;
          
          if (RadarF2R3Data.Failure.LED0)
            RADAR_SYS_FAULT |= RADAR_LED_FAULT_BIT;
          
          if (RadarF2R3Data.Failure.SWITCH0)
            RADAR_SYS_FAULT |= RADAR_SWITCH_FAULT_BIT;
          
          if (RadarF2R3Data.Failure.HOST0)
            RADAR_SYS_FAULT |= RADAR_HOST_FAULT_BIT;
        }
        else
        {
          RADAR_SENSOR_RL = 0;
          RADAR_SENSOR_RM = 0;
          RADAR_SENSOR_RR = 0;
        }
        
        if (RadarF2R3Data.Frame.F_SYS_ST == RADAR_SYS_ST_ENABLE)
        {
          RADAR_VALID    |= RADAR_FRONT_VALID_FLAG;
          
          RADAR_SENSOR_FL = RadarF2R3DataConvTable[RadarF2R3Data.Msg.FL];
          RADAR_SENSOR_FM = RadarF2R3DataConvTable[RadarF2R3Data.Msg.FM];
          RADAR_SENSOR_FR = RadarF2R3DataConvTable[RadarF2R3Data.Msg.FR];
        }
        else if (RadarF2R3Data.Frame.F_SYS_ST == RADAR_SYS_ST_FAIL)
        {
          RADAR_VALID     |= RADAR_FRONT_FAULT_FLAG;
          
          if (RadarF2R3Data.Failure.FL)
            RADAR_SENSOR_FL = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_FL = 0;
          
          if ((RadarF2R3Data.Failure.FLM) || (RadarF2R3Data.Failure.FRM)) 
            RADAR_SENSOR_FM = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_FM = 0;
          
          if (RadarF2R3Data.Failure.FR)
            RADAR_SENSOR_FR = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_FR = 0;
          
          if (RadarF2R3Data.Failure.LED1)
            RADAR_SYS_FAULT |= RADAR_LED_FAULT_BIT;
          
          if (RadarF2R3Data.Failure.SWITCH1)
            RADAR_SYS_FAULT |= RADAR_SWITCH_FAULT_BIT;
          
          if (RadarF2R3Data.Failure.HOST1)
            RADAR_SYS_FAULT |= RADAR_HOST_FAULT_BIT;
        }
        else
        {
          RADAR_SENSOR_FL = 0;
          RADAR_SENSOR_FM = 0;
          RADAR_SENSOR_FR = 0;
        }
        
        RADAR_SOUND = RadarF2R3DataConvTable[RadarF2R3Data.Msg.Snd];
      }
    }
    else
    {
      Counter = API_ROLLING_COUNTER;
      if (Counter - RadarF2R3ReceivingCtrl.Counter >= (10000 / API_INT_CYCLE))
        RadarF2R3ReceivingCtrl.Ptr = 0;
    }
    
    //ʧЧж
    if (RadarF2R3ReceivingCtrl.LostTimer >= RADAR_F2R3_MSG_LOST_THRESHOLD * 100)
    {
      RADAR_VALID      = (RADAR_REAR_FAULT_FLAG | RADAR_FRONT_FAULT_FLAG);
      RADAR_SYS_FAULT |=  RADAR_MSG_LOST_BIT;
      //RadarF2R3ReceivingCtrl.InvalidTimer = 0;
      
      RADAR_SENSOR_FL   = 0;
      RADAR_SENSOR_FM   = 0;
      RADAR_SENSOR_FR   = 0;
      RADAR_SENSOR_RL   = 0;
      RADAR_SENSOR_RM   = 0;
      RADAR_SENSOR_RR   = 0;
    }
    else
    {
      RADAR_SYS_FAULT &= ~RADAR_MSG_LOST_BIT;
      
      if (RadarF2R3ReceivingCtrl.InvalidTimer >= RADAR_F2R3_MSG_INVALID_THRESHOLD * 100)
      {
        RADAR_VALID      = (RADAR_REAR_FAULT_FLAG | RADAR_FRONT_FAULT_FLAG);
        RADAR_SYS_FAULT |= RADAR_MSG_INVALID_BIT;
        
        RADAR_SENSOR_FL   = 0;
        RADAR_SENSOR_FM   = 0;
        RADAR_SENSOR_FR   = 0;
        RADAR_SENSOR_RL   = 0;
        RADAR_SENSOR_RM   = 0;
        RADAR_SENSOR_RR   = 0;
      }
    }
    
    if (LINE_IN_GEAR_R_SIGNAL)
    {
      RADAR_SELF_TEST_PASSED = 1;
      RadarF2R3ReceivingCtrl.Timer = 0;
    }
    else
    {
      RADAR_SELF_TEST_PASSED = 0;
      
      Sensor  = 0;
      Sensor |= RADAR_SENSOR_FL;
      Sensor |= RADAR_SENSOR_FM;
      Sensor |= RADAR_SENSOR_FR;
      Sensor |= RADAR_SENSOR_RL;
      Sensor |= RADAR_SENSOR_RM;
      Sensor |= RADAR_SENSOR_RR;
      
      if ((RADAR_SYS_FAULT == 0) && (Sensor == 0))
      {
        if (RadarF2R3ReceivingCtrl.Timer < 390)       //޹,ϰ,4ֹͣʾ
          RadarF2R3ReceivingCtrl.Timer++;
        else
          RADAR_VALID = 0;
      }
      else
        RadarF2R3ReceivingCtrl.Timer = 0;
    }
  }
}

void Radar_F2R3_Receive_Enable(uint8_t En)
{
  if (En)
    En = 1;
  
  if (RadarF2R3ReceivingCtrl.Enable != En)
  {
    RadarF2R3ReceivingCtrl.Enable        = En;
    RadarF2R3ReceivingCtrl.Timer         = 0;
    RadarF2R3ReceivingCtrl.InvalidTimer  = 0;
    RadarF2R3ReceivingCtrl.LostTimer     = 0;

    RADAR_VALID            = 0;
    RADAR_SELF_TEST_PASSED = 0;
    RADAR_SYS_FAULT        = 0;
    RADAR_SOUND            = RADAR_SND_MUTE;
    
    RADAR_SENSOR_FL   = 0;
    RADAR_SENSOR_FM   = 0;
    RADAR_SENSOR_FR   = 0;
    RADAR_SENSOR_RL   = 0;
    RADAR_SENSOR_RM   = 0;
    RADAR_SENSOR_RR   = 0;
  }
}

void Radar_F2R3_Receive_Data(uint8_t Data, uint8_t Parity)
{
  uint16_t Counter;
  
  if (RadarF2R3ReceivingCtrl.Enable)
  {
    if (RadarF2R3ReceivingCtrl.Complete)
      return;
    
    //ֽڽճʱ10ms(10,000 us),0ֽ½
    Counter = API_ROLLING_COUNTER;
    if (Counter - RadarF2R3ReceivingCtrl.Counter >= (10000 / API_INT_CYCLE))
      RadarF2R3ReceivingCtrl.Ptr = 0;
    RadarF2R3ReceivingCtrl.Counter = Counter;

    //ֽУ,λָ벢ֹһֽڽ    
    if (Parity != 0)
    {
      RadarF2R3ReceivingCtrl.Ptr = 0;
      return;       
    }

    //1ֽ
    RadarF2R3Data.Byte[RadarF2R3ReceivingCtrl.Ptr] = Data;
    RadarF2R3ReceivingCtrl.Ptr++;
    
    //һ֡
    if (RadarF2R3ReceivingCtrl.Ptr >= 5)
    {
      RadarF2R3ReceivingCtrl.Complete = 1;
      RadarF2R3ReceivingCtrl.Ptr = 0;
    }
  }
}
