/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetISCII
extends CharsetICU {
    private static final short UCNV_OPTIONS_VERSION_MASK = 15;
    private static final short ZWNJ = 8204;
    private static final short ZWJ = 8205;
    private static final short ATR = 239;
    private static final short EXT = 240;
    private static final short DANDA = 2404;
    private static final short DOUBLE_DANDA = 2405;
    private static final short ISCII_NUKTA = 233;
    private static final short ISCII_HALANT = 232;
    private static final short ISCII_DANDA = 234;
    private static final short ISCII_VOWEL_SIGN_E = 224;
    private static final short ISCII_INV = 217;
    private static final short INDIC_BLOCK_BEGIN = 2304;
    private static final short INDIC_BLOCK_END = 3455;
    private static final short INDIC_RANGE = 1151;
    private static final short VOCALLIC_RR = 2353;
    private static final short LF = 10;
    private static final short ASCII_END = 160;
    private static final short TELUGU_DELTA = 768;
    private static final short DEV_ABBR_SIGN = 2416;
    private static final short DEV_ANUDATTA = 2386;
    private static final short EXT_RANGE_BEGIN = 161;
    private static final short EXT_RANGE_END = 238;
    private static final short PNJ_DELTA = 256;
    private static final int NO_CHAR_MARKER = 65534;
    private static UnicodeSet PNJ_BINDI_TIPPI_SET;
    private static UnicodeSet PNJ_CONSONANT_SET;
    private static final short PNJ_BINDI = 2562;
    private static final short PNJ_TIPPI = 2672;
    private static final short PNJ_SIGN_VIRAMA = 2637;
    private static final short PNJ_ADHAK = 2673;
    private static final short PNJ_HA = 2617;
    private static final short PNJ_RRA = 2652;
    private final String ISCII_CNV_PREFIX = "ISCII,version=";
    private static final LookupDataStruct[] lookupInitialData;
    private static final short[] validityTable;
    private static final char[] fromUnicodeTable;
    private static final char[] toUnicodeTable;
    private static final char[][] nuktaSpecialCases;
    private static final char[][] vowelSignESpecialCases;
    private static final short[][] lookupTable;
    private UConverterDataISCII extraInfo = null;
    protected byte[] fromUSubstitution = new byte[]{26};

    public CharsetISCII(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        int option = Integer.parseInt(icuCanonicalName.substring(14));
        this.extraInfo = new UConverterDataISCII(option, new String("ISCII,version=" + (option & 0xF)));
        this.initializePNJSets();
    }

    private void initializePNJSets() {
        if (PNJ_BINDI_TIPPI_SET != null && PNJ_CONSONANT_SET != null) {
            return;
        }
        PNJ_BINDI_TIPPI_SET = new UnicodeSet();
        PNJ_CONSONANT_SET = new UnicodeSet();
        PNJ_CONSONANT_SET.add(2581, 2600);
        PNJ_CONSONANT_SET.add(2602, 2608);
        PNJ_CONSONANT_SET.add(2613, 2614);
        PNJ_CONSONANT_SET.add(2616, 2617);
        PNJ_BINDI_TIPPI_SET.addAll(PNJ_CONSONANT_SET);
        PNJ_BINDI_TIPPI_SET.add(2565);
        PNJ_BINDI_TIPPI_SET.add(2567);
        PNJ_BINDI_TIPPI_SET.add(2625, 2626);
        PNJ_BINDI_TIPPI_SET.add(2623);
        PNJ_CONSONANT_SET.compact();
        PNJ_BINDI_TIPPI_SET.compact();
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderISCII(this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderISCII(this);
    }

    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        setFillIn.add(0, 160);
        for (int script = 0; script <= 8; ++script) {
            char mask = (char)CharsetISCII.lookupInitialData[script].maskEnum;
            for (int idx = 0; idx < 128; ++idx) {
                if ((validityTable[idx] & mask) == 0 && (script != 6 || idx != 49)) continue;
                setFillIn.add(idx + script * 128 + 2304);
            }
        }
        setFillIn.add(2404);
        setFillIn.add(2405);
        setFillIn.add(8204);
        setFillIn.add(8205);
    }

    static {
        lookupInitialData = new LookupDataStruct[]{new LookupDataStruct(0, 128, 66), new LookupDataStruct(1, 8, 67), new LookupDataStruct(2, 64, 75), new LookupDataStruct(3, 32, 74), new LookupDataStruct(4, 16, 71), new LookupDataStruct(5, 1, 68), new LookupDataStruct(6, 4, 69), new LookupDataStruct(7, 4, 72), new LookupDataStruct(8, 2, 73)};
        validityTable = new short[]{0, 248, 255, 255, 128, 255, 255, 255, 255, 255, 255, 190, 158, 160, 135, 255, 255, 160, 135, 255, 255, 255, 254, 254, 254, 255, 255, 254, 255, 254, 255, 255, 254, 254, 254, 255, 255, 254, 254, 254, 255, 129, 255, 254, 254, 254, 255, 255, 255, 131, 255, 247, 131, 247, 254, 191, 255, 255, 0, 0, 216, 128, 255, 255, 255, 255, 255, 190, 172, 160, 135, 255, 255, 160, 135, 255, 255, 255, 0, 0, 160, 128, 128, 128, 128, 4, 20, 26, 128, 192, 192, 192, 200, 152, 192, 152, 190, 158, 136, 136, 128, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        fromUnicodeTable = new char[]{'\u00a0', '\u00a1', '\u00a2', '\u00a3', '\ua4e0', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\ua6e9', '\u00ae', '\u00ab', '\u00ac', '\u00ad', '\u00b2', '\u00af', '\u00b0', '\u00b1', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\uffff', '\uffff', '\u00e9', '\ueae9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\udfe9', '\u00e3', '\u00e0', '\u00e1', '\u00e2', '\u00e7', '\u00e4', '\u00e5', '\u00e6', '\u00e8', '\u00ec', '\u00ed', '\ua1e9', '\uffff', '\uf0b8', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\ub3e9', '\ub4e9', '\ub5e9', '\ubae9', '\ubfe9', '\uc0e9', '\uc9e9', '\u00ce', '\uaae9', '\ua7e9', '\udbe9', '\udce9', '\u00ea', '\ueaea', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\uf0bf', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
        toUnicodeTable = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u0901', '\u0902', '\u0903', '\u0905', '\u0906', '\u0907', '\u0908', '\u0909', '\u090a', '\u090b', '\u090e', '\u090f', '\u0910', '\u090d', '\u0912', '\u0913', '\u0914', '\u0911', '\u0915', '\u0916', '\u0917', '\u0918', '\u0919', '\u091a', '\u091b', '\u091c', '\u091d', '\u091e', '\u091f', '\u0920', '\u0921', '\u0922', '\u0923', '\u0924', '\u0925', '\u0926', '\u0927', '\u0928', '\u0929', '\u092a', '\u092b', '\u092c', '\u092d', '\u092e', '\u092f', '\u095f', '\u0930', '\u0931', '\u0932', '\u0933', '\u0934', '\u0935', '\u0936', '\u0937', '\u0938', '\u0939', '\u200d', '\u093e', '\u093f', '\u0940', '\u0941', '\u0942', '\u0943', '\u0946', '\u0947', '\u0948', '\u0945', '\u094a', '\u094b', '\u094c', '\u0949', '\u094d', '\u093c', '\u0964', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
        nuktaSpecialCases = new char[][]{{'\u0010', '\u0000'}, {'\u00a6', '\u090c'}, {'\u00ea', '\u093d'}, {'\u00df', '\u0944'}, {'\u00a1', '\u0950'}, {'\u00b3', '\u0958'}, {'\u00b4', '\u0959'}, {'\u00b5', '\u095a'}, {'\u00ba', '\u095b'}, {'\u00bf', '\u095c'}, {'\u00c0', '\u095d'}, {'\u00c9', '\u095e'}, {'\u00aa', '\u0960'}, {'\u00a7', '\u0961'}, {'\u00db', '\u0962'}, {'\u00dc', '\u0963'}};
        vowelSignESpecialCases = new char[][]{{'\u0002', '\u0000'}, {'\u00a4', '\u0904'}};
        lookupTable = new short[][]{{0, 0}, {0, 0}, {0, 128}, {1, 8}, {5, 1}, {6, 4}, {1, 8}, {4, 16}, {7, 4}, {8, 2}, {3, 32}, {2, 64}};
    }

    class CharsetEncoderISCII
    extends CharsetEncoderICU {
        public CharsetEncoderISCII(CharsetICU cs) {
            super(cs, CharsetISCII.this.fromUSubstitution);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            CharsetISCII.this.extraInfo.initialize();
        }

        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            int targetByteUnit = 0;
            int sourceChar = 0;
            short newDelta = 0;
            short range = 0;
            boolean deltaChanged = false;
            int tempContextFromUnicode = 0;
            CoderResult cr = CoderResult.UNDERFLOW;
            UConverterDataISCII converterData = CharsetISCII.this.extraInfo;
            newDelta = converterData.currentDeltaFromUnicode;
            range = (short)(newDelta / 128);
            sourceChar = this.fromUChar32;
            if (sourceChar != 0) {
                cr = this.handleSurrogates(source, (char)sourceChar);
                return cr != null ? cr : CoderResult.unmappableForLength(2);
            }
            block4: while (source.hasRemaining()) {
                if (!target.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                if (this.fromUnicodeStatus == 10) {
                    targetByteUnit = 61184;
                    this.fromUnicodeStatus = 0;
                    cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit += (byte)lookupInitialData[range].isciiLang);
                    if (cr.isOverflow()) break;
                }
                sourceChar = source.get();
                tempContextFromUnicode = converterData.contextCharFromUnicode;
                targetByteUnit = 65535;
                if (sourceChar <= 160) {
                    this.fromUnicodeStatus = sourceChar;
                    cr = this.WriteToTargetFromU(offsets, source, target, sourceChar);
                    if (!cr.isOverflow()) continue;
                    break;
                }
                switch (sourceChar) {
                    case 8204: {
                        if (converterData.contextCharFromUnicode != 0) {
                            converterData.contextCharFromUnicode = 0;
                            targetByteUnit = 232;
                            break;
                        }
                        converterData.contextCharFromUnicode = 0;
                        continue block4;
                    }
                    case 8205: {
                        targetByteUnit = converterData.contextCharFromUnicode != 0 ? 233 : 217;
                        converterData.contextCharFromUnicode = 0;
                        break;
                    }
                    default: {
                        if ((char)(3455 - sourceChar) <= '\u047f') {
                            if (sourceChar != 2404 && sourceChar != 2405) {
                                range = (short)((sourceChar - 2304) / 128);
                                newDelta = (short)(range * 128);
                                if (newDelta != converterData.currentDeltaFromUnicode || converterData.isFirstBuffer) {
                                    converterData.currentDeltaFromUnicode = newDelta;
                                    converterData.currentMaskFromUnicode = lookupInitialData[range].maskEnum;
                                    deltaChanged = true;
                                    converterData.isFirstBuffer = false;
                                }
                                if (converterData.currentDeltaFromUnicode == 256) {
                                    if (sourceChar == 2672) {
                                        sourceChar = 2562;
                                    } else if (sourceChar == 2673) {
                                        converterData.contextCharFromUnicode = 2673;
                                    }
                                }
                                sourceChar -= converterData.currentDeltaFromUnicode;
                            }
                            targetByteUnit = fromUnicodeTable[(short)sourceChar & 0xFF];
                            if ((validityTable[(short)sourceChar & 0xFF] & converterData.currentMaskFromUnicode) == 0 && (converterData.currentDeltaFromUnicode != 768 || sourceChar != 2353)) {
                                targetByteUnit = 65535;
                            }
                            if (deltaChanged) {
                                int temp = 0;
                                temp = 61184;
                                temp = (char)(temp + (char)(lookupInitialData[range].isciiLang & 0xFF));
                                deltaChanged = false;
                                cr = this.WriteToTargetFromU(offsets, source, target, temp);
                                if (cr.isOverflow()) break;
                            }
                            if (converterData.currentDeltaFromUnicode == 256 && sourceChar + 256 == 2673) continue block4;
                        }
                        converterData.contextCharFromUnicode = 0;
                    }
                }
                if (converterData.currentDeltaFromUnicode == 256 && tempContextFromUnicode == 2673 && PNJ_CONSONANT_SET.contains(sourceChar + 256)) {
                    converterData.contextCharFromUnicode = 0;
                    cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit = targetByteUnit << 16 | 0xE800 | targetByteUnit);
                    if (!cr.isOverflow()) continue;
                    break;
                }
                if (targetByteUnit != 65535) {
                    if (targetByteUnit == 232) {
                        converterData.contextCharFromUnicode = (char)targetByteUnit;
                    }
                    if (!(cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit)).isOverflow()) continue;
                    break;
                }
                if (UTF16.isSurrogate((char)sourceChar)) {
                    cr = this.handleSurrogates(source, (char)sourceChar);
                    return cr != null ? cr : CoderResult.unmappableForLength(2);
                }
                return CoderResult.unmappableForLength(1);
            }
            return cr;
        }

        private CoderResult WriteToTargetFromU(IntBuffer offsets, CharBuffer source, ByteBuffer target, int targetByteUnit) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int offset = source.position() - 1;
            if (target.hasRemaining()) {
                if (targetByteUnit <= 255) {
                    target.put((byte)targetByteUnit);
                    if (offsets != null) {
                        offsets.put(offset);
                    }
                } else {
                    if (targetByteUnit > 65535) {
                        target.put((byte)(targetByteUnit >> 16));
                        if (offsets != null) {
                            offsets.put(--offset);
                        }
                    }
                    if (!target.hasRemaining()) {
                        this.errorBuffer[this.errorBufferLength++] = (byte)(targetByteUnit >> 8);
                        this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit;
                        cr = CoderResult.OVERFLOW;
                        return cr;
                    }
                    target.put((byte)(targetByteUnit >> 8));
                    if (offsets != null) {
                        offsets.put(offset);
                    }
                    if (target.hasRemaining()) {
                        target.put((byte)targetByteUnit);
                        if (offsets != null) {
                            offsets.put(offset);
                        }
                    } else {
                        this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit;
                        cr = CoderResult.OVERFLOW;
                    }
                }
            } else {
                if (targetByteUnit > 65535) {
                    this.errorBuffer[this.errorBufferLength++] = (byte)(targetByteUnit >> 16);
                } else if ((targetByteUnit & 0xFF00) > 0) {
                    this.errorBuffer[this.errorBufferLength++] = (byte)(targetByteUnit >> 8);
                }
                this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit;
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }
    }

    class CharsetDecoderISCII
    extends CharsetDecoderICU {
        public CharsetDecoderISCII(CharsetICU cs) {
            super(cs);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            this.toUnicodeStatus = 65535;
            CharsetISCII.this.extraInfo.initialize();
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int targetUniChar = 0;
            short sourceChar = 0;
            boolean gotoCallBack = false;
            int offset = 0;
            UConverterDataISCII data = CharsetISCII.this.extraInfo;
            block8: while (source.hasRemaining()) {
                targetUniChar = 65535;
                if (target.hasRemaining()) {
                    sourceChar = (short)((short)source.get() & 0xFF);
                    if (data.contextCharToUnicode == 239) {
                        if (((short)(75 - sourceChar) & 0xFF) <= 9) {
                            data.currentDeltaToUnicode = (short)(lookupTable[sourceChar & 0xF][0] * 128);
                            data.currentMaskToUnicode = lookupTable[sourceChar & 0xF][1];
                        } else if (sourceChar == 64) {
                            data.currentDeltaToUnicode = data.defDeltaToUnicode;
                            data.currentMaskToUnicode = data.defMaskToUnicode;
                        } else if (sourceChar < 33 || sourceChar > 63) {
                            cr = CoderResult.malformedForLength(1);
                            data.contextCharToUnicode = 65534;
                            gotoCallBack = true;
                        }
                        if (!gotoCallBack) {
                            data.contextCharToUnicode = 65534;
                            continue;
                        }
                    } else if (data.contextCharToUnicode == 240) {
                        if (((short)(238 - sourceChar) & 0xFF) <= 77) {
                            if (sourceChar == 191 || sourceChar == 184) {
                                int n = targetUniChar = sourceChar == 191 ? 2416 : 2386;
                                if ((validityTable[(short)targetUniChar & 0xFF] & data.currentMaskToUnicode) > 0) {
                                    data.contextCharToUnicode = 65534;
                                    if (data.prevToUnicodeStatus != 0) {
                                        cr = this.WriteToTargetToU(offsets, source.position() - 1, source, target, data.prevToUnicodeStatus, (short)0);
                                        data.prevToUnicodeStatus = 0;
                                    }
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar, data.currentDeltaToUnicode);
                                    continue;
                                }
                            }
                            targetUniChar = 65535;
                            cr = CoderResult.unmappableForLength(1);
                        } else {
                            data.contextCharToUnicode = 65534;
                            cr = CoderResult.malformedForLength(1);
                        }
                        gotoCallBack = true;
                    } else if (data.contextCharToUnicode == 217) {
                        targetUniChar = sourceChar == 232 ? 32 : 8205;
                        if (data.prevToUnicodeStatus != 0) {
                            cr = this.WriteToTargetToU(offsets, source.position() - 1, source, target, data.prevToUnicodeStatus, (short)0);
                            data.prevToUnicodeStatus = 0;
                        }
                        cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar, data.currentDeltaToUnicode);
                        data.contextCharToUnicode = 65534;
                    }
                    if (!gotoCallBack) {
                        switch (sourceChar) {
                            case 217: 
                            case 239: 
                            case 240: {
                                data.contextCharToUnicode = (char)sourceChar;
                                if (this.toUnicodeStatus == 65535) continue block8;
                                if (data.prevToUnicodeStatus != 0) {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 1, source, target, data.prevToUnicodeStatus, (short)0);
                                    data.prevToUnicodeStatus = 0;
                                }
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus, data.currentDeltaToUnicode);
                                this.toUnicodeStatus = 65535;
                                continue block8;
                            }
                            case 234: {
                                if (data.contextCharToUnicode == 234) {
                                    targetUniChar = 2405;
                                    data.contextCharToUnicode = 65534;
                                    this.toUnicodeStatus = 65535;
                                    break;
                                }
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                                break;
                            }
                            case 232: {
                                if (data.contextCharToUnicode == 232) {
                                    targetUniChar = 8204;
                                    data.contextCharToUnicode = 65534;
                                    break;
                                }
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                                break;
                            }
                            case 10: 
                            case 13: {
                                data.resetToDefaultToUnicode = true;
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                                break;
                            }
                            case 224: {
                                boolean find = false;
                                for (int n = 1; n < vowelSignESpecialCases[0][0]; ++n) {
                                    if (vowelSignESpecialCases[n][0] != ((short)data.contextCharToUnicode & 0xFF)) continue;
                                    targetUniChar = vowelSignESpecialCases[n][1];
                                    find = true;
                                    break;
                                }
                                if (find && (validityTable[(byte)targetUniChar] & data.currentMaskFromUnicode) > 0) {
                                    data.contextCharToUnicode = 65534;
                                    this.toUnicodeStatus = 65535;
                                    break;
                                }
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                                break;
                            }
                            case 233: {
                                if (data.contextCharToUnicode == 232) {
                                    targetUniChar = 8205;
                                    data.contextCharToUnicode = 65534;
                                    break;
                                }
                                if (data.currentDeltaToUnicode == 256 && data.contextCharToUnicode == 192) {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 2652, (short)0);
                                    if (!cr.isOverflow()) {
                                        cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 2637, (short)0);
                                        if (!cr.isOverflow()) {
                                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 2617, (short)0);
                                        } else {
                                            this.charErrorBufferArray[this.charErrorBufferLength++] = 2617;
                                        }
                                    } else {
                                        this.charErrorBufferArray[this.charErrorBufferLength++] = 2637;
                                        this.charErrorBufferArray[this.charErrorBufferLength++] = 2617;
                                    }
                                    this.toUnicodeStatus = 65535;
                                    data.contextCharToUnicode = 65534;
                                    if (cr.isError()) break;
                                    continue block8;
                                }
                                boolean found = false;
                                for (int i = 1; i < nuktaSpecialCases[0][0]; ++i) {
                                    if (nuktaSpecialCases[i][0] != ((short)data.contextCharToUnicode & 0xFF)) continue;
                                    targetUniChar = nuktaSpecialCases[i][1];
                                    found = true;
                                    break;
                                }
                                if (found && (validityTable[(byte)targetUniChar] & data.currentMaskToUnicode) > 0) {
                                    data.contextCharToUnicode = 65534;
                                    this.toUnicodeStatus = 65535;
                                    if (data.currentDeltaToUnicode != 256) break;
                                    if (data.prevToUnicodeStatus != 0) {
                                        cr = this.WriteToTargetToU(offsets, source.position() - 1, source, target, data.prevToUnicodeStatus, (short)0);
                                        data.prevToUnicodeStatus = 0;
                                    }
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar, data.currentDeltaToUnicode);
                                    continue block8;
                                }
                            }
                            default: {
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                            }
                        }
                    }
                    if (!gotoCallBack && this.toUnicodeStatus != 65535) {
                        if (data.currentDeltaToUnicode == 256 && data.prevToUnicodeStatus != 0 && PNJ_CONSONANT_SET.contains(data.prevToUnicodeStatus) && this.toUnicodeStatus + 256 == 2637 && targetUniChar + 256 == data.prevToUnicodeStatus) {
                            if (offsets != null) {
                                offset = source.position() - 3;
                            }
                            cr = this.WriteToTargetToU(offsets, offset, source, target, 2673, (short)0);
                            cr = this.WriteToTargetToU(offsets, offset, source, target, data.prevToUnicodeStatus, (short)0);
                            data.prevToUnicodeStatus = 0;
                            this.toUnicodeStatus = 65535;
                            continue;
                        }
                        if (data.prevToUnicodeStatus != 0) {
                            cr = this.WriteToTargetToU(offsets, source.position() - 1, source, target, data.prevToUnicodeStatus, (short)0);
                            data.prevToUnicodeStatus = 0;
                        }
                        if (data.currentDeltaToUnicode == 256 && targetUniChar + 256 == 2562 && PNJ_BINDI_TIPPI_SET.contains(this.toUnicodeStatus + 256)) {
                            targetUniChar = 2416;
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus, (short)256);
                        } else if (data.currentDeltaToUnicode == 256 && targetUniChar + 256 == 2637 && PNJ_CONSONANT_SET.contains(this.toUnicodeStatus + 256)) {
                            data.prevToUnicodeStatus = this.toUnicodeStatus + 256;
                        } else {
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus, data.currentDeltaToUnicode);
                        }
                        this.toUnicodeStatus = 65535;
                    }
                    if (!gotoCallBack && targetUniChar != 65535) {
                        this.toUnicodeStatus = (char)targetUniChar;
                        if (!data.resetToDefaultToUnicode) continue;
                        data.currentDeltaToUnicode = data.defDeltaToUnicode;
                        data.currentMaskToUnicode = data.defMaskToUnicode;
                        data.resetToDefaultToUnicode = false;
                        continue;
                    }
                    if (!gotoCallBack) {
                        cr = CoderResult.unmappableForLength(1);
                    }
                    this.toUBytesArray[0] = (byte)sourceChar;
                    this.toULength = 1;
                    gotoCallBack = false;
                    break;
                }
                cr = CoderResult.OVERFLOW;
                break;
            }
            if (cr.isUnderflow() && flush && !source.hasRemaining()) {
                if (data.contextCharToUnicode == 239 || data.contextCharToUnicode == 240 || data.contextCharToUnicode == 217) {
                    this.toUBytesArray[0] = (byte)data.contextCharToUnicode;
                    this.toULength = 1;
                    data.contextCharToUnicode = 65534;
                } else {
                    this.toULength = 0;
                }
                if (this.toUnicodeStatus != 65535) {
                    this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus, data.currentDeltaToUnicode);
                    this.toUnicodeStatus = 65535;
                }
            }
            return cr;
        }

        private CoderResult WriteToTargetToU(IntBuffer offsets, int offset, ByteBuffer source, CharBuffer target, int targetUniChar, short delta) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (targetUniChar > 160 && targetUniChar != 8205 && targetUniChar != 8204 && targetUniChar != 2404 && targetUniChar != 2405) {
                targetUniChar += delta;
            }
            if (target.hasRemaining()) {
                target.put((char)targetUniChar);
                if (offsets != null) {
                    offsets.put(offset);
                }
            } else {
                this.charErrorBufferArray[this.charErrorBufferLength++] = (char)targetUniChar;
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }

        private int GetMapping(short sourceChar, int targetUniChar, UConverterDataISCII data) {
            targetUniChar = toUnicodeTable[sourceChar];
            if (sourceChar > 160 && (validityTable[(short)targetUniChar & 0xFF] & data.currentMaskToUnicode) == 0 && (data.currentDeltaToUnicode != 768 || targetUniChar != 2353)) {
                targetUniChar = 65535;
            }
            return targetUniChar;
        }
    }

    private static final class LookupDataStruct {
        short uniLang;
        short maskEnum;
        short isciiLang;

        LookupDataStruct(short uniLang, short maskEnum, short isciiLang) {
            this.uniLang = uniLang;
            this.maskEnum = maskEnum;
            this.isciiLang = isciiLang;
        }
    }

    private final class UConverterDataISCII {
        int option;
        int contextCharToUnicode;
        int contextCharFromUnicode;
        short defDeltaToUnicode;
        short currentDeltaFromUnicode;
        short currentDeltaToUnicode;
        short currentMaskFromUnicode;
        short currentMaskToUnicode;
        short defMaskToUnicode;
        boolean isFirstBuffer;
        boolean resetToDefaultToUnicode;
        String name;
        int prevToUnicodeStatus;

        UConverterDataISCII(int option, String name) {
            this.option = option;
            this.name = name;
            this.initialize();
        }

        void initialize() {
            this.contextCharToUnicode = 65534;
            this.currentDeltaFromUnicode = 0;
            this.defDeltaToUnicode = (short)(lookupInitialData[this.option & 0xF].uniLang * 128);
            this.currentDeltaFromUnicode = (short)(lookupInitialData[this.option & 0xF].uniLang * 128);
            this.currentDeltaToUnicode = (short)(lookupInitialData[this.option & 0xF].uniLang * 128);
            this.currentMaskToUnicode = lookupInitialData[this.option & 0xF].maskEnum;
            this.currentMaskFromUnicode = lookupInitialData[this.option & 0xF].maskEnum;
            this.defMaskToUnicode = lookupInitialData[this.option & 0xF].maskEnum;
            this.isFirstBuffer = true;
            this.resetToDefaultToUnicode = false;
            this.prevToUnicodeStatus = 0;
        }
    }

    private static final class MaskEnum {
        static final short DEV_MASK = 128;
        static final short PNJ_MASK = 64;
        static final short GJR_MASK = 32;
        static final short ORI_MASK = 16;
        static final short BNG_MASK = 8;
        static final short KND_MASK = 4;
        static final short MLM_MASK = 2;
        static final short TML_MASK = 1;
        static final short ZERO = 0;

        private MaskEnum() {
        }
    }

    private static final class ISCIILang {
        static final short DEF = 64;
        static final short RMN = 65;
        static final short DEV = 66;
        static final short BNG = 67;
        static final short TML = 68;
        static final short TLG = 69;
        static final short ASM = 70;
        static final short ORI = 71;
        static final short KND = 72;
        static final short MLM = 73;
        static final short GJR = 74;
        static final short PNJ = 75;
        static final short ARB = 113;
        static final short PES = 114;
        static final short URD = 115;
        static final short SND = 116;
        static final short KSM = 117;
        static final short PST = 118;

        private ISCIILang() {
        }
    }

    private static final class UniLang {
        static final short DEVALANGARI = 0;
        static final short BENGALI = 1;
        static final short GURMUKHI = 2;
        static final short GUJARATI = 3;
        static final short ORIYA = 4;
        static final short TAMIL = 5;
        static final short TELUGU = 6;
        static final short KANNADA = 7;
        static final short MALAYALAM = 8;
        static final short DELTA = 128;

        private UniLang() {
        }
    }
}

