/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.sample.sfntdump;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.table.FontDataTable;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.table.core.PostScriptTable;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SfntDump {
    private boolean countSpecialGlyphs;
    private boolean dumpTableHeadersInFont;
    private boolean dumpNameList;
    private boolean dumpCmapList;
    private boolean cmapMapping;
    private boolean dumpPost;
    private boolean dumpEblc;
    private boolean dumpAllGlyphs;
    private List<String> tablesToBinaryDump = new ArrayList<String>();
    private BitSet glyphSet;
    private boolean dumpAllChars;
    private BitSet charSet;
    private CMapTable.CMapId cmapId = CMapTable.CMapId.WINDOWS_BMP;
    private FontFactory fontFactory = FontFactory.getInstance();
    private static final Pattern RANGE_PATTERN = Pattern.compile("(x?)([\\da-fA-F]{1,5})-(x?)([\\da-fA-F]{1,5})");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(x?)([\\da-fA-F]{1,5})");

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException {
        dumper = new SfntDump();
        fontFile = null;
        optionCount = 0;
        if (!(args.length <= 0 || args[0].equals("-h") || args[0].equals("-help") || args[0].equals("-?"))) {
            fontFile = new File(args[args.length - 1]);
            args = Arrays.copyOfRange(args, 0, args.length - 1);
        } else {
            SfntDump.printUsage();
            System.exit(0);
        }
        i = 0;
        while (i < args.length) {
            block29: {
                block38: {
                    block39: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        option = null;
                                                        if (args[i].charAt(0) == '-') {
                                                            option = args[i].substring(1);
                                                        }
                                                        if (option == null) break block29;
                                                        ++optionCount;
                                                        if (!option.equals("count")) break block30;
                                                        dumper.countSpecialGlyphs(true);
                                                        break block29;
                                                    }
                                                    if (!option.equals("t")) break block31;
                                                    if (i + 1 < args.length) {
                                                        dumper.dumpTablesAsBinary(args[++i]);
                                                    }
                                                    break block29;
                                                }
                                                if (!option.equals("cm")) break block32;
                                                if (i + 1 < args.length) {
                                                    dumper.useCMap(args[++i]);
                                                }
                                                break block29;
                                            }
                                            if (!option.equals("table")) break block33;
                                            dumper.dumpTableList(true);
                                            break block29;
                                        }
                                        if (!option.startsWith("name")) break block34;
                                        dumper.dumpNames(true);
                                        break block29;
                                    }
                                    if (!option.startsWith("cmap")) break block35;
                                    dumper.dumpCMaps(true);
                                    if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                                        dumper.dumpCMaps(args[++i]);
                                    }
                                    break block29;
                                }
                                if (!option.startsWith("post")) break block36;
                                dumper.dumpPost(true);
                                break block29;
                            }
                            if (!option.startsWith("eblc")) break block37;
                            dumper.dumpEblc(true);
                            break block29;
                        }
                        if (!option.equals("glyph") && !option.equals("g")) break block38;
                        glyphSet = null;
                        if (i + 1 < args.length && !args[i + 1].startsWith("-")) break block39;
                        dumper.dumpAllGlyphs(true);
                        break block29;
                    }
                    if (i + 1 < args.length) {
                        if ((glyphSet = SfntDump.parseRange(args[++i])) == null) {
                            glyphSet = SfntDump.parseList(args[i]);
                        }
                        if (glyphSet != null) {
                            dumper.dumpGlyphs(glyphSet);
                        }
                    }
                    if (glyphSet == null) {
                        System.out.println("glyph dump option requires a glyph range or list");
                        System.exit(0);
                    }
                }
                if (!option.equals("char") && !option.equals("c")) ** GOTO lbl81
                charSet = null;
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    dumper.dumpAllChars(true);
                } else {
                    if (i + 1 < args.length) {
                        if ((charSet = SfntDump.parseRange(args[++i])) == null) {
                            charSet = SfntDump.parseList(args[i]);
                        }
                        if (charSet != null) {
                            dumper.dumpChars(charSet);
                        }
                    }
                    if (charSet == null) {
                        System.out.println("character dump option requires a glyph range or list");
                        System.exit(0);
                    }
lbl81:
                    // 4 sources

                    if (option.equals("all") || option.equals("a")) {
                        dumper.dumpAll(true);
                    }
                }
            }
            ++i;
        }
        if (optionCount == 0) {
            dumper.dumpTableList(true);
        }
        if (fontFile != null) {
            if (fontFile.isDirectory()) {
                var8_10 = files = fontFile.listFiles();
                var7_11 = files.length;
                var6_9 = 0;
                while (var6_9 < var7_11) {
                    file = var8_10[var6_9];
                    if (file.isFile() && !file.isHidden()) {
                        try {
                            dumper.dumpFont(file);
                            System.out.println();
                        }
                        catch (Throwable t) {
                            System.out.printf("Error processing file: %s\n", new Object[]{file});
                        }
                    }
                    ++var6_9;
                }
            } else {
                try {
                    dumper.dumpFont(fontFile);
                }
                catch (Throwable t) {
                    System.out.printf("Error processing file: %s\n", new Object[]{fontFile});
                }
            }
        } else {
            SfntDump.printUsage();
            System.exit(0);
        }
    }

    private static final void printUsage() {
        System.out.println("FontDumper [-all|-a] [-table] [-t tag] [-name] [-cmap] [-g|-glyph range|list] [-c|-char range|list] [-?|-h|-help] fontfile | directory");
        System.out.println("dump information about the font file or all fonts in a directory");
        System.out.println("\t-all,-a\t\tdump all information");
        System.out.println("\t-table\t\tdump all table indexes");
        System.out.println("\t-t tag\t\tbinary dump the table with the tag specified if it exists in the font");
        System.out.println("\t-name\t\tdump all name entries");
        System.out.println("\t-cmap [mapping]\t\tdump all cmap subtables");
        System.out.println("\tif 'mapping' specified then dump the character to glyph mapping for the cmap(s)");
        String temp1 = "\t-cm pid,eid\t\tuse the cmap with the given platform id and";
        String temp2 = "encoding id when looking for glyphs from character ids";
        System.out.println(String.valueOf(temp1) + temp2);
        System.out.println("\t-post\t\tdump the PostScript name table");
        System.out.println("\t-eblc\t\tdump the EBLC table - bitmap location");
        System.out.println("\t-g,-glyph\t\tdump the glyphs specified");
        System.out.println("\t-c,-char\t\tdump the characters specified using the Windows English Unicode cmap or the cmap specified with the -cm option");
        System.out.println("\trange\t\ttwo 1 to 4 digit numbers seperated by a hyphen that are optionally preceded by an x indicating hex - e.g. x12-234");
        System.out.println("\tlist\t\tone or more 1 to 4 digit numbers seperated commas that are optionally preceded by an x indicating hex - e.g. x12,234,666,x1234");
        System.out.println("\t-?,-h,-help\tprint this help information");
    }

    private static final BitSet parseRange(String range) {
        BitSet set = null;
        Matcher m = RANGE_PATTERN.matcher(range);
        if (m.matches()) {
            int low = Integer.parseInt(m.group(2), m.group(1).equals("") ? 10 : 16);
            int high = Integer.parseInt(m.group(4), m.group(3).equals("") ? 10 : 16);
            set = new BitSet();
            set.set(low, high + 1);
        }
        return set;
    }

    private static final BitSet parseList(String list) {
        BitSet set = null;
        String[] items = list.split(",");
        if (items.length == 0) {
            return null;
        }
        set = new BitSet();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            Matcher m = NUMBER_PATTERN.matcher(item);
            if (!m.matches()) {
                return null;
            }
            int itemNumber = Integer.parseInt(m.group(2), m.group(1).equals("") ? 10 : 16);
            set.set(itemNumber);
            ++n2;
        }
        return set;
    }

    public void countSpecialGlyphs(boolean count) {
        this.countSpecialGlyphs = count;
    }

    public void dumpTableList(boolean dumpTableList) {
        this.dumpTableHeadersInFont = dumpTableList;
    }

    public void dumpCMaps(boolean dumpCMaps) {
        this.dumpCmapList = dumpCMaps;
    }

    public void dumpCMaps(String option) {
        if (option.equals("mapping")) {
            this.cmapMapping = true;
        }
    }

    public void dumpNames(boolean dumpNames) {
        this.dumpNameList = dumpNames;
    }

    public void dumpPost(boolean dumpPost) {
        this.dumpPost = dumpPost;
    }

    public void dumpEblc(boolean dumpEblc) {
        this.dumpEblc = dumpEblc;
    }

    public void dumpAll(boolean dumpAll) {
        this.dumpCMaps(dumpAll);
        this.dumpNames(dumpAll);
        this.dumpPost(dumpAll);
        this.dumpTableList(dumpAll);
    }

    public void dumpGlyphs(BitSet set) {
        this.glyphSet = set;
    }

    public void dumpAllGlyphs(boolean dumpAllGlyphs) {
        this.dumpAllGlyphs = dumpAllGlyphs;
    }

    public void dumpAllChars(boolean dumpAll) {
        this.dumpAllChars = dumpAll;
    }

    public void dumpChars(BitSet set) {
        this.charSet = set;
    }

    public void dumpTablesAsBinary(String tableTag) {
        this.tablesToBinaryDump.add(tableTag);
    }

    public void useCMap(String cmap) {
        String[] cmapParams = cmap.split("\\D");
        this.cmapId = CMapTable.CMapId.getInstance(Integer.parseInt(cmapParams[0]), Integer.parseInt(cmapParams[1]));
    }

    public void dumpFont(File fontFile) throws IOException {
        boolean canDumpGlyphs = true;
        System.out.println(fontFile + " ============================");
        try (FileInputStream fis = null;){
            fis = new FileInputStream(fontFile);
            Font[] fontArray = this.fontFactory.loadFonts(fis);
            int fontNumber = 0;
            while (fontNumber < fontArray.length) {
                Font font = fontArray[fontNumber];
                if (fontArray.length > 1) {
                    System.out.println("\n======= TTC Entry #" + fontNumber + "\n");
                }
                if (this.dumpTableHeadersInFont) {
                    for (Map.Entry<Integer, ? extends Table> entry : font.tableMap().entrySet()) {
                        System.out.println(entry.getValue().header());
                    }
                }
                if (this.countSpecialGlyphs) {
                    this.countSpecialGlyphs(font);
                }
                if (this.dumpNameList) {
                    System.out.println("\n----- Name Tables");
                    NameTable name = (NameTable)font.getTable(Tag.name);
                    for (NameTable.NameEntry entry : name) {
                        System.out.println(entry);
                    }
                }
                if (this.dumpCmapList) {
                    System.out.println("\n------ CMap Tables");
                    CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
                    for (CMap cmap : cmapTable) {
                        System.out.println(cmap);
                        if (!this.cmapMapping) continue;
                        this.dumpCMapMapping(cmap);
                    }
                }
                if (this.dumpPost) {
                    System.out.println("\n------ Post Table");
                    PostScriptTable post = (PostScriptTable)font.getTable(Tag.post);
                    int nGlyphs = post.numberOfGlyphs();
                    int glyphId = 0;
                    while (glyphId < nGlyphs) {
                        System.out.printf("%d: %s\n", glyphId, post.glyphName(glyphId));
                        ++glyphId;
                    }
                }
                if (this.dumpEblc) {
                    System.out.println("\n------ EBLC Table");
                    EblcTable eblcTable = (EblcTable)font.getTable(Tag.EBLC);
                    System.out.println(eblcTable.toString());
                }
                if (this.tablesToBinaryDump.size() > 0) {
                    for (String tag : this.tablesToBinaryDump) {
                        int tableTag = Tag.intValue(tag);
                        Object table = font.getTable(tableTag);
                        if (table == null) continue;
                        System.out.println("\n------ Dump Data - Table = " + tag + ", length = " + Integer.toHexString(((FontDataTable)table).dataLength()));
                        ReadableFontData data = ((FontDataTable)table).readFontData();
                        int i = 0;
                        while (i < data.length()) {
                            System.out.printf("%08x: ", i);
                            int j = i;
                            while (j < i + 16 && j < data.length()) {
                                System.out.printf("%02x ", data.readUByte(j));
                                ++j;
                            }
                            System.out.println();
                            i += 16;
                        }
                        System.out.println();
                    }
                }
                LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
                GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
                if (locaTable == null) {
                    canDumpGlyphs = false;
                    System.out.println("PROBLEM: font has no 'loca' table.");
                }
                if (glyphTable == null) {
                    canDumpGlyphs = false;
                    System.out.println("PROBLEM: font has no 'glyf' table.");
                }
                if (canDumpGlyphs && this.glyphSet != null) {
                    System.out.println("\n------ Glyphs");
                    int glyphId = this.glyphSet.nextSetBit(0);
                    while (glyphId >= 0) {
                        int offset = locaTable.glyphOffset(glyphId);
                        int length = locaTable.glyphLength(glyphId);
                        Glyph glyph = glyphTable.glyph(offset, length);
                        System.out.println("glyph id = " + glyphId);
                        if (glyph != null) {
                            System.out.println(glyph);
                        }
                        glyphId = this.glyphSet.nextSetBit(glyphId + 1);
                    }
                }
                if (canDumpGlyphs && this.charSet != null) {
                    this.dumpChars(font, locaTable, glyphTable);
                }
                ++fontNumber;
            }
        }
    }

    private void dumpChars(Font font, LocaTable locaTable, GlyphTable glyphTable) {
        block5: {
            CMap cmap;
            block4: {
                CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
                if (cmapTable == null) {
                    System.out.println("PROBLEM: font has no 'cmap' table.");
                    return;
                }
                cmap = cmapTable.cmap(this.cmapId);
                if (cmap == null) {
                    System.out.println("PROBLEM: required cmap subtable not available.");
                    return;
                }
                System.out.println("\n=============\n" + cmap);
                if (!this.dumpAllChars) break block4;
                Iterator iterator = cmap.iterator();
                while (iterator.hasNext()) {
                    int charId = (Integer)iterator.next();
                    this.dumpChar(charId, cmap, locaTable, glyphTable);
                }
                break block5;
            }
            if (this.charSet == null) break block5;
            System.out.println("\n------ Characters");
            int charId = this.charSet.nextSetBit(0);
            while (charId >= 0) {
                this.dumpChar(charId, cmap, locaTable, glyphTable);
                charId = this.charSet.nextSetBit(charId + 1);
            }
        }
    }

    private void dumpChar(int charId, CMap cmap, LocaTable locaTable, GlyphTable glyphTable) {
        int glyphId = cmap.glyphId(charId);
        int offset = locaTable.glyphOffset(glyphId);
        int length = locaTable.glyphLength(glyphId);
        Glyph glyph = glyphTable.glyph(offset, length);
        System.out.println("char = 0x" + Integer.toHexString(charId) + ", glyph id = 0x" + Integer.toHexString(glyphId));
        if (glyph != null) {
            System.out.println(glyph);
        } else {
            System.out.println();
        }
    }

    private void countSpecialGlyphs(Font font) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        int count = 0;
        int glyphId = 0;
        while (glyphId < locaTable.numGlyphs()) {
            SimpleGlyph simple;
            int length;
            int offset = locaTable.glyphOffset(glyphId);
            Glyph glyph = glyphTable.glyph(offset, length = locaTable.glyphLength(glyphId));
            if (glyph instanceof SimpleGlyph && (simple = (SimpleGlyph)glyph).numberOfContours() == 2 && (simple.numberOfPoints(0) == 1 || simple.numberOfPoints(1) == 1)) {
                ++count;
            }
            ++glyphId;
        }
        System.out.println("\n------ Special Glyph Count");
        System.out.println("\ttotal glyphs = " + locaTable.numGlyphs());
        System.out.println("\tspecial glyphs = " + count);
    }

    private void dumpCMapMapping(CMap cmap) {
        Iterator iter = cmap.iterator();
        while (iter.hasNext()) {
            int c = (Integer)iter.next();
            int g = cmap.glyphId(c);
            if (g == 0) continue;
            System.out.printf("%x -> %x\n", c, g);
        }
    }
}

