/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.sample.sfview;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.sample.sfview.TaggedData;
import com.google.typography.font.sfntly.table.FontDataTable;
import com.google.typography.font.sfntly.table.opentype.AlternateSubst;
import com.google.typography.font.sfntly.table.opentype.ChainContextSubst;
import com.google.typography.font.sfntly.table.opentype.ClassDefTable;
import com.google.typography.font.sfntly.table.opentype.ContextSubst;
import com.google.typography.font.sfntly.table.opentype.CoverageTable;
import com.google.typography.font.sfntly.table.opentype.ExtensionSubst;
import com.google.typography.font.sfntly.table.opentype.FeatureListTable;
import com.google.typography.font.sfntly.table.opentype.FeatureTable;
import com.google.typography.font.sfntly.table.opentype.GSubTable;
import com.google.typography.font.sfntly.table.opentype.LangSysTable;
import com.google.typography.font.sfntly.table.opentype.LigatureSubst;
import com.google.typography.font.sfntly.table.opentype.LookupListTable;
import com.google.typography.font.sfntly.table.opentype.LookupTable;
import com.google.typography.font.sfntly.table.opentype.MultipleSubst;
import com.google.typography.font.sfntly.table.opentype.NullTable;
import com.google.typography.font.sfntly.table.opentype.ReverseChainSingleSubst;
import com.google.typography.font.sfntly.table.opentype.ScriptListTable;
import com.google.typography.font.sfntly.table.opentype.ScriptTable;
import com.google.typography.font.sfntly.table.opentype.SingleSubst;
import com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubClassRule;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubClassSet;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubRule;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubRuleSet;
import com.google.typography.font.sfntly.table.opentype.classdef.InnerArrayFmt1;
import com.google.typography.font.sfntly.table.opentype.component.HeaderTable;
import com.google.typography.font.sfntly.table.opentype.component.NumRecordTable;
import com.google.typography.font.sfntly.table.opentype.component.OneToManySubst;
import com.google.typography.font.sfntly.table.opentype.component.RangeRecordTable;
import com.google.typography.font.sfntly.table.opentype.contextsubst.DoubleRecordTable;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubClassRule;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubClassSet;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubGenericRuleSet;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubRule;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubRuleSet;
import com.google.typography.font.sfntly.table.opentype.ligaturesubst.Ligature;
import com.google.typography.font.sfntly.table.opentype.ligaturesubst.LigatureSet;
import com.google.typography.font.sfntly.table.opentype.singlesubst.HeaderFmt1;
import com.google.typography.font.sfntly.table.opentype.singlesubst.InnerArrayFmt2;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class OtTableTagger {
    private final TaggedData td;
    private final Map<Class<? extends FontDataTable>, TagMethod> tagMethodRegistry;
    private final List<String> tableCache = new ArrayList<String>();
    private static final Comparator<Class<? extends FontDataTable>> CLASS_NAME_COMPARATOR = new Comparator<Class<? extends FontDataTable>>(){

        @Override
        public int compare(Class<? extends FontDataTable> o1, Class<? extends FontDataTable> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static Set<Class<? extends FontDataTable>> missedClasses = new TreeSet<Class<? extends FontDataTable>>(CLASS_NAME_COMPARATOR);

    OtTableTagger(TaggedData tdata) {
        this.td = tdata;
        this.tagMethodRegistry = new HashMap<Class<? extends FontDataTable>, TagMethod>();
        this.registerTagMethods();
    }

    void tag(GSubTable gsub) {
        if (gsub == null) {
            return;
        }
        this.tagTable(gsub.scriptList());
        this.tagTable(gsub.featureList());
        this.tagTable(gsub.lookupList());
    }

    private void tagTable(FontDataTable table) {
        if (table == null) {
            return;
        }
        ReadableFontData data = table.readFontData();
        if (data == null) {
            return;
        }
        if (this.tableCache.contains(table.toString())) {
            return;
        }
        this.tableCache.add(table.toString());
        TagMethod tm = this.getTagMethod(table);
        if (tm == null) {
            this.td.pushRange(table.getClass().getSimpleName(), data);
        } else {
            this.td.pushRange(tm.tableLabel(table), data);
            tm.tag(table);
        }
        this.td.popRange();
    }

    private void register(TagMethod m) {
        this.tagMethodRegistry.put(m.clzz, m);
    }

    @SafeVarargs
    private final void register(TagMethod m, Class<? extends FontDataTable> ... clzzes) {
        this.tagMethodRegistry.put(m.clzz, m);
        Class<? extends FontDataTable>[] classArray = clzzes;
        int n = clzzes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends FontDataTable> clzz = classArray[n2];
            this.tagMethodRegistry.put(clzz, m);
            ++n2;
        }
    }

    void registerTagMethods() {
        this.register(new TagMethod(this, ScriptListTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ScriptListTable table = (ScriptListTable)fdt;
                int scriptCount = td.tagRangeField(TaggedData.FieldType.SHORT, "script count");
                int i = 0;
                while (i < scriptCount) {
                    td.tagRangeField(TaggedData.FieldType.TAG, null);
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                for (ScriptTable st : table) {
                    this.tagTable(st);
                }
            }
        });
        this.register(new TagMethod(this, ScriptTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ScriptTable table = (ScriptTable)fdt;
                td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "default lang sys");
                int langCount = td.tagRangeField(TaggedData.FieldType.SHORT, "language count");
                int i = 0;
                while (i < langCount) {
                    td.tagRangeField(TaggedData.FieldType.TAG, null);
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                for (LangSysTable lst : table) {
                    this.tagTable(lst);
                }
                this.tagTable(table.defaultLangSysTable());
            }
        });
        this.register(new TagMethod(this, LangSysTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                LangSysTable table = (LangSysTable)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT_IGNORED, "lookup order");
                td.tagRangeField(TaggedData.FieldType.SHORT_IGNORED_FFFF, "required feature");
                td.tagRangeField(TaggedData.FieldType.SHORT, "feature count");
                int i = 0;
                while (i < table.recordList.count()) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, null);
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, FeatureListTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                FeatureListTable table = (FeatureListTable)fdt;
                int featureCount = td.tagRangeField(TaggedData.FieldType.SHORT, "feature count");
                int i = 0;
                while (i < featureCount) {
                    td.tagRangeField(TaggedData.FieldType.TAG, "index: " + i);
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                for (FeatureTable ft : table) {
                    this.tagTable(ft);
                }
            }
        });
        this.register(new TagMethod(this, FeatureTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                FeatureTable table = (FeatureTable)fdt;
                td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "feature params");
                td.tagRangeField(TaggedData.FieldType.SHORT, "lookup count");
                int i = 0;
                while (i < table.recordList.count()) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, null);
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, LookupListTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                LookupListTable table = (LookupListTable)fdt;
                int lookupCount = td.tagRangeField(TaggedData.FieldType.SHORT, "lookup count");
                int i = 0;
                while (i < lookupCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET, "index: " + i);
                    ++i;
                }
                i = 0;
                while (i < lookupCount) {
                    LookupTable lookup = (LookupTable)table.subTableAt(i);
                    if (lookup != null) {
                        this.tagTable(lookup);
                    }
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, LookupTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                LookupTable table = (LookupTable)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "lookup type");
                td.tagRangeField(TaggedData.FieldType.SHORT, "lookup flags");
                int subTableCount = td.tagRangeField(TaggedData.FieldType.SHORT, "subtable count");
                int i = 0;
                while (i < subTableCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                i = 0;
                while (i < subTableCount) {
                    SubstSubtable subTable = (SubstSubtable)table.subTableAt(i);
                    this.tagTable(subTable);
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, LigatureSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                LigatureSubst table = (LigatureSubst)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                this.tagTable(table.coverage());
                td.tagRangeField(TaggedData.FieldType.SHORT, "subtable count");
                int subTableCount = table.subTableCount();
                int i = 0;
                while (i < subTableCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                i = 0;
                while (i < subTableCount) {
                    LigatureSet subTable = table.subTableAt(i);
                    this.tagTable(subTable);
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, LigatureSet.class){

            @Override
            protected void tag(FontDataTable fdt) {
                LigatureSet table = (LigatureSet)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "lookup count");
                int i = 0;
                while (i < table.recordList.count()) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                i = 0;
                while (i < table.recordList.count()) {
                    Ligature lookup = (Ligature)table.subTableAt(i);
                    if (lookup != null) {
                        this.tagTable(lookup);
                    }
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, Ligature.class){

            @Override
            protected void tag(FontDataTable fdt) {
                Ligature table = (Ligature)fdt;
                td.tagRangeField(TaggedData.FieldType.GLYPH, "lig glyph");
                td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count + 1");
                int i = 0;
                while (i < table.recordList.count()) {
                    td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, SingleSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                SingleSubst table = (SingleSubst)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "format");
                switch (table.format) {
                    case 1: {
                        HeaderFmt1 tableFmt1 = table.fmt1Table();
                        td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                        this.tagTable(tableFmt1.coverage);
                        td.tagRangeField(TaggedData.FieldType.SHORT, "delta glyph id");
                        break;
                    }
                    case 2: {
                        InnerArrayFmt2 tableFmt2 = table.fmt2Table();
                        td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                        this.tagTable(tableFmt2.coverage);
                        td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count");
                        int i = 0;
                        while (i < tableFmt2.recordList.count()) {
                            td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                            ++i;
                        }
                        break;
                    }
                }
            }
        });
        this.register(new TagMethod(this, MultipleSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                OneToManySubst table = (OneToManySubst)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                this.tagTable(table.coverage());
                td.tagRangeField(TaggedData.FieldType.SHORT, "sequence count");
                int subTableCount = table.recordList().count();
                int i = 0;
                while (i < subTableCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                i = 0;
                while (i < subTableCount) {
                    NumRecordTable subTable = table.subTableAt(i);
                    this.tagTable(subTable);
                    ++i;
                }
            }
        }, AlternateSubst.class);
        this.register(new TagMethod(this, NumRecordTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                NumRecordTable table = (NumRecordTable)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count");
                int i = 0;
                while (i < table.recordList.count()) {
                    td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, ContextSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ContextSubst table = (ContextSubst)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                this.tagTable(table.coverage());
                if (table.format == 2) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "class def offset");
                    this.tagTable(table.classDef());
                }
                td.tagRangeField(TaggedData.FieldType.SHORT, "sub rule set count");
                int subTableCount = table.recordList().count();
                int i = 0;
                while (i < subTableCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "for inital class: " + i);
                    ++i;
                }
                i = 0;
                while (i < subTableCount) {
                    SubGenericRuleSet<? extends DoubleRecordTable> subTable = table.subTableAt(i);
                    if (subTable != null) {
                        this.tagTable(subTable);
                    }
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, SubRuleSet.class){

            @Override
            protected void tag(FontDataTable fdt) {
                SubGenericRuleSet table = (SubGenericRuleSet)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "sub rule count");
                int subTableCount = table.recordList.count();
                int i = 0;
                while (i < subTableCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                i = 0;
                while (i < subTableCount) {
                    DoubleRecordTable subTable = (DoubleRecordTable)table.subTableAt(i);
                    this.tagTable(subTable);
                    ++i;
                }
            }
        }, SubClassSet.class);
        this.register(new TagMethod(this, SubRule.class){

            @Override
            protected void tag(FontDataTable fdt) {
                SubRule table = (SubRule)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "input glyph count + 1");
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                int glyphCount = table.inputGlyphs.count();
                int i = 0;
                while (i < glyphCount) {
                    td.tagRangeField(TaggedData.FieldType.GLYPH, "glyph id");
                    ++i;
                }
                int lookupCount = table.lookupRecords.count();
                int i2 = 0;
                while (i2 < lookupCount) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                    td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                    ++i2;
                }
            }
        });
        this.register(new TagMethod(this, SubClassRule.class){

            @Override
            protected void tag(FontDataTable fdt) {
                SubClassRule table = (SubClassRule)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "input class count + 1");
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                int glyphCount = table.inputGlyphs.count();
                int i = 0;
                while (i < glyphCount) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, "class id");
                    ++i;
                }
                int lookupCount = table.lookupRecords.count();
                int i2 = 0;
                while (i2 < lookupCount) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                    td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                    ++i2;
                }
            }
        });
        this.register(new TagMethod(this, ChainContextSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                HeaderTable subTable;
                int i;
                int subTableCount;
                ChainContextSubst table = (ChainContextSubst)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                if (table.format == 1 || table.format == 2) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                    this.tagTable(table.coverage());
                    subTableCount = table.recordList().count();
                    if (table.format == 1) {
                        td.tagRangeField(TaggedData.FieldType.SHORT, "chain sub rule set count");
                    }
                    if (table.format == 2) {
                        td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "backtrack class def offset");
                        this.tagTable(table.backtrackClassDef());
                        td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "input class def offset");
                        this.tagTable(table.inputClassDef());
                        td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "look ahead class def offset");
                        this.tagTable(table.lookAheadClassDef());
                        td.tagRangeField(TaggedData.FieldType.SHORT, "chain sub class set count");
                    }
                    i = 0;
                    while (i < subTableCount) {
                        td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                        ++i;
                    }
                    i = 0;
                    while (i < subTableCount) {
                        subTable = table.subTableAt(i);
                        if (subTable != null) {
                            this.tagTable(subTable);
                        }
                        ++i;
                    }
                }
                if (table.format == 3) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, "backtrackGlyphs coverage count");
                    subTableCount = table.fmt3Array.backtrackGlyphs.recordList.count();
                    i = 0;
                    while (i < subTableCount) {
                        td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                        subTable = (CoverageTable)table.fmt3Array.backtrackGlyphs.subTableAt(i);
                        if (subTable != null) {
                            this.tagTable(subTable);
                        }
                        ++i;
                    }
                    td.tagRangeField(TaggedData.FieldType.SHORT, "input glyphs coverage count");
                    subTableCount = table.fmt3Array.inputGlyphs.recordList.count();
                    i = 0;
                    while (i < subTableCount) {
                        td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                        subTable = (CoverageTable)table.fmt3Array.inputGlyphs.subTableAt(i);
                        if (subTable != null) {
                            this.tagTable(subTable);
                        }
                        ++i;
                    }
                    td.tagRangeField(TaggedData.FieldType.SHORT, "lookahead glyphs coverage count");
                    subTableCount = table.fmt3Array.lookAheadGlyphs.recordList.count();
                    i = 0;
                    while (i < subTableCount) {
                        td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                        subTable = (CoverageTable)table.fmt3Array.lookAheadGlyphs.subTableAt(i);
                        if (subTable != null) {
                            this.tagTable(subTable);
                        }
                        ++i;
                    }
                    td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                    int lookupCount = table.fmt3Array.lookupRecords.count();
                    int i2 = 0;
                    while (i2 < lookupCount) {
                        td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                        td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                        ++i2;
                    }
                }
            }
        });
        this.register(new TagMethod(this, ChainSubRuleSet.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ChainSubRuleSet table = (ChainSubRuleSet)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "sub rule count");
                int subTableCount = table.recordList.count();
                int i = 0;
                while (i < subTableCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                i = 0;
                while (i < subTableCount) {
                    ChainSubRule subTable = (ChainSubRule)table.subTableAt(i);
                    this.tagTable(subTable);
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, ChainSubRule.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ChainSubRule table = (ChainSubRule)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "backtrack glyph count");
                int glyphCount = table.backtrackGlyphs.count();
                int i = 0;
                while (i < glyphCount) {
                    td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                    ++i;
                }
                td.tagRangeField(TaggedData.FieldType.SHORT, "input glyph count");
                glyphCount = table.inputClasses.count();
                i = 0;
                while (i < glyphCount) {
                    td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                    ++i;
                }
                td.tagRangeField(TaggedData.FieldType.SHORT, "look ahead glyph count");
                glyphCount = table.lookAheadGlyphs.count();
                i = 0;
                while (i < glyphCount) {
                    td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                    ++i;
                }
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                int lookupCount = table.lookupRecords.count();
                int i2 = 0;
                while (i2 < lookupCount) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                    td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                    ++i2;
                }
            }
        });
        this.register(new TagMethod(this, ChainSubClassSet.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ChainSubClassSet table = (ChainSubClassSet)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "sub class count");
                int subTableCount = table.recordList.count();
                int i = 0;
                while (i < subTableCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                    ++i;
                }
                i = 0;
                while (i < subTableCount) {
                    ChainSubClassRule subTable = (ChainSubClassRule)table.subTableAt(i);
                    this.tagTable(subTable);
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, ChainSubClassRule.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ChainSubClassRule table = (ChainSubClassRule)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "backtrack glyph class count");
                int glyphCount = table.backtrackGlyphs.count();
                int i = 0;
                while (i < glyphCount) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, "class id");
                    ++i;
                }
                td.tagRangeField(TaggedData.FieldType.SHORT, "input glyph class count");
                glyphCount = table.inputClasses.count();
                i = 0;
                while (i < glyphCount) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, "class id");
                    ++i;
                }
                td.tagRangeField(TaggedData.FieldType.SHORT, "look ahead glyph class count");
                glyphCount = table.lookAheadGlyphs.count();
                i = 0;
                while (i < glyphCount) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, "class id");
                    ++i;
                }
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                int lookupCount = table.lookupRecords.count();
                int i2 = 0;
                while (i2 < lookupCount) {
                    td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                    td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                    ++i2;
                }
            }
        });
        this.register(new TagMethod(this, ExtensionSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ExtensionSubst table = (ExtensionSubst)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "format");
                td.tagRangeField(TaggedData.FieldType.SHORT, "lookup type");
                td.tagRangeField(TaggedData.FieldType.OFFSET32, "lookup offset");
                SubstSubtable subTable = table.subTable();
                this.tagTable(subTable);
            }
        });
        this.register(new TagMethod(this, ReverseChainSingleSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                CoverageTable subTable;
                ReverseChainSingleSubst table = (ReverseChainSingleSubst)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "input coverage offset");
                this.tagTable(table.coverage);
                td.tagRangeField(TaggedData.FieldType.SHORT, "backtrack glyphs coverages count");
                int subTableCount = table.backtrackGlyphs.recordList.count();
                int i = 0;
                while (i < subTableCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                    subTable = (CoverageTable)table.backtrackGlyphs.subTableAt(i);
                    if (subTable != null) {
                        this.tagTable(subTable);
                    }
                    ++i;
                }
                td.tagRangeField(TaggedData.FieldType.SHORT, "lookahead glyphs coverages count");
                subTableCount = table.lookAheadGlyphs.recordList.count();
                i = 0;
                while (i < subTableCount) {
                    td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                    subTable = (CoverageTable)table.lookAheadGlyphs.subTableAt(i);
                    if (subTable != null) {
                        this.tagTable(subTable);
                    }
                    ++i;
                }
                td.tagRangeField(TaggedData.FieldType.SHORT, "subst glyph count");
                i = 0;
                while (i < table.substitutes.recordList.count()) {
                    td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                    ++i;
                }
            }
        });
        this.register(new TagMethod(this, CoverageTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                CoverageTable table = (CoverageTable)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "format");
                if (table.format == 1) {
                    NumRecordTable tableFmt1 = (NumRecordTable)table.array;
                    td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count");
                    i = 0;
                    while (i < tableFmt1.recordList.count()) {
                        td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                        ++i;
                    }
                }
                if (table.format == 2) {
                    RangeRecordTable tableFmt2 = (RangeRecordTable)table.array;
                    td.tagRangeField(TaggedData.FieldType.SHORT, "range count");
                    i = 0;
                    while (i < tableFmt2.recordList.count()) {
                        td.tagRangeField(TaggedData.FieldType.SHORT, "start");
                        td.tagRangeField(TaggedData.FieldType.SHORT, "end");
                        td.tagRangeField(TaggedData.FieldType.SHORT, "offset");
                        ++i;
                    }
                }
            }
        });
        this.register(new TagMethod(this, ClassDefTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                ClassDefTable table = (ClassDefTable)fdt;
                td.tagRangeField(TaggedData.FieldType.SHORT, "format");
                if (table.format == 1) {
                    InnerArrayFmt1 tableFmt1 = (InnerArrayFmt1)table.array;
                    td.tagRangeField(TaggedData.FieldType.SHORT, "start glyph");
                    td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count");
                    i = 0;
                    while (i < tableFmt1.recordList.count()) {
                        td.tagRangeField(TaggedData.FieldType.SHORT, null);
                        ++i;
                    }
                }
                if (table.format == 2) {
                    RangeRecordTable tableFmt2 = (RangeRecordTable)table.array;
                    td.tagRangeField(TaggedData.FieldType.SHORT, "class range count");
                    i = 0;
                    while (i < tableFmt2.recordList.count()) {
                        td.tagRangeField(TaggedData.FieldType.SHORT, "start");
                        td.tagRangeField(TaggedData.FieldType.SHORT, "end");
                        td.tagRangeField(TaggedData.FieldType.SHORT, "class");
                        ++i;
                    }
                }
            }
        });
        this.register(new TagMethod(this, NullTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
            }
        });
    }

    private TagMethod getTagMethod(FontDataTable table) {
        Class<?> clzz = table.getClass();
        TagMethod tm = this.tagMethodRegistry.get(clzz);
        if (tm == null && !missedClasses.contains(clzz)) {
            missedClasses.add(clzz);
            System.out.println("unregistered class: " + clzz.getName());
        }
        return tm;
    }

    abstract class TagMethod {
        private final Class<? extends FontDataTable> clzz;

        private TagMethod(Class<? extends FontDataTable> clzz) {
            this.clzz = clzz;
        }

        private String tableLabel(FontDataTable table) {
            Class<?> clzz = table.getClass();
            Class<?> encl = clzz.getEnclosingClass();
            if (encl == null) {
                return clzz.getSimpleName();
            }
            return String.valueOf(encl.getSimpleName()) + "." + clzz.getSimpleName();
        }

        protected abstract void tag(FontDataTable var1);
    }
}

