/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import com.google.typography.font.sfntly.testutils.TestUtils;
import java.io.File;
import junit.framework.TestCase;

public class NameEditingTests
extends TestCase {
    private static final File fontFile = TestFont.TestFontNames.OPENSANS.getFile();

    public NameEditingTests(String name) {
        super(name);
    }

    public void testChangeOneName() throws Exception {
        String newName = "Timothy";
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(fontFile);
        NameTable.Builder nameBuilder = (NameTable.Builder)fontBuilder.getTableBuilder(Tag.name);
        NameTable.NameEntryBuilder neb = nameBuilder.nameBuilder(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), NameTable.NameId.FontFamilyName.value());
        neb.setName(newName);
        Font font = fontBuilder.build();
        File serializedFontFile = TestFontUtils.serializeFont(font, TestUtils.extension(fontFile));
        Font[] serializedFontArray = TestFontUtils.loadFont(serializedFontFile);
        font = serializedFontArray[0];
        NameTable nameTable = (NameTable)font.getTable(Tag.name);
        String name = nameTable.name(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), NameTable.NameId.FontFamilyName.value());
        NameEditingTests.assertTrue(name != null);
        NameEditingTests.assertEquals(newName, name);
    }

    public void testModifyNameTableAndRevert() throws Exception {
        String newName = "Timothy";
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(fontFile);
        NameTable.Builder nameBuilder = (NameTable.Builder)fontBuilder.getTableBuilder(Tag.name);
        NameTable.NameEntryBuilder neb = nameBuilder.nameBuilder(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), NameTable.NameId.FontFamilyName.value());
        String originalName = neb.name();
        neb.setName(newName);
        nameBuilder.revertNames();
        Font font = fontBuilder.build();
        File serializedFontFile = TestFontUtils.serializeFont(font, TestUtils.extension(fontFile));
        Font[] serializedFontArray = TestFontUtils.loadFont(serializedFontFile);
        font = serializedFontArray[0];
        NameTable nameTable = (NameTable)font.getTable(Tag.name);
        String name = nameTable.name(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), NameTable.NameId.FontFamilyName.value());
        NameEditingTests.assertTrue(name != null);
        NameEditingTests.assertEquals(originalName, name);
    }

    public void testRemoveOneName() throws Exception {
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(fontFile);
        NameTable.Builder nameBuilder = (NameTable.Builder)fontBuilder.getTableBuilder(Tag.name);
        NameEditingTests.assertTrue(nameBuilder.has(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), NameTable.NameId.FontFamilyName.value()));
        NameEditingTests.assertTrue(nameBuilder.remove(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), NameTable.NameId.FontFamilyName.value()));
        Font font = fontBuilder.build();
        File serializedFontFile = TestFontUtils.serializeFont(font, TestUtils.extension(fontFile));
        Font[] serializedFontArray = TestFontUtils.loadFont(serializedFontFile);
        font = serializedFontArray[0];
        NameTable nameTable = (NameTable)font.getTable(Tag.name);
        String name = nameTable.name(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), NameTable.NameId.FontFamilyName.value());
        NameEditingTests.assertTrue(name == null);
    }

    public void testClearAllNamesAndSetOne() throws Exception {
        String newName = "Fred";
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(fontFile);
        NameTable.Builder nameBuilder = (NameTable.Builder)fontBuilder.getTableBuilder(Tag.name);
        NameEditingTests.assertFalse(nameBuilder.builderCount() == 0);
        nameBuilder.clear();
        NameEditingTests.assertEquals(0, nameBuilder.builderCount());
        NameTable.NameEntryBuilder neb = nameBuilder.nameBuilder(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), NameTable.NameId.FontFamilyName.value());
        neb.setName(newName);
        Font font = fontBuilder.build();
        File serializedFontFile = TestFontUtils.serializeFont(font, TestUtils.extension(fontFile));
        Font[] serializedFontArray = TestFontUtils.loadFont(serializedFontFile);
        font = serializedFontArray[0];
        NameTable nameTable = (NameTable)font.getTable(Tag.name);
        nameTable.nameCount();
        String name = nameTable.name(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), NameTable.WindowsLanguageId.English_UnitedStates.value(), NameTable.NameId.FontFamilyName.value());
        NameEditingTests.assertTrue(name != null);
        NameEditingTests.assertEquals(newName, name);
        NameEditingTests.assertEquals(1, nameTable.nameCount());
    }
}

