/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype.component;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.opentype.component.HeaderTable;
import com.google.typography.font.sfntly.table.opentype.component.Record;
import com.google.typography.font.sfntly.table.opentype.component.RecordList;
import java.util.Iterator;

public abstract class RecordsTable<R extends Record>
extends HeaderTable
implements Iterable<R> {
    public final RecordList<R> recordList;

    protected RecordsTable(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        this.recordList = this.createRecordList(data.slice(base + this.headerSize()));
    }

    protected RecordsTable(ReadableFontData data, boolean dataIsCanonical) {
        this(data, 0, dataIsCanonical);
    }

    protected RecordsTable(RecordList<R> records) {
        super(records.readData, records.base, false);
        this.recordList = records;
    }

    @Override
    public Iterator<R> iterator() {
        return this.recordList.iterator();
    }

    protected abstract RecordList<R> createRecordList(ReadableFontData var1);

    public static abstract class Builder<T extends HeaderTable, R extends Record>
    extends HeaderTable.Builder<T> {
        protected RecordList<R> records;
        private int serializedLength;
        private final int base;

        protected Builder() {
            this.base = 0;
        }

        protected Builder(RecordsTable<R> table) {
            this(table.readFontData(), table.base, table.dataIsCanonical);
        }

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            this(data, 0, dataIsCanonical);
        }

        protected Builder(ReadableFontData data, int base, boolean dataIsCanonical) {
            super(data);
            this.base = base;
            if (!dataIsCanonical) {
                this.prepareToEdit();
            }
        }

        protected Builder(Builder<T, R> other) {
            this.base = other.base;
            this.records = other.records;
        }

        public RecordList<R> records() {
            return this.records;
        }

        public int count() {
            this.initFromData(this.internalReadData(), this.base);
            return this.records.count();
        }

        @Override
        public int subDataSizeToSerialize() {
            if (this.records != null) {
                this.serializedLength = this.records.limit();
            } else {
                this.computeSizeFromData(this.internalReadData().slice(this.base + this.headerSize()));
            }
            return this.serializedLength;
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            if (this.serializedLength == 0) {
                return 0;
            }
            if (this.records == null) {
                return this.serializeFromData(newData);
            }
            return this.records.writeTo(newData);
        }

        @Override
        public T subBuildTable(ReadableFontData data) {
            return this.readTable(data, 0, true);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        public void subDataSet() {
            this.records = null;
        }

        protected abstract T readTable(ReadableFontData var1, int var2, boolean var3);

        protected abstract RecordList<R> readRecordList(ReadableFontData var1, int var2);

        private void prepareToEdit() {
            this.initFromData(this.internalReadData(), this.base + this.headerSize());
            this.setModelChanged();
        }

        private void initFromData(ReadableFontData data, int base) {
            if (this.records == null) {
                this.records = this.readRecordList(data, base);
            }
        }

        private void computeSizeFromData(ReadableFontData data) {
            int len = 0;
            if (data != null) {
                len = data.length();
            }
            this.serializedLength = len;
        }

        private int serializeFromData(WritableFontData newData) {
            ReadableFontData data = this.internalReadData().slice(this.base + this.headerSize());
            data.copyTo(newData);
            return data.length();
        }
    }
}

