
#include "GUI.h"

uint8_t  PrescalerVSpeed = 0; 
GaugesCtrlStruct GaugesCtrl;
//uint16_t Vspeed_Seg_Disp[] = {0, 0, 0, 0, 0};
//uint8_t  Vspeed_Seg_Count  = 0;
//uint16_t Espeed_Seg_Disp[] = {0, 0, 0, 0, 0};
//uint8_t  Espeed_Seg_Count  = 0;
/******************************************************************************
GUI_Animation_Frame_Display
  : ʾָһ֡
  : Frame֡
ֵ
******************************************************************************/
void GUI_Animation_Frame_Display(uint8_t Frame)
{
	TFT_LCD_Display_Sprite(LAYER_BEIJING, SN_AnimationLeft_0001_png + Frame, 0, 0, 64);
	TFT_LCD_Display_Sprite(LAYER_BEIJING1, SN_AnimationRight_0001_png + Frame, 400, 0, 64);
}
/******************************************************************************
GUI_BG_Clock_Display
  ܣʱʾ
  
ֵ
******************************************************************************/
void GUI_BG_Clock_Display(uint8_t Mode)
{
  if (Mode == GUI_DISP_MODE_NORMAL)
  {	
    GUI_General_Digit_Display(RTC_HOUR,   DIGIT_FONT_TIME, 2, 0, LAYER_Time_Hour1,   GUIBGClockHourPosX, 438, 64);
    GUI_General_Digit_Display(RTC_MINUTE, DIGIT_FONT_TIME, 2, 0, LAYER_Time_Minute1, GUIBGClockMinutePosX, 438, 64);
    if (FLASH_SYNC_1Hz)
    {
	    TFT_LCD_Display_Sprite(LAYER_Time_Dot, SN_NB_16_maohao_png, 306, 444, 64);	
		}
		else
		{
			TFT_LCD_Clear_Layer(LAYER_Time_Dot);
		}   
  }
  else
    TFT_LCD_Clear_Multi_Layer(LAYER_Time_Hour1, LAYER_Time_Minute2);
}
/******************************************************************************
GUI_BG_TEMP_Display
  ܣ¶ʾ             
  
ֵ
******************************************************************************/
void GUI_BG_TEMP_Display(uint8_t Mode)
{
  uint16_t TEMP;
  
  TEMP = 0;
  // if (Mode == GUI_DISP_MODE_NORMAL)
  // if ((!(AMB_STATUS & CAN_MSG_LOST)) && (IO_DISP_TEST_OFF_TIME>75))
  if (AMB_STATUS & CAN_MSG_LOST)
    TFT_LCD_Clear_Multi_Layer(LAYER_TUINT, LAYER_TEMP3);
  else
  {	
    TEMP = Ambient_Air_TemperatureH << 8;
    TEMP = TEMP + Ambient_Air_TemperatureL;
    TEMP = TEMP >> 5;
    if (TEMP == 0)
    {
      TFT_LCD_Clear_Multi_Layer(LAYER_TUINT, LAYER_TEMP3);
    }
    else
    {
      TFT_LCD_Display_Sprite(LAYER_TUINT, SN_wendufuhao_png, 503, 436, 64);
      if (TEMP < 273)
      {
        TEMP = 273 - TEMP;
        if (TEMP > 99)
          TEMP = 99;
  	    GUI_General_Digit_Display(TEMP, DIGIT_FONT_TIME, 2, 1, LAYER_TEMP1, GUITempPosX, 438, 64);
  	    TFT_LCD_Display_Sprite(LAYER_TEMP3, SN_fuhao_png, 456, 449, 64);	
  		}
  		else
  		{
  		  TEMP = TEMP - 273;
  		  if (TEMP > 99)
  		    TEMP = 99;
  		  GUI_General_Digit_Display(TEMP, DIGIT_FONT_TIME, 2, 1, LAYER_TEMP1, GUITempPosX, 438, 64);
  			TFT_LCD_Clear_Layer(LAYER_TEMP3);
  		} 
		}  
  }    
}
/******************************************************************************
GUI_BG_TRIP_A_Display
  ܣС A B
  
ֵ
******************************************************************************/
void GUI_BG_TRIP_A_Display(uint8_t ValidA, uint16_t TripA, uint8_t TripA_Mode)
{
  if (TripA_Mode == GUI_DISP_MODE_BLANK)
  {  
    TFT_LCD_Clear_Multi_Layer(LAYER_Trip, LAYER_Trip4) ;
  }
  else
  {  	
    if (TripA > 9999)
      TripA = 9999;
    
    TFT_LCD_Display_Sprite(LAYER_Trip, SN_daxiaoji_02_png, 594, 440, 64);	
    GUI_General_Digit_Display(TripA, DIGIT_FONT_TIME, 4, 2, LAYER_Trip1, GUITirpPosX, 438, 64);                                                      
  }
}

/******************************************************************************
GUI_BG_ODO_Display
  ܣܼ
  
ֵ
******************************************************************************/
void GUI_BG_ODO_Display(uint8_t Mode, uint32_t Mileage)
{
  uint32_t MileageDisp;
  if (Mode == GUI_DISP_MODE_BLANK)
  {    
    TFT_LCD_Clear_Multi_Layer(LAYER_ODO, LAYER_ODO6);
  }
  else
  {
    MileageDisp = Mileage / 10;
    if (MileageDisp > 999999)
      MileageDisp = 999999;
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
      TFT_LCD_Display_Sprite(LAYER_ODO, SN_daxiaoji_01_png, 27, 440, 64);
      GUI_General_Digit_Display(MileageDisp, DIGIT_FONT_TIME, 6, 5, LAYER_ODO1, GUIODOPosX, 438, 64);
    }
  }
}

/******************************************************************************
GUI_BG_Gear_Alarm_Display
  ܣλʾ
  
ֵ
******************************************************************************/
void GUI_BG_Gear_Alarm_Display(uint8_t Mode)
{ 
  if (Mode == GUI_DISP_MODE_NORMAL)
  {	
    switch (ActualGearPosition)
    {
      case 0x00:
        TFT_LCD_Display_Sprite(LAYER_Gear, SN_GEAR_N_png, 367, 428, 64);
        TFT_LCD_Clear_Layer(LAYER_Gear1);
        TFT_LCD_Clear_Layer(LAYER_Gear2);
        break;
      case 0x01:
      case 0x02:
      case 0x03:
      case 0x04:
      case 0x05:
      case 0x06:
      case 0x07:
      case 0x08:
        TFT_LCD_Display_Sprite(LAYER_Gear,  SN_GEAR_D_png, 367, 428, 64);
        TFT_LCD_Display_Sprite(LAYER_Gear1, SN_NB_16_8_01_png + ActualGearPosition - 1, 419, 448, 64); 
        break;
      case 0x09:
        TFT_LCD_Display_Sprite(LAYER_Gear,  SN_GEAR_R_png, 367, 428, 64);
        TFT_LCD_Display_Sprite(LAYER_Gear1, SN_GEAR_L_png, 419, 448, 64); //SN_NB_16_8_0_png λС
        break;
      case 0x0A: 
        TFT_LCD_Display_Sprite(LAYER_Gear,  SN_GEAR_R_png, 367, 428, 64);
        TFT_LCD_Display_Sprite(LAYER_Gear1, SN_GEAR_H_png, 419, 448, 64); //SN_NB_16_8_0_png λС
        break;
      default:
        TFT_LCD_Clear_Multi_Layer(LAYER_Gear, LAYER_Gear2);
        break;     
    }
    /*if ((ActualGearPosition > 0) && (ActualGearPosition < 9))
    {
      if ((EGSM_NearShiftGearTip > 0) && (EGSM_NearShiftGearTip < 9))
      {
        if (EGSM_ShiftGearTip == 1)
          TFT_LCD_Display_Sprite(LAYER_Gear2, SN_dangweixiajiantou_1_png + EGSM_NearShiftGearTip - 1, 428, 428, 64); 
        else if (EGSM_ShiftGearTip == 2)
          TFT_LCD_Display_Sprite(LAYER_Gear2, SN_dangweishangjiantou_1_png + EGSM_NearShiftGearTip - 1, 427, 427, 64); 
        else
          TFT_LCD_Clear_Layer(LAYER_Gear2);
      }
      else
        TFT_LCD_Clear_Layer(LAYER_Gear2);
    }
    else
      TFT_LCD_Clear_Layer(LAYER_Gear2);
    */
  }
  else
    TFT_LCD_Clear_Multi_Layer(LAYER_Gear, LAYER_Gear2);
}
/******************************************************************************
GUI_BG_Gear_Display
  ܣλʾ
  
ֵ
******************************************************************************/
void GUI_BG_Gear_Display(uint8_t Mode)
{ 
  if (TCU_ICM_Display1_STATUS & CAN_MSG_LOST)
  {
    TFT_LCD_Clear_Multi_Layer(LAYER_Gear, LAYER_Gear2); //20190618
    return;
  }
  if (Mode == GUI_DISP_MODE_NORMAL)
  {	
    switch (Gear_Display)
    {
      case 0x00:
        TFT_LCD_Clear_Multi_Layer(LAYER_Gear, LAYER_Gear2); //20190618
        break;
      case 0x01:
      case 0x02:
      case 0x03:
      case 0x04:
      case 0x05:
      case 0x06:
        TFT_LCD_Display_Sprite(LAYER_Gear,  SN_GEAR_M_png, 367, 428, 64);
        TFT_LCD_Display_Sprite(LAYER_Gear1, SN_NB_16_8_01_png + Gear_Display - 1, 419, 448, 64); 
        break;
      case 0x21:
      case 0x22:
      case 0x23:
      case 0x24:
      case 0x25:
      case 0x26:
        TFT_LCD_Display_Sprite(LAYER_Gear,  SN_Gear_Ax367y427_png, 367, 427, 64);
        TFT_LCD_Display_Sprite(LAYER_Gear1, SN_NB_16_8_01_png + Gear_Display - 0x21, 419, 448, 64); 
        break;        
      case 0x30:
        TFT_LCD_Display_Sprite(LAYER_Gear,  SN_GEAR_R_png, 367, 428, 64);
        TFT_LCD_Clear_Layer(LAYER_Gear1);
        break;
      case 0x40: 
        TFT_LCD_Display_Sprite(LAYER_Gear,  SN_GEAR_N_png, 367, 428, 64);
        TFT_LCD_Clear_Layer(LAYER_Gear1);
        break;
      default:
        TFT_LCD_Clear_Multi_Layer(LAYER_Gear, LAYER_Gear2);
        break;     
    }
  }
  else
    TFT_LCD_Clear_Multi_Layer(LAYER_Gear, LAYER_Gear2);
}
/******************************************************************************
GUI_BG_Vehicle_Display
  ܣʾ
  
ֵ
******************************************************************************/
void GUI_BG_Vehicle_Display(uint8_t SegNum)
{
  if (SegNum > 17)
    SegNum = 17; 	
  // TFT_LCD_Display_Sprite(LAYER_EngineLB, SN_kmh__x442__y346_png, 442, 346, 64);
  if (SegNum < 8)
  {
    TFT_LCD_Display_Sprite(LAYER_VehicleL, SN_chesu_16_1_00_png + SegNum, 29, 328, 64);
    TFT_LCD_Display_Sprite(LAYER_VehicleR, SN_chesu_16_2_08_png, 400, 328, 64);
  }
  else
  {
    TFT_LCD_Display_Sprite(LAYER_VehicleL, SN_chesu_16_1_08_png, 29, 328, 64);
    TFT_LCD_Display_Sprite(LAYER_VehicleR, SN_chesu_16_2_08_png + SegNum - 8, 400, 328, 64);
  } 
  //GUI_General_Digit_Display(DATA_VEHICLE_SPEED_DISPLAYING / 10, DIGIT_FONT_VEHICLE, 3, 2, LAYER_Vehicle1, GUIVehPosX3,294, 64);  
}

void SEG_LCD_Vehicle_Speed_Num_Display(uint16_t Value)
{
  GUI_General_Digit_Display(Value / 10 , DIGIT_FONT_VEHICLE, 3, 2, LAYER_Vehicle1, GUIVehPosX3,294, 64);    
}
/******************************************************************************
GUI_BG_Engine_Display
  ܣתʾ
  
ֵ
******************************************************************************/
void GUI_BG_Engine_Display(uint8_t SegNum)
{ 
  if (SegNum > 10)
    SegNum = 10; 	
  
  // TFT_LCD_Display_Sprite(LAYER_EngineLB, SN_zhuansu_1_00_png, 99, 56, 64);
  // TFT_LCD_Display_Sprite(LAYER_EngineRB, SN_zhuansu_2_05_png, 399, 56, 64); 
  // TFT_LCD_Display_Sprite(LAYER_EUINT, SN_1000rpm__x441__y110_png, 441, 110, 64);
  
  if (SegNum < 6)
  {
      TFT_LCD_Display_Sprite(LAYER_EngineL, SN_zhuansu_1_00_png + SegNum, 29, 53, 64);
      TFT_LCD_Display_Sprite(LAYER_EngineR, SN_zhuansu_2_05_png, 400, 53, 64);
  }
  else 
  {
      TFT_LCD_Display_Sprite(LAYER_EngineL, SN_zhuansu_1_05_png, 29, 53, 64);
      TFT_LCD_Display_Sprite(LAYER_EngineR, SN_zhuansu_2_05_png + SegNum - 5, 400, 53, 64);
  }

  // TFT_LCD_Clear_Multi_Layer(LAYER_EngineL, LAYER_EngineR);       

 
  //TFT_LCD_Display_Sprite(LAYER_EngineDot, SN_NB_32_5_dian_png, 390, 111, 64);
  //GUI_General_Digit_Display(DATA_ENGINE_SPEED_DISPLAYING / 100, DIGIT_FONT_ENGINE, 2, 0, LAYER_Engine1, GUIEngPosX, 86, 64); 
}

void SEG_LCD_Engine_Speed_Num_Display(uint16_t Value)
{
  TFT_LCD_Display_Sprite(LAYER_EngineDot, SN_NB_32_5_dian_png, 390, 111, 64);
  GUI_General_Digit_Display(DATA_ENGINE_SPEED_DISPLAYING / 100, DIGIT_FONT_ENGINE, 2, 0, LAYER_Engine1, GUIEngPosX, 86, 64);  
}

/******************************************************************************
GUI_BG_GAS1_Display
  ܣѹ1ʾ
  
ֵ
******************************************************************************/
void GUI_BG_GAS1_Display(uint8_t SegNum)
{ 
  if (SegNum > 16)
    SegNum = 16; 	
  TFT_LCD_Display_Sprite(LAYER_AirL1, SN_zuoqiya00_png + SegNum, 0, 45, 64);
  // TFT_LCD_Display_Sprite(LAYER_AirL2, SN_zuoqiyashuzi_png, 15, 86, 64);
}
/******************************************************************************
GUI_BG_GAS2_Display
  ܣѹ2ʾ
  
ֵ
******************************************************************************/
void GUI_BG_GAS2_Display(uint8_t SegNum)
{ 
  if (SegNum > 16)
    SegNum = 16; 	
  TFT_LCD_Display_Sprite(LAYER_AirR1, SN_youqiya00_png + SegNum, 673, 45, 64); 
  //TFT_LCD_Display_Sprite(LAYER_AirR2, SN_youqiyashuzi_png, 737, 86, 64);
}
/******************************************************************************
GUI_General_Popup_Display
  ܣͨõϢʾ
  PopupIDϢ
ֵ
******************************************************************************/
void GUI_General_Popup_Display(uint8_t PopupID)
{
  //TFT_LCD_Clear_Layer(1);  
  if (PopupID >= POPUP_MSG_NUMBER_TOTAL)
    return; 
  //if ((PopupID == POPUP_MSG_Press_Brake_Start) || (PopupID == POPUP_MSG_Press_clutch_Start) || (PopupID == POPUP_MSG_N_Level_Start))
  //  TFT_LCD_Display_Sprite(LAYER_MENU01, GUIGeneralPopupTable[PopupID].HImage, 266, 162, 64);
  TFT_LCD_Clear_Multi_Layer(LAYER_MENU01, LAYER_MENU12); 
  
  if (PopupID == POPUP_MSG_POWEROFF_WithoutN)
    TFT_LCD_Display_Sprite(LAYER_MENU13, GUIGeneralPopupTable[PopupID].HImage, 266, 162, 64);
  
  else if ((PopupID == POPUP_MSG_Press_Brake_Start) || (PopupID == POPUP_MSG_Press_clutch_Start)
           || (PopupID == POPUP_MSG_N_Level_Start) || (PopupID == POPUP_MSG_Key_Battery_Low) || (PopupID == POPUP_MSG_Key_Not_Found))
    TFT_LCD_Display_Sprite(LAYER_MENU13, GUIGeneralPopupTable[PopupID].HImage, 265, 140, 64); 
  else if (PopupID == POPUP_MSG_Running_Err)  
    TFT_LCD_Display_Sprite(LAYER_MENU13, GUIGeneralPopupTable[PopupID].HImage, 219, 180, 64); 
  else
    TFT_LCD_Display_Sprite(LAYER_MENU13, GUIGeneralPopupTable[PopupID].HImage, 285, 179, 64);  
  
  //TFT_LCD_Display_Sprite(LAYER_MENU02, GUIGeneralPopupTable[PopupID].SImage, GUIPopupTextwenziPosX[0], GUIPopupTextwenziPosY[0], 64);
  if (PopupID == POPUP_MSG_POWEROFF_WithoutN)
    TFT_LCD_Display_Sprite(LAYER_MENU14, SN_ALARM_22_png, 360, 193, 64);
  else
    TFT_LCD_Clear_Layer(LAYER_MENU14);
}

/******************************************************************************
Clear_TFT
  ܣ
  
ֵ
******************************************************************************/
void Clear_TFT(void)
{
  TFT_LCD_Clear_Multi_Layer (0, YVC_LYR_NUM_CPU - 1); //ʼͼ
}
/******************************************************************************
TFT_LCD_General_Digit_Display
  ܣͨʾ
  DigitҪʾ
        Font 
        Len  : Ҫʾֳ
        BlankλΪλ,λ
        Layerʾֵʼͼ
        *px  λֵxб(λֿʼ)
        y    ĩλֵy(ʾҶ)
ֵ
******************************************************************************/
void GUI_General_Digit_Display(uint32_t Digit, uint16_t Font, uint8_t Len, uint8_t Blank, uint8_t Layer,  const uint16_t *px,  uint16_t y, uint8_t Scale)
{
  uint8_t i;
  uint8_t ActLen;
  uint8_t d[10];

  //10ʽֲʵֳ
  ActLen = 0;
  while (Digit)
  {
    d[ActLen] = Digit % 10;
    Digit /= 10;
    ActLen++;
  }

  //Ϊ0ʱ⴦
  if (ActLen == 0)
  {
    ActLen = 1;
    d[0] = 0;
  }

  //δ㵽λ0
  for (i = ActLen; i < Len; i++ )
    d[i] = 0;

  //ײλ
  i = (Len - 1);
  while ((d[i] == 0) && (i >= (Len - Blank)))
  {
    d[i] = 0xFF;
    i--;
  }
  //ʾ
  for (i = 0; i < Len; i++)
  {
    if (d[i] == 0xFF)
      TFT_LCD_Clear_Layer(Layer + i);
    else
      TFT_LCD_Display_Sprite(Layer + i, Font + d[i], *(px + i),  y, Scale);
  }
}
/******************************************************************************
TFT_LCD_General_Digit_Display                  
  ܣͨʾ
  DigitҪʾ
        Font 
        Len  : Ҫʾֳ
        BlankλΪλ,λ
        Layerʾֵʼͼ
        x    ĩλֵx(ʾҶ)
        *py  λֵyб(λֿʼ)      
ֵ
******************************************************************************/
/*void GUI_General_Digit_Display(uint32_t Digit, uint16_t Font, uint8_t Len, uint8_t Blank, uint8_t Layer, const uint16_t x, uint16_t *py, uint8_t Scale)
{
  uint8_t i;
  uint8_t ActLen;
  uint8_t d[10];

  //10ʽֲʵֳ
  ActLen = 0;
  while (Digit)
  {
    d[ActLen] = Digit % 10;
    Digit /= 10;
    ActLen++;
  }

  //Ϊ0ʱ⴦
  if (ActLen == 0)
  {
    ActLen = 1;
    d[0] = 0;
  }

  //δ㵽λ0
  for (i = ActLen; i < Len; i++ )
    d[i] = 0;

  //ײλ
  i = (Len - 1);
  while ((d[i] == 0) && (i >= (Len - Blank)))
  {
    d[i] = 0xFF;
    i--;
  }
  //ʾ
  for (i = 0; i < Len; i++)
  {
    if (d[i] == 0xFF)
      TFT_LCD_Clear_Layer(Layer + i);
    else
      TFT_LCD_Display_Sprite(Layer + i, Font + d[i], x, *(py + i) , Scale);
  }
}*/
/***************************************************************
ٱ߶ʽ
****************************************************************/
uint8_t  V_DELAY_Timer;
uint8_t  V_DELAY_Mode;
uint16_t V_DELAY_Backup;

void Gauges_VSpeed_LCD_Status(void)
{
	uint16_t VSpeed;
	uint16_t Delta;
	
	VSpeed = DATA_VEHICLE_SPEED_DISPLAYING;

  //if ((ESpeed >= 500) && (ESpeed <= 1000)) //20200109
	if ((VSpeed >= 10) && (VSpeed <= 1600))
	{
		V_DELAY_Timer++;

		if (VSpeed > V_DELAY_Backup )
			Delta = VSpeed - V_DELAY_Backup;
		else
			Delta = V_DELAY_Backup - VSpeed;

		if (V_DELAY_Mode == 0)
		{
			if (Delta < 30)
			{
				if (V_DELAY_Timer >= 20)
				{
					V_DELAY_Mode  = 1;
					V_DELAY_Timer = 0;
				}
			}
			else
				V_DELAY_Timer = 0;

			V_DELAY_Backup = VSpeed;
		}
		else
		{
			if (Delta < 30)
			{
				if (V_DELAY_Timer >= 100)              //ģʽÿ1תݸһ
				{
					V_DELAY_Timer  = 0;
					V_DELAY_Backup = VSpeed;
				}
				else
					VSpeed = V_DELAY_Backup;
			}
			else                                     //תٱ仯ڵ300˳ģʽ
			{
				V_DELAY_Mode   = 0;
				V_DELAY_Timer  = 0;
				V_DELAY_Backup = VSpeed;
			}
		}
	}
	else
	{
		V_DELAY_Mode   = 0;
		V_DELAY_Timer  = 0;
		V_DELAY_Backup = VSpeed;
	}	
				
  if (VSpeed > GaugesCtrl.VSpeedBackup)        //,
  {
    while (GaugesCtrl.VSpeedSeg < GAUGES_TOTAL_SPEEDOMETER_SEG)
    {
      if (VSpeed < GaugesSpeedoMeterSegIncTable[GaugesCtrl.VSpeedSeg])
        break;
      GaugesCtrl.VSpeedSeg++;
    }
  }
  else if (VSpeed < GaugesCtrl.VSpeedBackup)   //ټС,½
  {
    while (GaugesCtrl.VSpeedSeg)
    {
      if (VSpeed >= GaugesSpeedoMeterSegDecTable[GaugesCtrl.VSpeedSeg - 1])
        break;
      GaugesCtrl.VSpeedSeg--;
    }
  }
  
  GaugesCtrl.VSpeedBackup = V_DELAY_Backup;
  //SEG_LCD_Vehicle_Speed_Seg_Display(GaugesCtrl.VSpeedSeg);
}

/***************************************************************
ת߶ʽ
****************************************************************/
uint8_t  E_DELAY_Timer;
uint8_t  E_DELAY_Mode;
uint16_t E_DELAY_Backup;

void Gauges_ESpeed_LCD_Status(void)
{
  uint16_t ESpeed;
	uint16_t Delta;
  
  ESpeed = DATA_ENGINE_SPEED_DISPLAYING;
	//if ((ESpeed >= 500) && (ESpeed <= 1000)) //20200109
	if ((ESpeed > 1000) && (ESpeed <= 6000)) //20200421
	{
		E_DELAY_Timer++;

		if (ESpeed > E_DELAY_Backup)
			Delta = ESpeed - E_DELAY_Backup;
		else
			Delta = E_DELAY_Backup - ESpeed;

		if (E_DELAY_Mode == 0)
		{
			if (Delta < 300)
			{
				if (E_DELAY_Timer >= 200)
				{
					E_DELAY_Mode  = 1;
					E_DELAY_Timer = 0;
				}
			}
			else
				E_DELAY_Timer = 0;

			E_DELAY_Backup = ESpeed;
		}
		else
		{
			if (Delta < 300)
			{
				if (E_DELAY_Timer >= 200)              //ģʽÿ2תݸһ
				{
					E_DELAY_Timer = 0;
					E_DELAY_Backup = ESpeed;
				}
				else
					ESpeed = E_DELAY_Backup;
			}
			else                                     //תٱ仯ڵ300˳ģʽ
			{
				E_DELAY_Mode   = 0;
				E_DELAY_Timer  = 0;
				E_DELAY_Backup = ESpeed;
			}
		}
	}
	else
	{
		E_DELAY_Mode   = 0;
		E_DELAY_Timer  = 0;
		E_DELAY_Backup = ESpeed;
	}					
  if (ESpeed > GaugesCtrl.ESpeedBackup)        //ת,
  {
    while (GaugesCtrl.ESpeedSeg < GAUGES_TOTAL_TACHOMETER_SEG)
    {
      if (ESpeed < GaugesTachoMeterSegIncTable[GaugesCtrl.ESpeedSeg])
        break;
      GaugesCtrl.ESpeedSeg++;
    }
  }
  else if (ESpeed < GaugesCtrl.ESpeedBackup)   //תټС,½
  {
    while (GaugesCtrl.ESpeedSeg)
    {
      if (ESpeed >= GaugesTachoMeterSegDecTable[GaugesCtrl.ESpeedSeg - 1])
        break;
      GaugesCtrl.ESpeedSeg--;
    }
  }     
    GaugesCtrl.ESpeedBackup = ESpeed;  	
}

/***************************************************************
ѹ1߶ʽ
****************************************************************/
void Gauges_GAS1_LCD_Status(void)
{
  //ѹ1
  if (DATA_COOLANT_GAS1_SEG_DISPLAYING > GaugesCtrl.GAS1Backup) //,
  {
    while (GaugesCtrl.GAS1Seg < GAUGES_GAS1_SEG)
    {
      if (DATA_COOLANT_GAS1_SEG_DISPLAYING < GaugesGAS1IncTable[GaugesCtrl.GAS1Seg])
        break;
      GaugesCtrl.GAS1Seg++;
    }
  }
  else if (DATA_COOLANT_GAS1_SEG_DISPLAYING < GaugesCtrl.GAS1Backup) //С,½
  {
    while (GaugesCtrl.GAS1Seg)
    {
      if (DATA_COOLANT_GAS1_SEG_DISPLAYING >= GaugesGAS1DecTable[GaugesCtrl.GAS1Seg - 1])
        break;
      GaugesCtrl.GAS1Seg--;
    }
  }    
    GaugesCtrl.GAS1Backup = DATA_COOLANT_GAS1_SEG_DISPLAYING;
}
/***************************************************************
ѹ2߶ʽ
****************************************************************/
void Gauges_GAS2_LCD_Status(void)
{
  //ѹ2
  if (DATA_COOLANT_GAS2_SEG_DISPLAYING > GaugesCtrl.GAS2Backup) //,
  {
    while (GaugesCtrl.GAS2Seg < GAUGES_GAS2_SEG)
    {
      if (DATA_COOLANT_GAS2_SEG_DISPLAYING < GaugesGAS2IncTable[GaugesCtrl.GAS2Seg])
        break;
      GaugesCtrl.GAS2Seg++;
    }
  }
  else if (DATA_COOLANT_GAS2_SEG_DISPLAYING < GaugesCtrl.GAS2Backup) //С,½
  {
    while (GaugesCtrl.GAS2Seg)
    {
      if (DATA_COOLANT_GAS2_SEG_DISPLAYING >= GaugesGAS2DecTable[GaugesCtrl.GAS2Seg - 1])
        break;
      GaugesCtrl.GAS2Seg--;
    }
  }   
    GaugesCtrl.GAS2Backup = DATA_COOLANT_GAS2_SEG_DISPLAYING;           
}

uint8_t Overspeed_RVM = 0;

void Telltale_LCD_Display(void)
{  
  //----hyq--20190504--ĻָʾƱ־
	//ʻԱϵͳ()
	if (TelltaleLCDFlag.Sig.LCD01 == 1)
	{
    if (NVM_CONFIG_WEI > 0)
	  {
  	  if ((DrivabilityRestrictionsystem == 3) || (DrivabilityRestrictionsystem == 5)) 
  	    TFT_LCD_Display_Sprite(LAYER_LED01, SN_zhishideng_01_png, 40, 9, 64);
  	   else
  	    TFT_LCD_Display_Sprite(LAYER_LED01, SN_zhishideng_01_1_png, 40, 9, 64);  
	  }
	  else
	    TFT_LCD_Display_Sprite(LAYER_LED01, SN_zhishideng_01_1_png, 40, 9, 64); //33
	 }
	else 
    TFT_LCD_Clear_Layer(LAYER_LED01); 
	
	//ƶѹͱ
	if (TelltaleLCDFlag.Sig.LCD02 == 1) 
	  TFT_LCD_Display_Sprite(LAYER_LED02, SN_zhishideng_02_png, 85, 9, 64); //17
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED02);
	
	//  Ӳ    21
	if (TelltaleLCDFlag.Sig.LCD03 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED03, SN_zhishideng_03_png, 130, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED03);
	
	//EBS EBSƾ   42
	if (0) //TelltaleLCDFlag.Sig.LCD04 == 1)
	{
	  //if (EBSRedWarningSignal == 1)
	  //  TFT_LCD_Display_Sprite(LAYER_LED04, SN_zhishideng_29_png, 175, 9, 64);
	  //else if (ABS_EBS_AmberWarningSignal == 1)
	    TFT_LCD_Display_Sprite(LAYER_LED04, SN_zhishideng_04_png, 175, 9, 64);
  }
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED04);
	
	//Ȼ״ָ̬ʾ
  if (TelltaleLCDFlag.Sig.LCD31 == 1)
	{
	   TFT_LCD_Display_Sprite(LAYER_LED31, SN_zhishideng_32X592Y190_png, 592, 190, 64);
  }
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED31);
	
	//Ȼй¶ָʾ
  if (TelltaleLCDFlag.Sig.LCD32 == 1)
	{
	   TFT_LCD_Display_Sprite(LAYER_LED32, SN_zhishideng_32X123Y190_png, 123, 190, 64);
  }
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED32);
	
	//Ȼ״ָ̬ʾ
  if (TelltaleLCD_Flag33 == 1)
	{
	   TFT_LCD_Display_Sprite(LAYER_LED33, SN_zhishideng_31X592Y230_png, 592, 230, 64);
  }
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED33);	
	
	//ƶϵͳϵ   11   ѹźţЧ ˴ΪгƶƶѹƶҺλʱõҲҪ
	
  /*
	if (TelltaleLCDFlag.Sig.LCD05 == 1) //
	  TFT_LCD_Display_Sprite(LAYER_LED05, SN_zhishideng_30_png, 223, 12, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED05);
  */

  //ٱRVMͬһλ
  if ((TelltaleLCDFlag.Sig.LCD05 == 1) && (LED_T_BOX_RVM == 1))
  {
    if (Overspeed_RVM <= 40) //4s
    {
      Overspeed_RVM ++;
    }
    else
    {
      Overspeed_RVM = 0;
    }
    if (Overspeed_RVM <= 20)
    {
      TFT_LCD_Display_Sprite(LAYER_LED05, SN_zhishideng_30_png, 223, 12, 64);
    }
    else
    {
      TFT_LCD_Display_Sprite(LAYER_LED05, SN_lamp_12_png, 223, 12, 64); //ǰԣʽӦǣSN_lamp_12_png
    }      
  }
  else if ((TelltaleLCDFlag.Sig.LCD05 == 1) && (LED_T_BOX_RVM == 0)) //
  {
    TFT_LCD_Display_Sprite(LAYER_LED05, SN_zhishideng_30_png, 223, 12, 64);
    Overspeed_RVM = 0;
  }
  else if ((TelltaleLCDFlag.Sig.LCD05 == 0) && (LED_T_BOX_RVM == 1)) //RVM
  {
    TFT_LCD_Display_Sprite(LAYER_LED05, SN_lamp_12_png, 223, 12, 64);
    Overspeed_RVM = 0;
  }
  else
  {
    TFT_LCD_Clear_Layer(LAYER_LED05);
  }    
  	
	//ſ     KL30     15
	if (TelltaleLCDFlag.Sig.LCD06 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED06, SN_zhishideng_06_png, 265, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED06);
	
	//ʻδֹ Ч    16
	if (TelltaleLCDFlag.Sig.LCD07 == 1) 
	  TFT_LCD_Display_Sprite(LAYER_LED07, SN_zhishideng_07_png, 310, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED07);
	
	// ¶ȱ    38    ֻп˹иù
	if (TelltaleLCDFlag.Sig.LCD08 == 1) 
	  TFT_LCD_Display_Sprite(LAYER_LED08, SN_zhishideng_08_png, 355, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED08);
#if 0	
	// Ԥ    32
	if (TelltaleLCDFlag.Sig.LCD09 == 1) 
	  TFT_LCD_Display_Sprite(LAYER_LED09, SN_zhishideng_09_png, 400, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED09);
#endif	
	//AEB      44
	if (TelltaleLCDFlag.Sig.LCD10 == 1) 
	  TFT_LCD_Display_Sprite(LAYER_LED10, SN_zhishideng_10_png, 445, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED10);
	
	//С     KL15KL30        48
	if (TelltaleLCDFlag.Sig.LCD11 == 1) 
	  TFT_LCD_Display_Sprite(LAYER_LED11, SN_zhishideng_11_png, 490, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED11);
	
	//Ӿ˪   KL30       39
	if (TelltaleLCDFlag.Sig.LCD12 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED12, SN_zhishideng_12_png, 535, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED12);
	
	//    41
	if (TelltaleLCDFlag.Sig.LCD13 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED13, SN_zhishideng_13_png, 580, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED13);
	
	//ESC ָʾ    13
	if (TelltaleLCDFlag.Sig.LCD14 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED14, SN_zhishideng_14_png, 625, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED14);
	
	//ESC OFF رָʾ  14
	if (TelltaleLCDFlag.Sig.LCD15 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED15, SN_zhishideng_15_png, 670, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED15);
	
	//ƶָʾ 24
	if (TelltaleLCDFlag.Sig.LCD16 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED16, SN_zhishideng_16_png, 715, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED16);
	
  //EPSָʾ  46	
  if (EPS_Status_signal == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED09, SN_zhishideng_18_png, 400, 9, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED09);
  //
  if (TelltaleLCDFlag.Sig.LCD17 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED17, SN_zhishideng_31_png, 129, 103, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED17);
	
	//ASRϵ  8
	if (TelltaleLCDFlag.Sig.LCD18 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED18, SN_zhishideng_19_png, 130, 149, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED18);
	
	//EPB ϵ  45
	if (TelltaleLCDFlag.Sig.LCD19 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED19, SN_zhishideng_20_png, 130, 188, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED19);
	
	//ȼˮ 23   WaterInFuelIndicator
	if (TelltaleLCDFlag.Sig.LCD20 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED20, SN_zhishideng_21_png, 130, 227, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED20);
	
	//ָʾƣ̣47
	if (TelltaleLCDFlag.Sig.LCD21 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED21, SN_zhishideng_22_png, 130, 266, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED21);
	  
	//Auto hold ָʾɫ  20
	if (TelltaleLCDFlag.Sig.LCD22 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED22, SN_zhishideng_23_png, 130, 305, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED22);   

	// ƶҺλͱ    9
	if (TelltaleLCDFlag.Sig.LCD23 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED23, SN_zhishideng_17_png, 625, 110, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED23);
	
	//ACC ̵           43
	if (TelltaleLCDFlag.Sig.LCD24 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED24, SN_zhishideng_24_png, 625, 149, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED24);
	
	//ͣܿɫ   40     Ϋ:ûУ˹:У:û
	if (TelltaleLCDFlag.Sig.LCD25 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED25, SN_zhishideng_25_png, 625, 188, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED25);
	
	//ܹͣرպɫ   40     Ϋ:ûУ˹:У:û
	if (TelltaleLCDFlag.Sig.LCD26 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED26, SN_zhishideng_26_x625_y219_png, 625, 227, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED26);
	
	//PTO ָʾ      18
	if (TelltaleLCDFlag.Sig.LCD27 == 1)
	 TFT_LCD_Display_Sprite(LAYER_LED27, SN_zhishideng_27_png, 625, 266, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED27);
	
	//ƶƶ˿     19
	if (TelltaleLCDFlag.Sig.LCD28 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED28, SN_zhishideng_28_png, 625, 305, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED28);
	//ǰƬ     12
	if (TelltaleLCDFlag.Sig.LCD29 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED29, SN_qiya1_png, 20, 249, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED29);
	//Ƭ     12
	if (TelltaleLCDFlag.Sig.LCD30 == 1)
	  TFT_LCD_Display_Sprite(LAYER_LED30, SN_qiya2_png, 735, 249, 64);
	else 
	  TFT_LCD_Clear_Layer(LAYER_LED30);
}

void Menu1_1_Display(void) //˵
{
  TFT_LCD_Display_Sprite(LAYER_MENU01, SN_menu01_png, 337, 150, 64);
  TFT_LCD_Display_Sprite(LAYER_MENU02, SN_menu04_png, 337, 184, 64);
  TFT_LCD_Display_Sprite(LAYER_MENU03, SN_menu02_png, 337, 218, 64);
  TFT_LCD_Display_Sprite(LAYER_MENU04, SN_menu03_png, 337, 252, 64);
  TFT_LCD_Display_Sprite(LAYER_MENU05, SN_menu00_png, 310, 150, 64);
}

void Menu2_3_Display(void) //̥ѹϢ
{
  uint16_t tempt1 = 0;
  uint16_t tempt2 = 0;
  
  tempt1 = TireTEMPL;
  TFT_LCD_Clear_Multi_Layer(LAYER_MENU12, LAYER_MENU14);
  
  if (tempt1 == 0xFF)
  {
    TFT_LCD_Display_Sprite(LAYER_MENU05, SN_TPMS_fuhao_png, 309, 177, 64); //-
    TFT_LCD_Display_Sprite(LAYER_MENU06, SN_TPMS_fuhao_png, 296, 177, 64); //-
  }
  else
  {
    if (tempt1 >= 273)
    {
      tempt1 = tempt1 - 273;
    }
    else
    { 
      tempt1 = 273 - tempt1;        
      TFT_LCD_Display_Sprite(LAYER_MENU10, SN_TPMS_fuhao_png, 284, 177, 64); //-
    }   
    if (tempt1 > 99)
      tempt1 = 99;
    GUI_General_Digit_Display(tempt1, SN_TPMS_00_png, 2, 1, LAYER_MENU05, GUICurTTLPosX3, 170, 64); //
  }
  
  tempt2 = TireTEMPR;
  
  if (tempt2 == 0xFF)
  {
    TFT_LCD_Display_Sprite(LAYER_MENU08, SN_TPMS_fuhao_png, 461, 177, 64); //-
    TFT_LCD_Display_Sprite(LAYER_MENU09, SN_TPMS_fuhao_png, 449, 177, 64); //-
  }
  else
  {    
    if (tempt2 >= 273)
    {
      tempt2 = tempt2 - 273;      
    }
    else
    { 
      tempt2 = 273 - tempt2; 
      TFT_LCD_Display_Sprite(LAYER_MENU11, SN_TPMS_fuhao_png, 437, 177, 64); //-    
    }
    if (tempt2 > 99)
      tempt2 = 99;
    GUI_General_Digit_Display(tempt2, SN_TPMS_00_png, 2, 1, LAYER_MENU08, GUICurTTRPosX3, 170, 64); //
  }
  
  if (TirePL == 0xFF)
  {
    TFT_LCD_Display_Sprite(LAYER_MENU01, SN_TPMS_fuhao_png, 309, 153, 64); //-
    TFT_LCD_Display_Sprite(LAYER_MENU02, SN_TPMS_fuhao_png, 289, 153, 64); //-
  }
  else
  {
    GUI_General_Digit_Display(TirePL, SN_TPMS_00_png, 2, 0, LAYER_MENU01, GUICurTPLPosX2, 146, 64); // 
  }
  
  if (TirePL == 0xFF)
  {
    TFT_LCD_Display_Sprite(LAYER_MENU03, SN_TPMS_fuhao_png, 463, 153, 64); //-
    TFT_LCD_Display_Sprite(LAYER_MENU04, SN_TPMS_fuhao_png, 442, 153, 64); //-
  }
  else
  {
    GUI_General_Digit_Display(TirePR, SN_TPMS_00_png, 2, 0, LAYER_MENU03, GUICurTPRPosX2, 146, 64); // 
  }
  TFT_LCD_Display_Sprite(LAYER_MENU07, SN_carbody_png, 297, 141, 64);       //
  // TFT_LCD_Display_Sprite(LAYER_MENU09, SN_TPMS_BAR_png, 330, 145, 64);   //BAR
  // TFT_LCD_Display_Sprite(LAYER_MENU10, SN_TPMS_BAR_png, 483, 145, 64);   //BAR
  // TFT_LCD_Display_Sprite(LAYER_MENU11, SN_TPMS_uint_png, 329, 168, 64);  //¶ȵλ
  // TFT_LCD_Display_Sprite(LAYER_MENU12, SN_TPMS_uint_png, 482, 168, 64);  //¶ȵλ
  // TFT_LCD_Display_Sprite(LAYER_MENU13, SN_TPMS_Point_png, 303, 159, 64); //С
  // TFT_LCD_Display_Sprite(LAYER_MENU07, SN_TPMS_Point_png, 456, 159, 64); //С
}
 
void  GUI_TPMS_Display(uint8_t PopupID)
{
  uint16_t tempt3 = 0;
  uint16_t tempt4 = 0;
   
  tempt3 = TireTEMPL;
  tempt4 = TireTEMPR;     
  TFT_LCD_Display_Sprite(LAYER_MENU02, SN_Tire_Icon_x335y251_png, 335, 251, 64); //̥־ 
  TFT_LCD_Clear_Multi_Layer(LAYER_MENU04, LAYER_MENU14); 
  
  switch (PopupID)
  {
    case POPUP_MSG_noSignal_Left     :      
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody2_png, 370, 150, 64);   //  
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_NSignal_FL_png, 365, 259, 64); //
      break;
    
    case POPUP_MSG_HighTEMP_Left     :     
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody2_png, 370, 150, 64);  //
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_TTH_FL_png, 365, 259, 64);    //
                                        TFT_LCD_Display_Sprite(LAYER_MENU04, SN_TPMS_uint_png, 329, 168, 64); //¶ȵλ    
                                        
                                        if (tempt3 >= 273)
                                        {
                                          tempt3 = tempt3 - 273; 
                                        }
                                        else
                                        { 
                                          tempt3 = 273 - tempt3;                                           
                                          TFT_LCD_Display_Sprite(LAYER_MENU07, SN_TPMS_fuhao_png, 284, 177, 64); //-
                                        }
                                        if (tempt3 > 99)
                                          tempt3 = 99;  
                                        GUI_General_Digit_Display(tempt3, SN_TPMS_00_png, 2, 1, LAYER_MENU05, GUICurTTLPosX3, 170, 64); //
      break;
      
    case POPUP_MSG_HighPRESSURE_Left : 
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody2_png, 370, 150, 64);   // 
                                        TFT_LCD_Display_Sprite(LAYER_MENU04, SN_TPMS_BAR_png, 330, 145, 64);   //BAR
                                        TFT_LCD_Display_Sprite(LAYER_MENU05, SN_TPMS_Point_png, 303, 159, 64); //С                                       
                                        GUI_General_Digit_Display(TirePL, SN_TPMS_00_png, 2, 0, LAYER_MENU06, GUICurTPLPosX2, 146, 64); //
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_TPH_FL_png, 365, 259, 64);     // 
      break;
      
    case POPUP_MSG_LowPRESSURE_Left  :
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody2_png, 370, 150, 64);   // 
                                        TFT_LCD_Display_Sprite(LAYER_MENU04, SN_TPMS_BAR_png, 330, 145, 64);   //BAR
                                        TFT_LCD_Display_Sprite(LAYER_MENU05, SN_TPMS_Point_png, 303, 159, 64); //С                                        
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_TPL_FL_png, 365, 259, 64);     //
                                        GUI_General_Digit_Display(TirePL, SN_TPMS_00_png, 2, 0, LAYER_MENU06, GUICurTPLPosX2, 146, 64); // 
      break;
      
    case POPUP_MSG_noSignal_Right    :                                          
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody3_png, 370, 150, 64);   // 
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_NSignal_FR_png, 365, 259, 64); // 
      break;
    
    case POPUP_MSG_HighTEMP_Right    :    
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody3_png, 370, 150, 64);   // 
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_TTH_FR_png, 365, 259, 64);     //
                                        TFT_LCD_Display_Sprite(LAYER_MENU04, SN_TPMS_uint_png, 482, 168, 64);  //¶ȵλ
                                        
                                        if (tempt4 >= 273)
                                        {
                                          tempt4 = tempt4 - 273;                                            
                                        }
                                        else
                                        { 
                                          tempt4 = 273 - tempt4;
                                          TFT_LCD_Display_Sprite(LAYER_MENU07, SN_TPMS_fuhao_png, 437, 177, 64); //-
                                        } 
                                        if (tempt4 > 99)
                                          tempt4 = 99;     
                                        GUI_General_Digit_Display(tempt4, SN_TPMS_00_png, 2, 1, LAYER_MENU05, GUICurTTRPosX3, 170, 64); //
      break;
    
    case POPUP_MSG_HighPRESSURE_Right:  
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody3_png, 370, 150, 64);   // 
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_TPH_FR_png, 365, 259, 64);     //
                                        TFT_LCD_Display_Sprite(LAYER_MENU04, SN_TPMS_BAR_png, 483, 145, 64);   //BAR
                                        TFT_LCD_Display_Sprite(LAYER_MENU05, SN_TPMS_Point_png, 456, 159, 64); //С   
                                        GUI_General_Digit_Display(TirePR, SN_TPMS_00_png, 2, 0, LAYER_MENU06, GUICurTPRPosX2, 146, 64); //                                   
      break;
    
    case POPUP_MSG_LowPRESSURE_Right : 
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody3_png, 370, 150, 64);   // 
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_TPL_FR_png, 365, 259, 64);     //
                                        TFT_LCD_Display_Sprite(LAYER_MENU04, SN_TPMS_BAR_png, 483, 145, 64);   //BAR
                                        TFT_LCD_Display_Sprite(LAYER_MENU05, SN_TPMS_Point_png, 456, 159, 64); //С    
                                        GUI_General_Digit_Display(TirePR, SN_TPMS_00_png, 2, 0, LAYER_MENU06, GUICurTPRPosX2, 146, 64); //                                         
      break;
      
    case POPUP_MSG_TireIDStudy_Left  : 
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody2_png, 370, 150, 64);  // 
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_NStudy_FL_png, 365, 259, 64); //   
      break;
      
    case POPUP_MSG_TireIDStudy_Right : 
                                        TFT_LCD_Display_Sprite(LAYER_MENU01, SN_carbody3_png, 370, 150, 64);  // 
                                        TFT_LCD_Display_Sprite(LAYER_MENU03, SN_NStudy_FR_png, 365, 259, 64); // 
      break;
      
    default                          :
      break;
  }
}
 
void Menu2_4_Display(void) //гϢ
{
  #if 0 
   TFT_LCD_Display_Sprite(LAYER_MENU01, SN_V_Info_Display_png, 280, 178, 64);
   TFT_LCD_Display_Sprite(LAYER_MENU02, SN_V_Info_Display_uint_1_png, 302, 246, 64);
   //TFT_LCD_Display_Sprite(LAYER_MENU03, SN_Vehicle_Information_Display2_png, 458, 178, 64);
   
   //TFT_LCD_Display_Sprite(LAYER_MENU04, SN_Vehicle_Information_Display_uint_png, 367, 246, 64);
   //TFT_LCD_Display_Sprite(LAYER_MENU05, SN_Vehicle_Information_Display3_uint_png, 280, 246, 64);
   //TFT_LCD_Display_Sprite(LAYER_MENU06, SN_Vehicle_Information_Display_uint_png, 458, 246, 64);
   
   TFT_LCD_Display_Sprite(LAYER_MENU03, SN_NB_17_point_png, 391, 208, 64);
   GUI_General_Digit_Display(DataAvgFuelConsByLF, DIGIT_FONT_DTE, 3, 1, LAYER_MENU04, GUIRAFCPosX, 208, 64);  //ƽͺ
   if (DataDTE >= 9999)
   DataDTE = 9999;
   GUI_General_Digit_Display(DataDTE, DIGIT_FONT_DTE, 4, 3, LAYER_MENU07, GUIDTEPosX3, 208, 64);              //
   
   TFT_LCD_Display_Sprite(LAYER_MENU11, SN_NB_17_point_png, 490, 208, 64);
   GUI_General_Digit_Display(FuelConsumptionRate, DIGIT_FONT_DTE, 3, 1, LAYER_MENU12, GUICurONPosX3,208, 64); //˲ʱͺ
 #endif   
   
   TFT_LCD_Display_Sprite(LAYER_MENU01, SN_NB_17_00_png, 355, 199, 64);
   TFT_LCD_Display_Sprite(LAYER_MENU02, SN_NB_17_00_png, 373, 199, 64);
   TFT_LCD_Display_Sprite(LAYER_MENU03, SN_NB_17_point_png, 391, 199, 64);
   TFT_LCD_Display_Sprite(LAYER_MENU04, SN_NB_17_01_png, 409, 199, 64);
   TFT_LCD_Display_Sprite(LAYER_MENU05, SN_NB_17_05_png, 427, 199, 64);
}

uint8_t  Left_LDW_Count  = 0;
uint8_t  Right_LDW_Count = 0;
uint8_t  PCW_Count       = 0;
uint8_t  FCW_Count       = 0;
uint8_t  UFCW_Count      = 0;
uint8_t  Hz2_Count_L     = 0;
uint8_t  Hz2_Count_R     = 0; 
uint8_t  Hz2_Count_FCW   = 0; 
uint8_t  Hz2_Count_UFCW  = 0; 
uint8_t  Hz2_Count_PCW   = 0;
 
void GUI_ADAS_Display(void) //ADAS
{
  if ((!(ADAS_1_STATUS & CAN_MSG_LOST)) && (!(ADAS_2_STATUS & CAN_MSG_LOST)))
  {
    TFT_LCD_Clear_Multi_Layer(LAYER_MENU01, LAYER_MENU14); 
    //if ((ADAS_Maintenance == 1) || (ADAS_Failsafe == 1) || (ADAS_Error_Active == 0)) //ADAS    0Ч
    if ((ADAS_Error_Code == 0x10) || (ADAS_Error_Code == 0x12) \
        || (ADAS_Error_Code == 0x13) || (ADAS_Error_Code == 0x20) \
        || (ADAS_Error_Code == 0x55) || (ADAS_Error_Code == 0x57))
      TFT_LCD_Display_Sprite(LAYER_MENU01, SN_adas_png, 271, 169, 64);
    else if (ADAS_Error_Code == 0x5A)
      TFT_LCD_Display_Sprite(LAYER_MENU01, SN_camera_shieding_png, 252, 165, 64); //20200925
    else
      TFT_LCD_Clear_Layer(LAYER_MENU01);
    /* if ((ADAS_Error_Code > 0) && (ADAS_Error_Code <= 99))
      GUI_General_Digit_Display(ADAS_Error_Code, SN_YELLOW_00__png, 2, 2, LAYER_MENU12, GUIADASPosX, 199, 64); //ADAS澯ֵ
    else
    {
      TFT_LCD_Clear_Layer(LAYER_MENU12);
      TFT_LCD_Clear_Layer(LAYER_MENU13);
    }
    20200907*/ 
    if (LDW_Disable == 1) //fhl20200529
    { 
      if ((Left_LDW == 1) || (Right_LDW == 1))
      {
        if (Left_LDW == 1) //󳵵ƫ
        {
          if (DATA_VEHICLE_SPEED_DISPLAYING >= 550)
          {
            if (Left_LDW_Count <= 4) 
            {
              TFT_LCD_Display_Sprite(LAYER_MENU03, SN_chedaohuiyou_png, 437, 178, 64); 
              Hz2_Count_L++; 
              if (Hz2_Count_L <= 3)
              { 
                TFT_LCD_Clear_Layer(LAYER_MENU02);  
              }
              else
              {
                TFT_LCD_Display_Sprite(LAYER_MENU02, SN_chedaohuangzuo_png, 338, 178, 64);
              }
              if (Hz2_Count_L >= 6)
              {
                Hz2_Count_L = 0;
                Left_LDW_Count++;
              } 
            }
            else
            {
              TFT_LCD_Clear_Layer(LAYER_MENU02);
              TFT_LCD_Clear_Layer(LAYER_MENU03);
            }
          }
          else
          {
            Left_LDW_Count = 0;
            Hz2_Count_L    = 0;
            TFT_LCD_Clear_Layer(LAYER_MENU02);
            TFT_LCD_Clear_Layer(LAYER_MENU03);
          }
        }
        else if (Right_LDW == 1) //ҳƫ
        {
          if (DATA_VEHICLE_SPEED_DISPLAYING >= 550)
          {
            if (Right_LDW_Count <= 4) 
            {
              TFT_LCD_Display_Sprite(LAYER_MENU02, SN_chedaohuizuo_png, 338, 178, 64);
              Hz2_Count_R++; 
              if (Hz2_Count_R <= 3)
              {
                TFT_LCD_Clear_Layer(LAYER_MENU03); 
              }
              else
              { 
                TFT_LCD_Display_Sprite(LAYER_MENU03, SN_chedaohuangyou_png, 437, 178, 64);
              }
              if (Hz2_Count_R >= 6)
              {
                Hz2_Count_R = 0;
                Right_LDW_Count++; 
              }
            }
            else
            {
              TFT_LCD_Clear_Layer(LAYER_MENU02);
              TFT_LCD_Clear_Layer(LAYER_MENU03);
            } 
          }
          else
          {
            Right_LDW_Count = 0;
            Hz2_Count_R     = 0;
            TFT_LCD_Clear_Layer(LAYER_MENU02);
            TFT_LCD_Clear_Layer(LAYER_MENU03);             
          }
        }
      }
      else
      {
        Right_LDW_Count = 0;
        Hz2_Count_R     = 0;          
        Left_LDW_Count  = 0;
        Hz2_Count_L     = 0; 
        if ((Right_Lane_Tracking == 1) || (Leftt_Lane_Tracking == 1))           
        {
          if (Right_Lane_Tracking == 1) //ҳЧ
          {
            TFT_LCD_Display_Sprite(LAYER_MENU03, SN_chedaohuangyou_png, 437, 178, 64);
            TFT_LCD_Display_Sprite(LAYER_MENU02, SN_chedaohuizuo_png, 338, 178, 64);
          }
          else if (Leftt_Lane_Tracking == 1) //󳵵Ч
          {
            TFT_LCD_Display_Sprite(LAYER_MENU02, SN_chedaohuangzuo_png, 338, 178, 64);
            TFT_LCD_Display_Sprite(LAYER_MENU03, SN_chedaohuiyou_png, 437, 178, 64);
          }
        }
        else
        {
          TFT_LCD_Clear_Layer(LAYER_MENU02);
          TFT_LCD_Clear_Layer(LAYER_MENU03);            
        }
      } 
    } 
    else //ƫԤδ
    {
      TFT_LCD_Clear_Layer(LAYER_MENU02);
      TFT_LCD_Clear_Layer(LAYER_MENU03);
      Hz2_Count_R     = 0;
      Right_LDW_Count = 0;
      Left_LDW_Count  = 0;
      Hz2_Count_L     = 0;    
    }
    if (FCW == 1) //ǰײ
    {
      //TFT_LCD_Display_Sprite(LAYER_MENU05, SN_cheti2_png, 371, 237, 64);
      if (DATA_VEHICLE_SPEED_DISPLAYING >= 300)
      {
        Hz2_Count_UFCW = 0;
        UFCW_Count     = 0;
        if (FCW_Count <= 6)
        {
          Hz2_Count_FCW++; 
          if (Hz2_Count_FCW <= 3)
          {
            TFT_LCD_Display_Sprite(LAYER_MENU04, SN_adas_red_car_png, 376, 211, 64); //fhl20200529
          }      
          else
          {
            TFT_LCD_Clear_Layer(LAYER_MENU04);
          }
          if (Hz2_Count_FCW >= 6)
          {
            Hz2_Count_FCW = 0;
            FCW_Count++;
          }
        }
        else
        {
          Hz2_Count_FCW = 0;
          TFT_LCD_Display_Sprite(LAYER_MENU04, SN_adas_red_car_png, 376, 211, 64);
        }
      }
      else
      {
        Hz2_Count_FCW = 0;
        FCW_Count     = 0;
        if (UFCW_Count <= 2)
        {
          Hz2_Count_UFCW++;
          if (Hz2_Count_UFCW <= 5)
            TFT_LCD_Display_Sprite(LAYER_MENU04, SN_adas_red_car_png, 376, 211, 64);
          else
          {
            TFT_LCD_Clear_Layer(LAYER_MENU04);
          }
          if (Hz2_Count_UFCW >= 10)
          {
            Hz2_Count_UFCW = 0;
            UFCW_Count++;
          }
        }
        else
        {
          Hz2_Count_UFCW = 0;
          TFT_LCD_Display_Sprite(LAYER_MENU04, SN_adas_red_car_png, 376, 211, 64);
        }
      }
    }
    else
    {
      Hz2_Count_FCW  = 0;
      Hz2_Count_UFCW = 0;
      FCW_Count      = 0;
      UFCW_Count     = 0; 
      if (Headway_Warning == 1) //
      {
        // TFT_LCD_Display_Sprite(LAYER_MENU04, SN_cheti1_png, 371, 164, 64); //20200228
        TFT_LCD_Display_Sprite(LAYER_MENU05, SN_adas_green_car_png, 376, 211, 64); 
        if (DATA_VEHICLE_SPEED_DISPLAYING > 300)
        {
          if ((Headway_Measurement >= 1) && (Headway_Measurement <= 25)) 
          {
            TFT_LCD_Display_Sprite(LAYER_MENU08, SN_adas_green_point_png, 389, 171, 64);
            GUI_General_Digit_Display(Headway_Measurement, SN_adas_green_0_png, 2, 0, LAYER_MENU09, GUICurONPosX2, 171, 64); //
          }
          else
            TFT_LCD_Clear_Multi_Layer(LAYER_MENU08, LAYER_MENU11);
        }
        else
        {
          TFT_LCD_Clear_Multi_Layer(LAYER_MENU08, LAYER_MENU11);
        }
      }
      else if (Headway_Warning == 2) 
      {
        // TFT_LCD_Display_Sprite(LAYER_MENU04, SN_cheti2_png, 371, 164, 64); //20200228
        TFT_LCD_Display_Sprite(LAYER_MENU05, SN_adas_red_car_png, 376, 211, 64);
        if (DATA_VEHICLE_SPEED_DISPLAYING > 300)
        {
          if ((Headway_Measurement >= 1) && (Headway_Measurement <= 25)) 
          {
            TFT_LCD_Display_Sprite(LAYER_MENU08, SN_adas_red_point_png, 389, 171, 64);
            GUI_General_Digit_Display(Headway_Measurement, SN_adas_red_0_png, 2, 0, LAYER_MENU09, GUICurONPosX2, 171, 64); //
          }
          else
          {
            TFT_LCD_Clear_Multi_Layer(LAYER_MENU08, LAYER_MENU11);
          }
        }
        else
        {
          TFT_LCD_Clear_Multi_Layer(LAYER_MENU08, LAYER_MENU11);
        }
      }
      else
      {
        //TFT_LCD_Display_Sprite(LAYER_MENU05, SN_cheti1_png, 360, 237, 64);
        TFT_LCD_Clear_Layer(LAYER_MENU04);
        TFT_LCD_Clear_Layer(LAYER_MENU05);
        TFT_LCD_Clear_Multi_Layer(LAYER_MENU08, LAYER_MENU11); 
      }
    }
    
    if ((PCW == 1) && (DATA_VEHICLE_SPEED_DISPLAYING < 500)) // ײ
    {
      if (PCW_Count <= 6)
      {
        Hz2_Count_PCW++;
        if (Hz2_Count_PCW <= 3)
        {
          TFT_LCD_Display_Sprite(LAYER_MENU06, SN_ren1_png, 319, 155, 64);
        }
        else
          TFT_LCD_Clear_Layer(LAYER_MENU06);
        if (Hz2_Count_PCW >= 6)
        {
          Hz2_Count_PCW = 0;
          PCW_Count++;
        }
      }
    }
    else
    {
      Hz2_Count_PCW = 0;
      PCW_Count     = 0;
      TFT_LCD_Clear_Layer(LAYER_MENU06);
    }
    if ((Ped_In_Zone == 1) && (DATA_VEHICLE_SPEED_DISPLAYING < 500)) // ײ
    {
      TFT_LCD_Display_Sprite(LAYER_MENU07, SN_ren2_png, 319, 155, 64);
    }
    else
    {
      TFT_LCD_Clear_Layer(LAYER_MENU07);
    }
  }
  else
  {
    TFT_LCD_Clear_Multi_Layer(LAYER_MENU01, LAYER_MENU14);  
  }  
}