/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import java.io.File;
import junit.framework.TestCase;

public class NameTests
extends TestCase {
    private static final boolean DEBUG = false;
    private static final TestFont.TestFontNames[] testFonts = new TestFont.TestFontNames[]{TestFont.TestFontNames.OPENSANS};
    private static final int[][] nameTestResults = new int[][]{{26, 13, 13}};

    public NameTests() {
    }

    public NameTests(String name) {
        super(name);
    }

    public void testNameEntries() throws Exception {
        int i = 0;
        while (i < testFonts.length) {
            File fontFile = testFonts[i].getFile();
            Font[] fonts = TestFontUtils.loadFont(fontFile);
            Font font = fonts[0];
            NameTable nameTable = (NameTable)font.getTable(Tag.name);
            NameTable.NameId[] nameIds = NameTable.NameId.values();
            int nameCount = 0;
            int winNameCount = 0;
            int macNameCount = 0;
            int nameIndex = 0;
            while (nameIndex < nameTable.nameCount()) {
                NameTable.NameEntry entry = nameTable.nameEntry(nameIndex);
                ++nameCount;
                if (entry.platformId() == Font.PlatformId.Macintosh.value()) {
                    ++macNameCount;
                }
                if (entry.platformId() == Font.PlatformId.Windows.value()) {
                    ++winNameCount;
                }
                ++nameIndex;
            }
            NameTests.assertEquals(nameTestResults[i][0], nameCount);
            NameTests.assertEquals(nameTestResults[i][1], macNameCount);
            NameTests.assertEquals(nameTestResults[i][2], winNameCount);
            NameTests.assertEquals(nameTable.nameCount(), nameCount);
            ++i;
        }
    }
}

