/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import java.io.ByteArrayOutputStream;

public class BitIOWriter {
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private byte byteBuf = 0;
    private int bitCount = 0;

    public void writeBit(int bit) {
        this.byteBuf = (byte)(this.byteBuf | bit << 7 - this.bitCount);
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.buf.write(this.byteBuf);
            this.byteBuf = 0;
            this.bitCount = 0;
        }
    }

    public void writeBit(boolean bit) {
        this.writeBit(bit ? 1 : 0);
    }

    public void writeValue(int value, int numBits) {
        int i = numBits - 1;
        while (i >= 0) {
            this.writeBit(value >> i & 1);
            --i;
        }
    }

    public void flush() {
        if (this.bitCount > 0) {
            this.buf.write(this.byteBuf);
            this.byteBuf = 0;
            this.bitCount = 0;
        }
    }

    public byte[] toByteArray() {
        return this.buf.toByteArray();
    }
}

