/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;
import java.io.IOException;

public abstract class ByteArrayTableBuilder<T extends Table>
extends TableBasedTableBuilder<T> {
    protected ByteArrayTableBuilder(Header header, WritableFontData data) {
        super(header, data);
    }

    protected ByteArrayTableBuilder(Header header, ReadableFontData data) {
        super(header, data);
    }

    public int byteValue(int index) throws IOException {
        ReadableFontData data = this.internalReadData();
        if (data == null) {
            throw new IOException("No font data for the table.");
        }
        return data.readByte(index);
    }

    public void setByteValue(int index, byte b) throws IOException {
        WritableFontData data = this.internalWriteData();
        if (data == null) {
            throw new IOException("No font data for the table.");
        }
        data.writeByte(index, b);
    }

    public int byteCount() throws IOException {
        ReadableFontData data = this.internalReadData();
        if (data == null) {
            throw new IOException("No font data for the table.");
        }
        return data.length();
    }
}

