/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;

public final class HorizontalMetricsTable
extends Table {
    private int numHMetrics;
    private int numGlyphs;

    private HorizontalMetricsTable(Header header, ReadableFontData data, int numHMetrics, int numGlyphs) {
        super(header, data);
        this.numHMetrics = numHMetrics;
        this.numGlyphs = numGlyphs;
    }

    public int numberOfHMetrics() {
        return this.numHMetrics;
    }

    public int numberOfLSBs() {
        return this.numGlyphs - this.numHMetrics;
    }

    public int hMetricAdvanceWidth(int entry) {
        if (entry > this.numHMetrics) {
            throw new IndexOutOfBoundsException();
        }
        int offset = Offset.hMetricsStart.offset + entry * Offset.hMetricsSize.offset + Offset.hMetricsAdvanceWidth.offset;
        return this.data.readUShort(offset);
    }

    public int hMetricLSB(int entry) {
        if (entry > this.numHMetrics) {
            throw new IndexOutOfBoundsException();
        }
        int offset = Offset.hMetricsStart.offset + entry * Offset.hMetricsSize.offset + Offset.hMetricsLeftSideBearing.offset;
        return this.data.readShort(offset);
    }

    public int lsbTableEntry(int entry) {
        if (entry > this.numberOfLSBs()) {
            throw new IndexOutOfBoundsException();
        }
        int offset = Offset.hMetricsStart.offset + this.numHMetrics * Offset.hMetricsSize.offset + entry * Offset.LeftSideBearingSize.offset;
        return this.data.readShort(offset);
    }

    public int advanceWidth(int glyphId) {
        if (glyphId < this.numHMetrics) {
            return this.hMetricAdvanceWidth(glyphId);
        }
        return this.hMetricAdvanceWidth(this.numHMetrics - 1);
    }

    public int leftSideBearing(int glyphId) {
        if (glyphId < this.numHMetrics) {
            return this.hMetricLSB(glyphId);
        }
        return this.lsbTableEntry(glyphId - this.numHMetrics);
    }

    /* synthetic */ HorizontalMetricsTable(Header header, ReadableFontData readableFontData, int n, int n2, HorizontalMetricsTable horizontalMetricsTable) {
        this(header, readableFontData, n, n2);
    }

    public static class Builder
    extends TableBasedTableBuilder<HorizontalMetricsTable> {
        private int numHMetrics = -1;
        private int numGlyphs = -1;

        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        @Override
        protected HorizontalMetricsTable subBuildTable(ReadableFontData data) {
            return new HorizontalMetricsTable(this.header(), data, this.numHMetrics, this.numGlyphs, null);
        }

        public void setNumberOfHMetrics(int numHMetrics) {
            if (numHMetrics < 0) {
                throw new IllegalArgumentException("Number of metrics can't be negative.");
            }
            this.numHMetrics = numHMetrics;
            ((HorizontalMetricsTable)this.table()).numHMetrics = numHMetrics;
        }

        public void setNumGlyphs(int numGlyphs) {
            if (numGlyphs < 0) {
                throw new IllegalArgumentException("Number of glyphs can't be negative.");
            }
            this.numGlyphs = numGlyphs;
            ((HorizontalMetricsTable)this.table()).numGlyphs = numGlyphs;
        }
    }

    private static enum Offset {
        hMetricsStart(0),
        hMetricsSize(4),
        hMetricsAdvanceWidth(0),
        hMetricsLeftSideBearing(2),
        LeftSideBearingSize(2);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

