/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.tools.conversion.eot.BitIOWriter;

public class HuffmanEncoder {
    private static final int ROOT = 1;
    private TreeNode[] tree;
    private short[] symbolIndex;
    private int bitCount2;
    private int range;
    private BitIOWriter bits;

    public HuffmanEncoder(BitIOWriter bits, int range) {
        this.bits = bits;
        this.range = range;
        HuffmanEncoder.bitsUsed(range - 1);
        this.bitCount2 = range > 256 && range < 512 ? HuffmanEncoder.bitsUsed(range - 257) : 0;
        this.symbolIndex = new short[range];
        int limit = 2 * range;
        this.tree = new TreeNode[limit];
        int i = 0;
        while (i < limit) {
            this.tree[i] = new TreeNode();
            ++i;
        }
        i = 2;
        while (i < limit) {
            this.tree[i].up = (short)(i / 2);
            this.tree[i].weight = 1;
            ++i;
        }
        i = 1;
        while (i < range) {
            this.tree[i].left = (short)(2 * i);
            this.tree[i].right = (short)(2 * i + 1);
            ++i;
        }
        i = 0;
        while (i < range) {
            this.tree[i].code = (short)-1;
            this.tree[range + i].code = (short)i;
            this.tree[range + i].left = (short)-1;
            this.tree[range + i].right = (short)-1;
            this.symbolIndex[i] = (short)(range + i);
            ++i;
        }
        this.initWeight(1);
        if (this.bitCount2 != 0) {
            this.updateWeight(this.symbolIndex[256]);
            this.updateWeight(this.symbolIndex[257]);
            i = 0;
            while (i < 12) {
                this.updateWeight(this.symbolIndex[range - 3]);
                ++i;
            }
            i = 0;
            while (i < 6) {
                this.updateWeight(this.symbolIndex[range - 2]);
                ++i;
            }
        } else {
            int j = 0;
            while (j < 2) {
                int i2 = 0;
                while (i2 < range) {
                    this.updateWeight(this.symbolIndex[i2]);
                    ++i2;
                }
                ++j;
            }
        }
    }

    String checkTree() {
        short a;
        int i = 1;
        while (i < this.range) {
            if (this.tree[i].code < 0) {
                if (this.tree[this.tree[i].left].up != i) {
                    return "tree[tree[" + i + "].left].up == " + this.tree[this.tree[i].left].up + ", expected " + i;
                }
                if (this.tree[this.tree[i].right].up != i) {
                    return "tree[tree[" + i + "].right].up == " + this.tree[this.tree[i].right].up + ", expected " + i;
                }
            }
            ++i;
        }
        i = 1;
        while (i < this.range) {
            if (this.tree[i].code < 0 && this.tree[i].weight != this.tree[this.tree[i].left].weight + this.tree[this.tree[i].right].weight) {
                return "tree[" + i + "].weight == " + this.tree[i].weight + ", expected " + this.tree[this.tree[i].left].weight + " + " + this.tree[this.tree[i].right].weight;
            }
            ++i;
        }
        int j = this.range * 2 - 1;
        int i2 = 1;
        while (i2 < j) {
            if (this.tree[i2].weight < this.tree[i2 + 1].weight) {
                return "tree[" + i2 + "].weight == " + this.tree[i2].weight + ", tree[" + (i2 + 1) + ".weight == " + this.tree[i2 + 1].weight + ", not >=";
            }
            ++i2;
        }
        i2 = 2;
        while (i2 < j) {
            short b;
            if (this.tree[i2].code < 0 && (a = this.tree[i2].left) - (b = this.tree[i2].right) != 1 && a - b != -1) {
                return "tree[" + i2 + "].left == " + this.tree[i2].left + ", tree[" + i2 + "].right] == " + this.tree[i2].right + ", siblings not adjacent";
            }
            ++i2;
        }
        i2 = 2;
        while (i2 < this.range * 2) {
            a = this.tree[i2].up;
            if (this.tree[a].left != i2 && this.tree[a].right != i2) {
                return "tree[" + a + "].left != " + i2 + " && tree[" + a + "].right != " + i2;
            }
            ++i2;
        }
        return null;
    }

    private int initWeight(int a) {
        if (this.tree[a].code < 0) {
            this.tree[a].weight = this.initWeight(this.tree[a].left) + this.initWeight(this.tree[a].right);
        }
        return this.tree[a].weight;
    }

    private void updateWeight(int a) {
        while (a != 1) {
            int weightA = this.tree[a].weight;
            int b = a - 1;
            if (this.tree[b].weight == weightA) {
                while (this.tree[--b].weight == weightA) {
                }
                if (++b > 1) {
                    this.swapNodes(a, b);
                    a = b;
                }
            }
            this.tree[a].weight = ++weightA;
            a = this.tree[a].up;
        }
        ++this.tree[a].weight;
    }

    private void swapNodes(int a, int b) {
        short upa = this.tree[a].up;
        short upb = this.tree[b].up;
        TreeNode tmp = this.tree[a];
        this.tree[a] = this.tree[b];
        this.tree[b] = tmp;
        this.tree[a].up = upa;
        this.tree[b].up = upb;
        short code = this.tree[a].code;
        if (code < 0) {
            this.tree[this.tree[a].left].up = (short)a;
            this.tree[this.tree[a].right].up = (short)a;
        } else {
            this.symbolIndex[code] = (short)a;
        }
        code = this.tree[b].code;
        if (code < 0) {
            this.tree[this.tree[b].left].up = (short)b;
            this.tree[this.tree[b].right].up = (short)b;
        } else {
            this.symbolIndex[code] = (short)b;
        }
    }

    public int writeSymbolCost(int symbol) {
        short a = this.symbolIndex[symbol];
        int sp = 0;
        do {
            ++sp;
        } while ((a = this.tree[a].up) != 1);
        return sp << 16;
    }

    public void writeSymbol(int symbol) {
        short up;
        short a;
        short aa = a = this.symbolIndex[symbol];
        boolean[] stack = new boolean[50];
        int sp = 0;
        do {
            up = this.tree[a].up;
            boolean bl = stack[sp++] = this.tree[up].right == a;
        } while ((a = up) != 1);
        do {
            this.bits.writeBit(stack[--sp]);
        } while (sp > 0);
        this.updateWeight(aa);
    }

    public static int bitsUsed(int x) {
        int i = 32;
        while (i > 1) {
            if ((x & 1 << i - 1) != 0) break;
            --i;
        }
        return i;
    }

    private static class TreeNode {
        short up;
        short left;
        short right;
        short code;
        int weight;

        private TreeNode() {
        }
    }
}

