/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.PostScriptTable;
import com.google.typography.font.tools.subsetter.PostScriptTableBuilder;
import java.util.ArrayList;
import junit.framework.TestCase;

public class PostScriptTableBuilderTest
extends TestCase {
    public void testPostTableBuilding() {
        FontFactory fontFactory = FontFactory.getInstance();
        Font.Builder fontBuilder = fontFactory.newFontBuilder();
        ArrayList<String> names = new ArrayList<String>();
        names.add(".notdef");
        names.add("numbersign");
        names.add("nonstandardglyph");
        names.add("dcroat");
        names.add("nonstandardglyph2");
        PostScriptTableBuilder postBuilder = new PostScriptTableBuilder();
        postBuilder.setNames(names);
        fontBuilder.newTableBuilder(Tag.post, postBuilder.build());
        Font font = fontBuilder.build();
        PostScriptTable post = (PostScriptTable)font.getTable(Tag.post);
        PostScriptTableBuilderTest.assertEquals(131072, post.version());
        PostScriptTableBuilderTest.assertEquals(names.size(), post.numberOfGlyphs());
        int i = 0;
        while (i < names.size()) {
            PostScriptTableBuilderTest.assertEquals((String)names.get(i), post.glyphName(i));
            ++i;
        }
        PostScriptTableBuilderTest.assertEquals(79, post.dataLength());
        PostScriptTableBuilderTest.assertEquals(79, post.headerLength());
    }
}

