/******************************************************************************
  Analog_Signal_Conversion.h
ģźתͷļ
    ߣ
    V1.0
    ڣ2017.03.25
******************************************************************************/

#ifndef _ANALOG_SIGNAL_CONVERSION_H_
#define _ANALOG_SIGNAL_CONVERSION_H_

#include "ADC.h"
#include "CAN_Communication_Matrix.h"
#include "Non_volatile_Memorys.h"
/******************************************************************************
KL30Դѹ

1.ʹ/ֹKL30ѹ
2.·ΪµЧ·
3.򻯺ĵЧ·Ӳز


                 Equivalent Circuit                                                                         

     KL30                                                                                                   
     Щ                                                                                                 
                                                                                                          
     ة                                                                                                 
        RE1                                                                                             
     Щ                                                                                                 
                          ADC Analog Input Channel                                                        
       Щ>  ANALOG_KL30_ADC_CH                                              
                                                                                                        
     ة                                                                                               
        RE2        ة CE1                                                                           
     Щ            Щ                                                                               
                                                                                                        
     ة            ة                                                                               
      GND               GND                                                                                 

******************************************************************************/
#define   ANALOG_SIG_KL30_VOLTAGE                     0  //ģͶ
#define   ANALOG_KL30_VOLTAGE_DET_ENABLE              1  //KL30Դѹʹ  //Ӳʹܡ

#define   ANALOG_KL30_ADC_CH                          11
#define   ANALOG_KL30_EQU_CIRCIUT_RE1                 330
//#define   ANALOG_KL30_EQU_CIRCIUT_RE2                 47

#define   ANALOG_KL30_VOLTAGE_OFFSET                  0  //KL30Դѹƫ,λmV
#define   ANALOG_KL30_VOLTAGE_NEGATIVE_OFFSET         0  //0 - KL30Դѹƫ 1 - KL30Դѹƫ

/******************************************************************************
KL15Դѹ

1.ʹ/ֹKL15ѹ
2.·ΪµЧ·
3.򻯺ĵЧ·Ӳز


                 Equivalent Circuit                                                                         

     KL15                                                                                                   
     Щ                                                                                                 
                                                                                                          
     ة                                                                                                 
        RE1                                                                                             
     Щ                                                                                                 
                          ADC Analog Input Channel                                                        
       Щ>  ANALOG_KL15_ADC_CH                                              
                                                                                                        
     ة                                                                                               
        RE2        ة CE1                                                                           
     Щ            Щ                                                                               
                                                                                                        
     ة            ة                                                                               
      GND               GND                                                                                 

******************************************************************************/
#define   ANALOG_SIG_KL15_VOLTAGE                     1  //ģͶ
#define   ANALOG_KL15_VOLTAGE_DET_ENABLE              1  //KL15Դѹʹ

#define   ANALOG_KL15_ADC_CH                          10
#define   ANALOG_KL15_EQU_CIRCIUT_RE1                 330
//#define   ANALOG_KL15_EQU_CIRCIUT_RE2                 47

#define   ANALOG_KL15_VOLTAGE_OFFSET                  0  //KL15Դѹƫ,λmV
#define   ANALOG_KL15_VOLTAGE_NEGATIVE_OFFSET         0  //0 - KL15Դѹƫ 1 - KL15Դѹƫ

/******************************************************************************
׼ȼ

1.ʹ/ֹ׼ȼ
2.·ΪµЧ·
3.ʱ,RE3 RE4ԶRE1 RE2,RE3RE4ĵС,ɺԲ,,RE3
  RE4V1ѹ.ӶֻҪRE1RE2OhmΪλ,RE3RE4λͬ.
  ,RE1RE2OhmΪλͬʱRE3RE4kOhmΪλӰ
4.򻯺ĵЧ·Ӳز


                          Equivalent Circuit                                                                                                

     KL15                                                                                                                                   
     Щ                                                                                                                                 
                                                                                                                                          
     ة                                                                                                                                 
        RE1                                                                                                                             
     Щ                                                                                                                                 
                                                                                                                                          
        <(V1)                                                                                         
                                                                                                                                        
     ة                          ة                                                                                                 
        RE2                         RE3                                                                                             
     Щ                          Щ                                                                                                 
                                                        ADC Analog Input Channel                                                        
                                     Щ>  ANALOG_FUEL_ADC_CH                                                      
                                                                                                                                  
     ة/    R                    ة                                                                                               
      / Fuel Level                 RE4 ة CE1                                                                                   
    /Щ   Sensor                 Щ    Щ                                                                                       
                                                                                                                                      
     ة                          ة    ة                                                                                       
      GND                             GND       GND                                                                                         

******************************************************************************/
#define   ANALOG_SIG_STANDARD_FUEL_SENSOR_RES         2         //ģͶ
#define   ANALOG_STANDARD_FUEL_SENSOR_RES_DET_ENABLE  1         //׼ȼʹʹ

#define   ANALOG_FUEL_ADC_CH                          6
#define   ANALOG_FUEL_EQU_CIRCIUT_RE1                 100
#define   ANALOG_FUEL_EQU_CIRCIUT_RE2                 30
#define   ANALOG_FUEL_EQU_CIRCIUT_RE3                 33
#define   ANALOG_FUEL_EQU_CIRCIUT_RE4                 33

/*
#if (Power_Mod == Power_Version_24)
  #define   ANALOG_FUEL_CONV_KL15_VOLTAGE_RANGE_LO    16000     //ȼʹֵתĵѹΧ(͵ѹ),λmV
  #define   ANALOG_FUEL_CONV_KL15_VOLTAGE_RANGE_HI    32000     //ȼʹֵתĵѹΧ(ߵѹ),λmV
#else
  #define   ANALOG_FUEL_CONV_KL15_VOLTAGE_RANGE_LO    6500      //ȼʹֵתĵѹΧ(͵ѹ),λmV
  #define   ANALOG_FUEL_CONV_KL15_VOLTAGE_RANGE_HI    18000     //ȼʹֵתĵѹΧ(ߵѹ),λmV
#endif    
*/

#define   ANALOG_FUEL_RES_OFFSET                      0         //ȼʹֵƫ,λ0.1 Ohm

/******************************************************************************
ѹ

1.ʹ/ֹѹ
2.·ΪµЧ·
3.򻯺ĵЧ·Ӳز


                 Equivalent Circuit                                                                         

      GAS                                                                                                   
     Щ                                                                                                 
                                                                                                          
     ة                                                                                                 
        RE1                                                                                             
     Щ                                                                                                 
                          ADC Analog Input Channel                                                        
       Щ>  ANALOG_GAS_ADC_CH                                               
                                                                                                        
     ة                                                                                               
        RE2        ة CE1                                                                           
     Щ            Щ                                                                               
                                                                                                        
     ة            ة                                                                               
      GND               GND                                                                                 

******************************************************************************/
#define   ANALOG_SIG_GAS1_VOLTAGE                     3  //ģͶ
#define   ANALOG_GAS1_VOLTAGE_DET_ENABLE              1  //GAS1ѹʹ

#define   ANALOG_GAS1_ADC_CH                          9
#define   ANALOG_GAS1_EQU_CIRCIUT_RE1                 1
#define   ANALOG_GAS1_EQU_CIRCIUT_RE2                 2000

#define   ANALOG_GAS1_VOLTAGE_OFFSET                  0  //ѹƫ,λmV
#define   ANALOG_GAS1_VOLTAGE_NEGATIVE_OFFSET         0  //0 - ѹƫ 1 - ѹƫ

#define   ANALOG_SIG_GAS2_VOLTAGE                     4  //ģͶ
#define   ANALOG_GAS2_VOLTAGE_DET_ENABLE              1  //GAS1ѹʹ

#define   ANALOG_GAS2_ADC_CH                          8
#define   ANALOG_GAS2_EQU_CIRCIUT_RE1                 1
#define   ANALOG_GAS2_EQU_CIRCIUT_RE2                 2000

#define   ANALOG_GAS2_VOLTAGE_OFFSET                  0  //ѹƫ,λmV
#define   ANALOG_GAS2_VOLTAGE_NEGATIVE_OFFSET         0  //0 - ѹƫ 1 - ѹƫ

#define   ANALOG_SIG_STANDARD_KEY_SENSOR_RES          5  //ģͶ
#define   ANALOG_KEY_VOLTAGE_DET_ENABLE               1  //KEYʹܡ

#define   ANALOG_KEY_ADC_CH                           2  //ͨѡ20190510 changed by FHL   ƥδ壬Ӳ
 
/* 
#if Power_Mod == Power_Version_24
  #define   ANALOG_KEY_CONV_KL15_VOLTAGE_RANGE_LO     16000     //ֵתĵѹΧ(͵ѹ),λmV
  #define   ANALOG_KEY_CONV_KL15_VOLTAGE_RANGE_HI     32000     //ֵתĵѹΧ(ߵѹ),λmV
#else
  #define   ANALOG_KEY_CONV_KL15_VOLTAGE_RANGE_LO     6500      //ֵתĵѹΧ(͵ѹ),λmV
  #define   ANALOG_KEY_CONV_KL15_VOLTAGE_RANGE_HI     18000     //ֵתĵѹΧ(ߵѹ),λmV
#endif    
*/
/******************************************************************************
ȫֱ
******************************************************************************/
#if ANALOG_STANDARD_FUEL_SENSOR_RES_DET_ENABLE
  extern volatile uint16_t AnalogFuelSensorRes;       //ȼʹֵ,λ0.1 Ohm
  extern volatile uint16_t AnalogFuelSensorResValid;  //ȼʹֵЧ

  #define ANALOG_FUEL_SENSOR_RES                      AnalogFuelSensorRes
  #define ANALOG_FUEL_SENSOR_RES_VALID                AnalogFuelSensorResValid

  #define ANALOG_KL15_VOLTAGE_DET_ENABLE              1
#endif

#define  ANALOG_STANDARD_COOLING_SENSOR_RES_DET_ENABLE   0

#if ANALOG_STANDARD_COOLING_SENSOR_RES_DET_ENABLE
  extern volatile uint16_t AnalogCOOLINGSensorRes;       //ˮ´ֵ,λ0.1 Ohm
  extern volatile uint16_t AnalogCOOLINGSensorResValid;  //ˮ´ֵЧ

  #define ANALOG_COOLING_SENSOR_RES                      AnalogCOOLINGSensorRes
  #define ANALOG_COOLING_SENSOR_RES_VALID                AnalogCOOLINGSensorResValid
#endif

#if ANALOG_KL15_VOLTAGE_DET_ENABLE
  extern volatile uint16_t AnalogKL15Voltage;         //KL15ѹ,λmV
  extern volatile uint8_t  AnalogKL15VoltageValid;    //KL15ѹЧ

  #define ANALOG_KL15_VOLTAGE                         AnalogKL15Voltage
  #define ANALOG_KL15_VOLTAGE_VALID                   AnalogKL15VoltageValid
#endif

#if ANALOG_KL30_VOLTAGE_DET_ENABLE
  extern volatile uint16_t AnalogKL30Voltage;         //KL30ѹ,λmV
  extern volatile uint8_t  AnalogKL30VoltageValid;    //KL30ѹЧ

  #define ANALOG_KL30_VOLTAGE                         AnalogKL30Voltage
  #define ANALOG_KL30_VOLTAGE_VALID                   AnalogKL30VoltageValid
#endif


#if ANALOG_GAS1_VOLTAGE_DET_ENABLE
  extern volatile uint16_t AnalogGAS1Voltage;         //GAS1ѹ,λmV
  extern volatile uint8_t  AnalogGAS1VoltageValid;    //GAS1ѹЧ

  #define ANALOG_GAS1_VOLTAGE                         AnalogGAS1Voltage
  #define ANALOG_GAS1_VOLTAGE_VALID                   AnalogGAS1VoltageValid
#endif

#if ANALOG_GAS2_VOLTAGE_DET_ENABLE
  extern volatile uint16_t AnalogGAS2Voltage;         //GAS1ѹ,λmV
  extern volatile uint8_t  AnalogGAS2VoltageValid;    //GAS1ѹЧ

  #define ANALOG_GAS2_VOLTAGE                         AnalogGAS2Voltage
  #define ANALOG_GAS2_VOLTAGE_VALID                   AnalogGAS2VoltageValid
#endif

#if ANALOG_KEY_VOLTAGE_DET_ENABLE
  extern volatile uint16_t AnalogKEYSensorVoltage;      //KEYλmV
  extern volatile uint16_t AnalogKEYSensorVoltageValid; //KEYֵЧ

  #define ANALOG_KEY_SENSOR_Vol                       AnalogKEYSensorVoltage
  #define ANALOG_KEY_SENSOR_Vol_VALID                 AnalogKEYSensorVoltageValid

#endif
/******************************************************************************
תƽṹ
******************************************************************************/
typedef struct
{
  uint8_t   TotalChCnt;
  uint8_t   CurrentCh;
  uint8_t   Busy;
  uint8_t   SignalType[ADC_MAX_CHANNEL_CNT];
  uint8_t   ChNumber[ADC_MAX_CHANNEL_CNT];
} AnalogConvCtrlStruct;

/******************************************************************************

******************************************************************************/
void Analog_Signal_Converter_Init(void);
void Analog_Signal_Conversion_Service(void);
void Analog_KL30_Voltage_Conversion(void);
void Analog_KL15_Voltage_Conversion(void);

#endif
