/********************************************************************************/
/*  CONFIDENTIAL                                                                */
/*  Copyright (C) 2011 Yamaha Corporation. All rights reserved.                 */
/*  Module          : $Workfile: YGV642_SPI_Flash_S25FL256S.h $                 */
/*  Description     : Pattern memory S25FL256S driver include header            */
/*  Version         : $Rev: 145 $                                               */
/*  Last UpDate Time: $Date:: 2012-08-24 13:55:38#$                             */
/*  FOOT NOTE       : adjust 2tab                                               */
/*  AUTHOR          : H.Katayama                                                */
/********************************************************************************/
#ifndef _YGV642_SPI_FLASH_S25FL256S_H_
#define _YGV642_SPI_FLASH_S25FL256S_H_

#include "YGV642.h"

enum PM_S25FL256S_CMD
{
  PM_S25FL256S_CMD_READ_JEDEC_ID,
	PM_S25FL256S_CMD_WRITE_ENABLE,
	PM_S25FL256S_CMD_WRITE_STATUS,
	PM_S25FL256S_CMD_READ_STATUS,
	PM_S25FL256S_CMD_CHIP_ERASE,
	PM_S25FL256S_CMD_SECTOR_ERASE,
	PM_S25FL256S_CMD_Q_PAGE_PROGRAM,
	PM_S25FL256S_CMD_Q_IO_READ,
};

/*------------------------------------------------------------------------------*/
/*                      D E F I N E                                             */
/*------------------------------------------------------------------------------*/

#define PM_S25FL256S_POLLING_COUNT_MAX      (3000000)
#define PM_S25FL256S_READ_REGISTER_MASK     (0x03)

#define PM_S25FL256S_READACS_PMRREQ         (0x80)
#define PM_S25FL256S_READACS_PWBUSY         (0x40)
#define PM_S25FL256S_READACS_CSNEG          (0x10)

#define PM_S25FL256S_MANUFACTURER_ID        (0x01)
#define PM_S25FL256S_DEVICE_ID_MSB          (0x02)
#define PM_S25FL256S_DEVICE_ID_LSB          (0x19)

/*------------------------------------------------------------------------------*/
/*                      V A R I A B L E S                                       */
/*------------------------------------------------------------------------------*/
static const uint8_t PMS25FL256SCmdData[][7] =
{
 /* R#55h R#56h R#57h R#58h R#59h R#5Ah R#5Bh */
  { 0x06, 0x03, 0x00, 0x03, 0x9F, 0x00, 0x00 }, /* Read JEDEC ID      */
	{ 0x06, 0x18, 0x00, 0x03, 0x06, 0x00, 0x00 }, /* Write Enable       */
	{ 0x06, 0x1B, 0x00, 0x03, 0x01, 0x00, 0x00 }, /* Write Status       */
	{ 0x06, 0x03, 0x00, 0x03, 0x05, 0x00, 0x00 }, /* Read Status        */
	{ 0x06, 0x18, 0x00, 0x03, 0xC7, 0x00, 0x00 }, /* Chip Erase         */
	{ 0x06, 0x18, 0x30, 0x03, 0xDC, 0x00, 0x00 }, /* Sector Erase       */
	{ 0x06, 0x19, 0x30, 0x03, 0x34, 0x00, 0x00 }, /* Quad Page Program  */
	{ 0x06, 0x81, 0x22, 0x13, 0xEC, 0x00, 0x00 }, /* Quad I/O Read Mode */
};

/*------------------------------------------------------------------------------*/
/*                      F U N C T I O N S                                       */
/*------------------------------------------------------------------------------*/
uint8_t PM_S25FL256S_ID_Check(void);
void PM_S25FL256S_Init(void);
void PM_S25FL256S_Write_Enable(void);
void PM_S25FL256S_Check_Pattern_Memory_Status_Reg(uint32_t Addr);
void PM_S25FL256S_Set_Pattern_Memory_Addr(uint32_t Addr);
void PM_S25FL256S_Write_Cmd(uint8_t CmdNo);
void PM_S25FL256S_Read_Pattern_Memory_Data_Port(uint8_t *Data);
void PM_S25FL256S_Wait_Clear_Flag(uint8_t Mask);

#endif
