/******************************************************************************
  Stepper_Motor.h
ͷļ
    ߣ
    V1.0
    ڣ2017.04.18
******************************************************************************/

#ifndef _STEPPER_MOTOR_H_
#define _STEPPER_MOTOR_H_

#include <hidef.h>
#include "API.h"
#include "Motor_Controller.h"

/******************************************************************************
ѡ
******************************************************************************/
//#define   USE_VID29_STEPPER_MOTOR           1   //ΰVID29
#define   USE_TYD5660_STEPPER_MOTOR         1   //TYD5660

/******************************************************************************
Ԥ
******************************************************************************/
#if   defined (USE_VID29_STEPPER_MOTOR)
  #include "VID29.h"
#elif defined (USE_TYD5660_STEPPER_MOTOR)
  #include "TYD5660.h"
#else
  #error  Select stepper motor in Stepper_Motor.h
#endif

/******************************************************************************
ȫֱ
******************************************************************************/
extern volatile uint16_t   StepperMotor0CurStep;
extern volatile uint16_t   StepperMotor0DstStep;
#define    STEPPER_MOTOR_0_CUR_STEP         StepperMotor0CurStep  //0ǰ΢
#define    STEPPER_MOTOR_0_DST_STEP         StepperMotor0DstStep  //0Ŀ΢

extern volatile uint16_t   StepperMotor1CurStep;
extern volatile uint16_t   StepperMotor1DstStep;
#define    STEPPER_MOTOR_1_CUR_STEP         StepperMotor1CurStep  //1ǰ΢
#define    STEPPER_MOTOR_1_DST_STEP         StepperMotor1DstStep  //1Ŀ΢

extern volatile uint16_t   StepperMotor2CurStep;
extern volatile uint16_t   StepperMotor2DstStep;
#define    STEPPER_MOTOR_2_CUR_STEP         StepperMotor2CurStep  //2ǰ΢
#define    STEPPER_MOTOR_2_DST_STEP         StepperMotor2DstStep  //2Ŀ΢

extern volatile uint16_t   StepperMotor3CurStep;
extern volatile uint16_t   StepperMotor3DstStep;
#define    STEPPER_MOTOR_3_CUR_STEP         StepperMotor3CurStep  //3ǰ΢
#define    STEPPER_MOTOR_3_DST_STEP         StepperMotor3DstStep  //3Ŀ΢

/******************************************************************************

******************************************************************************/
#ifndef   STEPPER_MOTOR_0_ENABLE
  #define STEPPER_MOTOR_0_ENABLE            MOTOR_0_ENABLE
  #define STEPPER_MOTOR_0_REVERSE           0                     //0ת
  #define STEPPER_MOTOR_0_SPEED_MAX         1080                  //0תٶ   ÿ
  #define STEPPER_MOTOR_0_ACC               40                    //0תٶ
#endif

#ifndef   STEPPER_MOTOR_1_ENABLE
  #define STEPPER_MOTOR_1_ENABLE            MOTOR_1_ENABLE
  #define STEPPER_MOTOR_1_REVERSE           0                     //1ת
  #define STEPPER_MOTOR_1_SPEED_MAX         1080                  //1תٶ
  #define STEPPER_MOTOR_1_ACC               40                   //1תٶ
#endif

#ifndef   STEPPER_MOTOR_2_ENABLE
  #define STEPPER_MOTOR_2_ENABLE            MOTOR_2_ENABLE
  #define STEPPER_MOTOR_2_REVERSE           1                     //2ת
  #define STEPPER_MOTOR_2_SPEED_MAX         1080                  //2תٶ
  #define STEPPER_MOTOR_2_ACC               40                    //2תٶ
#endif

#ifndef   STEPPER_MOTOR_3_ENABLE
  #define STEPPER_MOTOR_3_ENABLE            MOTOR_3_ENABLE
  #define STEPPER_MOTOR_3_REVERSE           1                     //3ת
  #define STEPPER_MOTOR_3_SPEED_MAX         1080                  //3תٶ
  #define STEPPER_MOTOR_3_ACC               40                    //3תٶ
#endif

/******************************************************************************
Ԥ
******************************************************************************/
#if   (STEPPER_MOTOR_0_SPEED_MAX < STEPPER_MOTOR_SPEED_MIN)
  #error "STEPPER_MOTOR_0_SPEED_MAX is below minimum speed"
#elif (STEPPER_MOTOR_0_SPEED_MAX > STEPPER_MOTOR_SPEED_MAX)
  #error "STEPPER_MOTOR_0_SPEED_MAX exceeds the maximum speed"
#endif

#if   (STEPPER_MOTOR_0_ACC == 0)
  #error STEPPER_MOTOR_0_ACC can not be 0
#elif (STEPPER_MOTOR_0_ACC > STEPPER_MOTOR_ACC_MAX)
  #error STEPPER_MOTOR_0_ACC exceeds the maximum acceleration
#endif

#if   (STEPPER_MOTOR_1_SPEED_MAX < STEPPER_MOTOR_SPEED_MIN)
  #error STEPPER_MOTOR_1_SPEED_MAX is below minimum speed
#elif (STEPPER_MOTOR_1_SPEED_MAX > STEPPER_MOTOR_SPEED_MAX)
  #error STEPPER_MOTOR_1_SPEED_MAX exceeds the maximum speed
#endif

#if   (STEPPER_MOTOR_1_ACC == 0)
  #error STEPPER_MOTOR_1_ACC can not be 0
#elif (STEPPER_MOTOR_1_ACC > STEPPER_MOTOR_ACC_MAX)
  #error STEPPER_MOTOR_1_ACC exceeds the maximum acceleration
#endif

#if   (STEPPER_MOTOR_2_SPEED_MAX < STEPPER_MOTOR_SPEED_MIN)
  #error STEPPER_MOTOR_2_SPEED_MAX is below minimum speed
#elif (STEPPER_MOTOR_2_SPEED_MAX > STEPPER_MOTOR_SPEED_MAX)
  #error STEPPER_MOTOR_2_SPEED_MAX exceeds the maximum speed
#endif

#if   (STEPPER_MOTOR_2_ACC == 0)
  #error STEPPER_MOTOR_2_ACC can not be 0
#elif (STEPPER_MOTOR_2_ACC > STEPPER_MOTOR_ACC_MAX)
  #error STEPPER_MOTOR_2_ACC exceeds the maximum acceleration
#endif

#if   (STEPPER_MOTOR_3_SPEED_MAX < STEPPER_MOTOR_SPEED_MIN)
  #error STEPPER_MOTOR_3_SPEED_MAX is below minimum speed
#elif (STEPPER_MOTOR_3_SPEED_MAX > STEPPER_MOTOR_SPEED_MAX)
  #error STEPPER_MOTOR_3_SPEED_MAX exceeds the maximum speed
#endif

#if   (STEPPER_MOTOR_3_ACC == 0)
  #error STEPPER_MOTOR_3_ACC can not be 0
#elif (STEPPER_MOTOR_3_ACC > STEPPER_MOTOR_ACC_MAX)
  #error STEPPER_MOTOR_3_ACC exceeds the maximum acceleration
#endif

/******************************************************************************
λ()ʱ,ɸλ()Ƕ
******************************************************************************/
#define   STEPPER_MOTOR_RST_FINE_DEG        6
#define   STEPPER_MOTOR_RST_FULL_DEG        320

/******************************************************************************
״̬
******************************************************************************/
#define   STEPPER_MOTOR_STOP                0x00
#define   STEPPER_MOTOR_RST                 0x01
#define   STEPPER_MOTOR_READY               0x02
#define   STEPPER_MOTOR_BACK                0x03

/******************************************************************************

******************************************************************************/
#define   STEPPER_MOTOR_NO_REQ              0x00
#define   STEPPER_MOTOR_PWR_UP_REQ          0x01
#define   STEPPER_MOTOR_SHDN_REQ            0x02

/******************************************************************************
ģʽ
******************************************************************************/
#define   STEPPER_MOTOR_MODE_NORMAL         0     //ģʽ
#define   STEPPER_MOTOR_MODE_BRAKE          1     //ƶģʽ

/******************************************************************************
תƽṹ
******************************************************************************/
typedef struct
{
  uint8_t   Accomp;           //һ΢ʶ
  uint8_t   Phase;            //תλ
  uint8_t   ZeroSw;           //㿪״̬
  uint16_t  Timer;            //ʱ,ڼ¼ÿһ΢ʱ
  uint16_t  Interval;         //ÿһ΢䶨ʱ,ڵתٶ
  uint16_t  DstStep;          //Ŀ΢
  uint16_t  CurStep;          //ǰ΢
  uint16_t  CurStepBackup;    //ǰ΢ֵ
  uint16_t  Speed;            //תٶ
  uint16_t  SpeedMax;         //תٶ
  uint16_t  Acc;              //תٶ
}MotorCtrlStruct;

/******************************************************************************
ȫֿƽṹ
******************************************************************************/
typedef struct
{
  uint8_t   Status;
  uint8_t   Flag;
  uint8_t   PwrReq;
  uint8_t   CalMode;
  uint8_t   RstMode;
  uint16_t  Delay;
}
MotorGlobalControlStruct;

/******************************************************************************

******************************************************************************/
void Stepper_Motor_Start_Up(void);
void Stepper_Motor_Shutdown(void);
uint8_t Stepper_Motor_Get_Status(void);
uint8_t Stepper_Motor_Calibration_Mode(uint8_t En);

static uint16_t Stepper_Motor_Speed_Control(MotorCtrlStruct *pMotor, uint16_t DstStep);
static void Stepper_Motor_Fine_Reset_Init(void);
static void Stepper_Motor_Running_Init(void);
static void Stepper_Motor_Rolling_Back_Init(void);

void Stepper_Motor_Reset(void);

void Stepper_Motor_Speed_Control_Service(void);
void Stepper_Motor_Rotating_ISR(void);

#endif
