
#ifndef _TELLTALES_H_
#define _TELLTALES_H_

#include "GUI.h"
#include "CAN_Communication_Matrix.h"
#include "Line_In.h"
#include "LED.h"
#include "Flash_synchronizer.h"
#include "System_Status_Monitor.h"
#include "Non_volatile_Memorys.h"
#include "IO_Manager.h"
#include "Warning_Processor.h"
#include "Sound_List.h"
#include "Sound_Scheduler.h"
#include "Sound_Player.h"
#include "main.h"

typedef struct
{
  uint8_t   LastLeft;
  uint8_t   LastRight;
  uint8_t   Delay;
} TelltaleLRCtrlStruct;

typedef struct
{
  uint8_t   Enable;
  uint8_t   Filter;
  uint8_t   Timer;
  uint8_t   Output;
} TelltaleLRSimulateStruct;
 
extern    INT32U   BD83790A;
extern    INT32U   BD83790B;
extern    INT32U   BD83790C;
extern    INT32U   OldBD83790A;
extern    INT32U   OldBD83790B;
extern    INT32U   OldBD83790C;

extern    uint8_t  SEATBELT_Count;
extern    uint8_t  Break_nodown_Count;
extern    uint8_t  BREAK_FLUID_Count;
extern    uint8_t  BREAK_Count;
extern    uint8_t  Break_down_count;
extern    uint8_t  RR_HOOVES_Count;
extern    uint8_t  RF_HOOVES_Count;
extern    uint8_t  DoorSts_Count;
extern    uint8_t  OVER_SPEED_Count;
extern    uint8_t  CAB_LOCK_Count ;
extern    uint8_t  CollantAir_Count;
extern    uint8_t  Drivability_Count;
extern    uint8_t  PTO_Count;
extern    uint8_t  BreakLight_Count;
extern    uint8_t  FILT_BLOCK_Count;
extern    uint8_t  CHARGE_Count;
extern    uint8_t  EngineSeriousFailure_Count;
extern    uint8_t  Coolant_Temp_Count;
extern    uint8_t  EngOilPress_Count;
extern    uint8_t  DPF_Lamp_Count;
extern    uint8_t  Led_DPF_Count;
extern    uint8_t  DPF_Forbidden_Count;
extern    uint8_t  Stop_Start_System_Count;
extern    uint8_t  EPB_Count ;
extern    uint8_t  AEB_Count ;
extern    uint8_t  AMT_Count;
extern    uint8_t  LowBrakeLuidLevel_temp;
extern    uint8_t  LowBrakeLuidLevel_timp;
extern    uint8_t  SafetyBeltSt_temp;
extern    uint8_t  MaintainSignal_temp;
extern    uint8_t  ParkingBrakeSwitch_temp;
extern    uint8_t  CabLockSt_temp;
extern    uint8_t  PositionLightSts;
extern    uint8_t  DriveDoorSts;
extern    uint8_t  PsngrDoorSts;
extern    uint8_t  LED_T_BOX_RVM;
extern    uint8_t  TelltaleLCD_Flag33;

//Ļָʾ״̬ʶ
typedef union
{
	uint32_t Telltale;
	struct
	{		
    uint8_t    LCD01      	:  1;       //  1
    uint8_t    LCD02      	:  1;       //  2
    uint8_t    LCD03      	:  1;       //  3
    uint8_t    LCD04      	:  1;       //  4
    uint8_t    LCD05      	:  1;       //  5
    uint8_t    LCD06      	:  1;       //  6
    uint8_t    LCD07      	:  1;       //  7
    uint8_t    LCD08      	:  1;       //  8
    uint8_t    LCD09      	:  1;       //  9
    uint8_t    LCD10      	:  1;       // 10
    uint8_t    LCD11      	:  1;       // 11
    uint8_t    LCD12      	:  1;       // 12
    uint8_t    LCD13      	:  1;       // 13
    uint8_t    LCD14      	:  1;       // 14
    uint8_t    LCD15      	:  1;       // 15
    uint8_t    LCD16      	:  1;       // 16
    uint8_t    LCD17      	:  1;       // 17
    uint8_t    LCD18      	:  1;       // 18
    uint8_t    LCD19      	:  1;       // 19
    uint8_t    LCD20      	:  1;       // 20
    uint8_t    LCD21      	:  1;       // 21
    uint8_t    LCD22      	:  1;       // 22
    uint8_t    LCD23      	:  1;       // 23
    uint8_t    LCD24      	:  1;       // 24
    uint8_t    LCD25      	:  1;       // 25
    uint8_t    LCD26      	:  1;       // 26
    uint8_t    LCD27      	:  1;       // 27
    uint8_t    LCD28      	:  1;       // 28
    uint8_t    LCD29      	:  1;       // 29
    uint8_t    LCD30      	:  1;       // 30
    uint8_t    LCD31       	:  1;       // 31
    uint8_t    LCD32      	:  1;       // 32   
	} Sig; 
} TelltaleLCD;

extern TelltaleLCD TelltaleLCDFlag;
/******************************************************************************
ָʾ˸ͬ
******************************************************************************/

#define   LED_FLASH_1Hz         FLASH_SYNC_1Hz ? LED_ON  : LED_OFF

#define   LED_FLASH_2Hz         FLASH_SYNC_2Hz ? LED_ON  : LED_OFF

#define   LED_FLASH_7Hz         FLASH_SYNC_7Hz ? LED_ON  : LED_OFF

/******************************************************************************

******************************************************************************/
void Telltales_Management(void);        //50ms
void Telltales_Left_Right_Management_Service(void);
#endif