
#ifndef _C035QAN01_H_
#define _C035QAN01_H_

#include "stdint.h"
#include "API.h"
#include "GPIO.h"
#include "Simulated_SPI_Master.h"

/**********************************************************************************
ʾ
**********************************************************************************/
#define   LCD_VERTICAL_DOWN_TO_UP           0           //ֱˢ 0
                                                        //             1
#define   LCD_HORIZONTAL_RIGHT_TO_LEFT      0           //ˮƽˢ 0
                                                        //             1
#define   LCD_USE_SYNC_MODE                 1           //ģʽ     0DEģʽ
                                                        //             1SYNCģʽ
                                                        
/**********************************************************************************
ĴԤ
**********************************************************************************/
#if       LCD_VERTICAL_DOWN_TO_UP
  #define LCD_REG_VDIR                      ((uint16_t)0x0080)
#else
  #define LCD_REG_VDIR                      ((uint16_t)0x0000)
#endif

#if       LCD_HORIZONTAL_RIGHT_TO_LEFT
  #define LCD_REG_HDIR                      ((uint16_t)0x0080)
#else
  #define LCD_REG_HDIR                      ((uint16_t)0x0000)
#endif

#if       LCD_USE_SYNC_MODE
  #define LCD_REG_SYNC_DE                   ((uint16_t)0x0020)
#else
  #define LCD_REG_SYNC_DE                   ((uint16_t)0x0000)
#endif
                                             
/**********************************************************************************
ʼݱ
**********************************************************************************/
/*** Gamma Setting ***/
static const uint16_t LCDGammaSetting[] = 
{ 
  0x1800, 0x190F, 0x1A1A, 0x1B1F, 0x1C27, 0x1D0E, 0x1E0D, 0x1F10, 0x200C, 0x2106,
  0x220B, 0x230A, 0x2404, 0x250B, 0x260C, 0x270E, 0x280E, 0x291E, 0x2A14, 0x2B10,
  0x2C0B, 0x2D04, 0x2E04, 0x2F0B, 0x3010, 0x3114, 0x321E, 0x330E, 0x340E, 0x350C,
  0x360B, 0x3704, 0x380A, 0x390B, 0x3A06, 0x3B0C, 0x3C10, 0x3D0D, 0x3E0E, 0x3F27,
  0x801F, 0x811C, 0x8213, 0x8309, 
};

/*** Fine Tune Charge Pump Setting ***/
static const uint16_t LCDChargePumpSetting[] =
{
  0xBF02, 0x0608, 0x0764, 0xBF00, 0xB1C0,
};

/**********************************************************************************

**********************************************************************************/ 
void LCD_Init(void);
void LCD_Wait_ms(uint8_t msCnt);

#endif
