/******************************************************************************
  BU98R10.c
BU98R10Һļ
    ߣ
    V1.0
    ڣ2017.4.28
******************************************************************************/

#include "BU98R10.h"

#if   USE_BU98R10_CHIP_0
volatile BU98R10DDRAMUnion        BU98R10Chip0DDRAM;
BU98R10DDRAMUnion                 BU98R10Chip0DDRAMBackup;
#endif

#if   USE_BU98R10_CHIP_1
volatile BU98R10DDRAMUnion        BU98R10Chip1DDRAM;
BU98R10DDRAMUnion                 BU98R10Chip1DDRAMBackup;
#endif

BU98R10UpdateCtrlStruct           BU98R10Update;

/******************************************************************************
BU98R10_Init
  ܣʼBU98R10
  
ֵ
******************************************************************************/
void BU98R10_Init(void)
{
  uint8_t i;
  
  #if     BU98R10_WRITE_AT_SAME_TIME
    #if   BU98R10_COLORFUL_LCD_MODE
    
      //λ
      BU98R10_All_Command_Write(BU98R10_CMD_SWRST);
      
      //ģʽ
      BU98R10_All_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);
      
      //
      BU98R10_All_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);
      
      //֡ˢ
      BU98R10_All_Command_Write(BU98R10_CMD_FREQ);
      BU98R10_All_Data_Write(BU98R10_FRAME_FREQ, BU98R10_FRAME_FREQ); 
    
      //ɫ
      BU98R10_All_Command_Write(BU98R10_CMD_LED_CTRL);
      BU98R10_All_Data_Write(0x12, 0x12); 
    
      BU98R10_All_Command_Write(BU98R10_CMD_SEG_R);
      BU98R10_All_Data_Write(BU98R10_REG_SEG_R, BU98R10_REG_SEG_R); 
    
      BU98R10_All_Command_Write(BU98R10_CMD_SEG_G);
      BU98R10_All_Data_Write(BU98R10_REG_SEG_G, BU98R10_REG_SEG_G);   
    
      BU98R10_All_Command_Write(BU98R10_CMD_SEG_B);
      BU98R10_All_Data_Write(BU98R10_REG_SEG_B, BU98R10_REG_SEG_B);   
    
      BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTR);
      BU98R10_All_Data_Write(BU98R10_LRS, BU98R10_LRS);   
    
      BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTG);
      BU98R10_All_Data_Write(BU98R10_LGS, BU98R10_LGS);  
      
      BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTB);
      BU98R10_All_Data_Write(BU98R10_LBS, BU98R10_LBS);  
      
      BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHR);
      BU98R10_All_Data_Write(BU98R10_LRW, BU98R10_LRW);
      
      BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHG);
      BU98R10_All_Data_Write(BU98R10_LGW, BU98R10_LGW);
      
      BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHB);
      BU98R10_All_Data_Write(BU98R10_LBW, BU98R10_LBW);

      //RAM    
      BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
      BU98R10_All_Data_Write(0x00, 0x00);
      
      BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
      for (i = 0; i < 90; i++)
        BU98R10_All_Data_Write(BU98R10_DEFAULT_BYTE, BU98R10_DEFAULT_BYTE);
      
      for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
      {
        BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
        
        BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
      }
      
      //ʾ
      BU98R10_All_Command_Write(BU98R10_CMD_DISPON);
      
    #else
      
      //λ
      BU98R10_All_Command_Write(BU98R10_CMD_SWRST);
      
      //ģʽ
      BU98R10_All_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);
      
      //
      BU98R10_All_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);
      
      //֡ˢ
      BU98R10_All_Command_Write(BU98R10_CMD_FREQ);
      BU98R10_All_Data_Write(BU98R10_FRAME_FREQ, BU98R10_FRAME_FREQ); 
      
      //RAM    
      BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
      BU98R10_All_Data_Write(0x00, 0x00);
      
      BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
      for (i = 0; i < 90; i++)
        BU98R10_All_Data_Write(BU98R10_DEFAULT_BYTE, BU98R10_DEFAULT_BYTE);
      
      for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
      {
        BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
        
        BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
      }
      
      //ʾ
      BU98R10_All_Command_Write(BU98R10_CMD_DISPON);
      
    #endif
  #else
    #if BU98R10_COLORFUL_LCD_MODE
      #if USE_BU98R10_CHIP_0
      
        //λ
        BU98R10_0_Command_Write(BU98R10_CMD_SWRST);
        
        //ģʽ
        BU98R10_0_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);
        
        //
        BU98R10_0_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);
        
        //֡ˢ
        BU98R10_0_Command_Write(BU98R10_CMD_FREQ);
        BU98R10_0_Data_Write(BU98R10_FRAME_FREQ); 
      
        //ɫ
        BU98R10_0_Command_Write(BU98R10_CMD_LED_CTRL);
        BU98R10_0_Data_Write(0x12); 
      
        BU98R10_0_Command_Write(BU98R10_CMD_SEG_R);
        BU98R10_0_Data_Write(BU98R10_REG_SEG_R); 
      
        BU98R10_0_Command_Write(BU98R10_CMD_SEG_G);
        BU98R10_0_Data_Write(BU98R10_REG_SEG_G);   
      
        BU98R10_0_Command_Write(BU98R10_CMD_SEG_B);
        BU98R10_0_Data_Write(BU98R10_REG_SEG_B);   
      
        BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTR);
        BU98R10_0_Data_Write(BU98R10_LRS);   
      
        BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTG);
        BU98R10_0_Data_Write(BU98R10_LGS);  
        
        BU98R10_0_Command_Write(BU98R10_CMD_LED_STARTB);
        BU98R10_0_Data_Write(BU98R10_LBS);  
        
        BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHR);
        BU98R10_0_Data_Write(BU98R10_LRW);
        
        BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHG);
        BU98R10_0_Data_Write(BU98R10_LGW);
        
        BU98R10_0_Command_Write(BU98R10_CMD_LED_WIDTHB);
        BU98R10_0_Data_Write(BU98R10_LBW);

        //RAM    
        BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
        BU98R10_0_Data_Write(0x00);
        
        BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
        for (i = 0; i < 90; i++)
          BU98R10_0_Data_Write(BU98R10_DEFAULT_BYTE);
        
        for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
        {
          BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
          BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
        }
        
        //ʾ
        BU98R10_0_Command_Write(BU98R10_CMD_DISPON);
        
      #endif
      #if USE_BU98R10_CHIP_1
      
        //λ
        BU98R10_1_Command_Write(BU98R10_CMD_SWRST);
        
        //ģʽ
        BU98R10_1_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);
        
        //
        BU98R10_1_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);
        
        //֡ˢ
        BU98R10_1_Command_Write(BU98R10_CMD_FREQ);
        BU98R10_1_Data_Write(BU98R10_FRAME_FREQ); 
      
        //ɫ
        BU98R10_1_Command_Write(BU98R10_CMD_LED_CTRL);
        BU98R10_1_Data_Write(0x12); 
      
        BU98R10_1_Command_Write(BU98R10_CMD_SEG_R);
        BU98R10_1_Data_Write(BU98R10_REG_SEG_R); 
      
        BU98R10_1_Command_Write(BU98R10_CMD_SEG_G);
        BU98R10_1_Data_Write(BU98R10_REG_SEG_G);   
      
        BU98R10_1_Command_Write(BU98R10_CMD_SEG_B);
        BU98R10_1_Data_Write(BU98R10_REG_SEG_B);   
      
        BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTR);
        BU98R10_1_Data_Write(BU98R10_LRS);   
      
        BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTG);
        BU98R10_1_Data_Write(BU98R10_LGS);  
        
        BU98R10_1_Command_Write(BU98R10_CMD_LED_STARTB);
        BU98R10_1_Data_Write(BU98R10_LBS);  
        
        BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHR);
        BU98R10_1_Data_Write(BU98R10_LRW);
        
        BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHG);
        BU98R10_1_Data_Write(BU98R10_LGW);
        
        BU98R10_1_Command_Write(BU98R10_CMD_LED_WIDTHB);
        BU98R10_1_Data_Write(BU98R10_LBW);

        //RAM    
        BU98R10_1_Command_Write(BU98R10_CMD_ADSET);
        BU98R10_1_Data_Write(0x00);
        
        BU98R10_1_Command_Write(BU98R10_CMD_DATWR);
        for (i = 0; i < 90; i++)
          BU98R10_1_Data_Write(BU98R10_DEFAULT_BYTE);
        
        for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
        {
          BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
          BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
        }
        
        //ʾ
        BU98R10_1_Command_Write(BU98R10_CMD_DISPON);
        
      #endif
    #else
      #if USE_BU98R10_CHIP_0
      
        //λ
        BU98R10_0_Command_Write(BU98R10_CMD_SWRST);
        
        //ģʽ
        BU98R10_0_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);
        
        //
        BU98R10_0_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);
        
        //֡ˢ
        BU98R10_0_Command_Write(BU98R10_CMD_FREQ);
        BU98R10_0_Data_Write(BU98R10_FRAME_FREQ);
        
        //RAM    
        BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
        BU98R10_0_Data_Write(0x00);
        
        BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
        for (i = 0; i < 90; i++)
          BU98R10_0_Data_Write(BU98R10_DEFAULT_BYTE);
        
        for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
        {
          BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
          BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
        }
        
        //ʾ
        BU98R10_0_Command_Write(BU98R10_CMD_DISPON);
        
      #endif      
      #if USE_BU98R10_CHIP_1
      
        //λ
        BU98R10_1_Command_Write(BU98R10_CMD_SWRST);
        
        //ģʽ
        BU98R10_1_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_MONO);
        
        //
        BU98R10_1_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);
        
        //֡ˢ
        BU98R10_1_Command_Write(BU98R10_CMD_FREQ);
        BU98R10_1_Data_Write(BU98R10_FRAME_FREQ);
        
        //RAM    
        BU98R10_1_Command_Write(BU98R10_CMD_ADSET);
        BU98R10_1_Data_Write(0x00);
        
        BU98R10_1_Command_Write(BU98R10_CMD_DATWR);
        for (i = 0; i < 90; i++)
          BU98R10_1_Data_Write(BU98R10_DEFAULT_BYTE);

        for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
        {
          BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
          BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
        }
        
        //ʾ
        BU98R10_1_Command_Write(BU98R10_CMD_DISPON);
        
      #endif 
    #endif
  #endif
  
  BU98R10Update.En   = 0;
  BU98R10Update.Step = 0;
  BU98R10Update.Cont = 0;
  BU98R10Update.Addr = 0;
  
  #if    USE_BU98R10_CHIP_0
    BU98R10Update.Chip = 0;
  #elif  USE_BU98R10_CHIP_1
    BU98R10Update.Chip = 1;
  #else
    BU98R10Update.Chip = 255;
  #endif
}

/******************************************************************************
BU98R10_Shutdown
  ܣرBU98R10ʾ,ʹ͹ģʽ
  
ֵ
******************************************************************************/
void BU98R10_Shutdown(void)
{
  #if     BU98R10_WRITE_AT_SAME_TIME
    BU98R10_All_Command_Write(BU98R10_CMD_DISPOFF);
  #else
    #if USE_BU98R10_CHIP_0
      BU98R10_0_Command_Write(BU98R10_CMD_DISPOFF);
    #endif
    
    #if USE_BU98R10_CHIP_1
      BU98R10_1_Command_Write(BU98R10_CMD_DISPOFF);
    #endif
  #endif
}

/******************************************************************************
BU98R10_Update_Request
  ܣˢBU98R10Ķʾ
  
ֵ
******************************************************************************/
void BU98R10_Update_Request(void)
{
  BU98R10Update.En = 1;
  
  #if    USE_BU98R10_CHIP_0
    BU98R10Update.Chip = 0;
  #elif  USE_BU98R10_CHIP_1
    BU98R10Update.Chip = 1;
  #else
    BU98R10Update.Chip = 255;
  #endif  
}

/******************************************************************************
BU98R10_Update_Service
  ܣBU98R10ʾˢ·
  
ֵ
*******************************************************************************
ע  ⣺÷ÿϵͳʱʵʱ
******************************************************************************/
void BU98R10_Update_Service(void)
{
  if (BU98R10Update.En)
  {
    #if BU98R10_WRITE_AT_SAME_TIME
    
    switch (BU98R10Update.Step)
    {
      case 0  : //DDRAMеǰֽǷҪ
                if ((BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr]) || \
                    (BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]))
                {
                  BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr];
                  BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr];
                  
                  if (BU98R10Update.Cont)
                    BU98R10Update.Step = 4;
                  else
                    BU98R10Update.Step = 1;
                }
                else
                {
                  BU98R10Update.Cont = 0;
                  BU98R10Update.Addr++;
                  if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
                  {
                    BU98R10Update.Addr = 0;
                    BU98R10Update.En   = 0;
                  }
                }
                break;
                
      case 1  : //дַ
                BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
                BU98R10Update.Step = 2;
                break;
                
      case 2  : //дַ
                #if BU98R10_COLORFUL_LCD_MODE
                  BU98R10_All_Data_Write(BU98R10Update.Addr, BU98R10Update.Addr);
                #else
                  BU98R10_All_Data_Write(BU98R10Update.Addr * 4, BU98R10Update.Addr * 4);
                #endif
                BU98R10Update.Step = 3;
                break;
      
      case 3  : //д
                BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
                BU98R10Update.Step = 4;
                break;
                
      case 4  : //д
                BU98R10_All_Data_Write(BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr], BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]);
                BU98R10Update.Step = 5;
                break;
                
      case 5  : //ַ
                BU98R10Update.Addr++;
                if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
                {
                  BU98R10Update.Addr = 0;
                  BU98R10Update.En   = 0;
                  BU98R10Update.Cont = 0;
                }
                else                
                  BU98R10Update.Cont = 1;
                
                BU98R10Update.Step = 0;
                break;
                
      default : BU98R10Update.En   = 0;
                BU98R10Update.Step = 0;
                BU98R10Update.Cont = 0;
                BU98R10Update.Addr = 0;
                break;
    }

    #else
      
    #if  USE_BU98R10_CHIP_0
      
    if (BU98R10Update.Chip == 0)
    {
      switch (BU98R10Update.Step)
      {
        case 0  : //DDRAMеǰֽǷҪ
                  if (BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr])
                  {
                    BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr];
                    
                    if (BU98R10Update.Cont)
                      BU98R10Update.Step = 4;
                    else
                      BU98R10Update.Step = 1;
                  }
                  else
                  {
                    BU98R10Update.Cont = 0;
                    BU98R10Update.Addr++;
                    if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
                    {
                      BU98R10Update.Addr = 0;
                      
                      #if  USE_BU98R10_CHIP_1
                        BU98R10Update.Chip = 1;
                      #else
                        BU98R10Update.En   = 0;
                      #endif
                    }
                  }
                  break;
                  
        case 1  : //дַ
                  BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
                  BU98R10Update.Step = 2;
                  break;
                  
        case 2  : //дַ
                  #if BU98R10_COLORFUL_LCD_MODE
                    BU98R10_0_Data_Write(BU98R10Update.Addr);
                  #else
                    BU98R10_0_Data_Write(BU98R10Update.Addr * 4);
                  #endif
                  BU98R10Update.Step = 3;
                  break;
        
        case 3  : //д
                  BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
                  BU98R10Update.Step = 4;
                  break;
                  
        case 4  : //д
                  BU98R10_0_Data_Write(BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr]);
                  BU98R10Update.Step = 5;
                  break;
                  
        case 5  : //ַ
                  BU98R10Update.Addr++;
                  if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
                  {
                    BU98R10Update.Addr = 0;                    
                    BU98R10Update.Cont = 0;

                    #if  USE_BU98R10_CHIP_1
                      BU98R10Update.Chip = 1;
                    #else
                      BU98R10Update.En   = 0;
                    #endif
                  }
                  else                
                    BU98R10Update.Cont = 1;
                  
                  BU98R10Update.Step = 0;
                  break;
                  
        default : BU98R10Update.En   = 0;
                  BU98R10Update.Step = 0;
                  BU98R10Update.Cont = 0;
                  BU98R10Update.Addr = 0;
                  break;
      }
    }
    
    #if   USE_BU98R10_CHIP_1
    else if (BU98R10Update.Chip == 1)
    #endif
  
    #elif USE_BU98R10_CHIP_1
    if (BU98R10Update.Chip == 1)
    #endif
  
    #if   USE_BU98R10_CHIP_1
    {
      switch (BU98R10Update.Step)
      {
        case 0  : //DDRAMеǰֽǷҪ
                  if (BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr])
                  {
                    BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr];
                    
                    if (BU98R10Update.Cont)
                      BU98R10Update.Step = 4;
                    else
                      BU98R10Update.Step = 1;
                  }
                  else
                  {
                    BU98R10Update.Cont = 0;
                    BU98R10Update.Addr++;
                    if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
                    {
                      BU98R10Update.Addr = 0;
                      BU98R10Update.En   = 0;
                    }
                  }
                  break;
                  
        case 1  : //дַ
                  BU98R10_0_Command_Write(BU98R10_CMD_ADSET);
                  BU98R10Update.Step = 2;
                  break;
                  
        case 2  : //дַ
                  #if BU98R10_COLORFUL_LCD_MODE
                    BU98R10_0_Data_Write(BU98R10Update.Addr);
                  #else
                    BU98R10_0_Data_Write(BU98R10Update.Addr * 4);
                  #endif
                  BU98R10Update.Step = 3;
                  break;
        
        case 3  : //д
                  BU98R10_0_Command_Write(BU98R10_CMD_DATWR);
                  BU98R10Update.Step = 4;
                  break;
                  
        case 4  : //д
                  BU98R10_0_Data_Write(BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]);
                  BU98R10Update.Step = 5;
                  break;
                  
        case 5  : //ַ
                  BU98R10Update.Addr++;
                  if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
                  {
                    BU98R10Update.Addr = 0;                    
                    BU98R10Update.Cont = 0;
                    BU98R10Update.En   = 0;
                  }
                  else                
                    BU98R10Update.Cont = 1;
                  
                  BU98R10Update.Step = 0;
                  break;
                  
        default : BU98R10Update.En   = 0;
                  BU98R10Update.Step = 0;
                  BU98R10Update.Cont = 0;
                  BU98R10Update.Addr = 0;
                  break;
      }
    }
    #endif
    
    #if ((USE_BU98R10_CHIP_0) || (USE_BU98R10_CHIP_1))
    else
    #endif
      BU98R10Update.En = 0;

  #endif
  }  
}

#if   USE_BU98R10_CHIP_0
/******************************************************************************
BU98R10_0_Command_Write
  ܣBU98R10оƬ0д
  CmdҪд
ֵ
******************************************************************************/
void BU98R10_0_Command_Write(uint8_t Cmd)
{
  uint8_t i;

  //D/C = 0,ʾ
  BU98R10_0_SD  = 0;
  BU98R10_0_SCL = 0;
  BU98R10_0_CSB = 0;
  
  nop();
  nop();
  nop();
  
  BU98R10_0_SCL = 1;
  
  for (i = 0; i < 8; i++)
  {
    BU98R10_0_SCL = 0;
    
    if (Cmd & 0x80)
      BU98R10_0_SD = 1;
    else
      BU98R10_0_SD = 0;
      
    nop();
    nop();
    nop();
    
    BU98R10_0_SCL = 1;
    
    Cmd <<= 1;
  }
  
  BU98R10_0_CSB = 1;
}

/******************************************************************************
BU98R10_0_Data_Write
  ܣBU98R10оƬ0д
  DatҪд
ֵ
******************************************************************************/
void BU98R10_0_Data_Write(uint8_t Dat)
{
  uint8_t i;

  //D/C = 1,ʾ
  BU98R10_0_SD  = 1;
  BU98R10_0_SCL = 0;
  BU98R10_0_CSB = 0;
  
  nop();
  nop();
  nop();
  
  BU98R10_0_SCL = 1;
  
  for (i = 0; i < 8; i++)
  {
    BU98R10_0_SCL = 0;
    
    if (Dat & 0x80)
      BU98R10_0_SD = 1;
    else
      BU98R10_0_SD = 0;
      
    nop();
    nop();
    nop();
    
    BU98R10_0_SCL = 1;
    
    Dat <<= 1;
  }
  
  BU98R10_0_CSB = 1;
}
#endif

#if   USE_BU98R10_CHIP_1
/******************************************************************************
BU98R10_1_Command_Write
  ܣBU98R10оƬ1д
  CmdҪд
ֵ
******************************************************************************/
void BU98R10_1_Command_Write(uint8_t Cmd)
{
  uint8_t i;

  //D/C = 0,ʾ
  BU98R10_1_SD  = 0;
  BU98R10_1_SCL = 0;
  BU98R10_1_CSB = 0;
  
  nop();
  nop();
  nop();
  
  BU98R10_1_SCL = 1;
  
  for (i = 0; i < 8; i++)
  {
    BU98R10_1_SCL = 0;
    
    if (Cmd & 0x80)
      BU98R10_1_SD = 1;
    else
      BU98R10_1_SD = 0;
      
    nop();
    nop();
    nop();
    
    BU98R10_1_SCL = 1;
    
    Cmd <<= 1;
  }
  
  BU98R10_1_CSB = 1;
}

/******************************************************************************
BU98R10_1_Data_Write
  ܣBU98R10оƬ1д
  DatҪд
ֵ
******************************************************************************/
void BU98R10_1_Data_Write(uint8_t Dat)
{
  uint8_t i;

  //D/C = 1,ʾ
  BU98R10_1_SD  = 1;
  BU98R10_1_SCL = 0;
  BU98R10_1_CSB = 0;
  
  nop();
  nop();
  nop();
  
  BU98R10_1_SCL = 1;
  
  for (i = 0; i < 8; i++)
  {
    BU98R10_1_SCL = 0;
    
    if (Dat & 0x80)
      BU98R10_1_SD = 1;
    else
      BU98R10_1_SD = 0;
      
    nop();
    nop();
    nop();
    
    BU98R10_1_SCL = 1;
    
    Dat <<= 1;
  }
  
  BU98R10_1_CSB = 1;
}

#endif

#if   BU98R10_WRITE_AT_SAME_TIME
/******************************************************************************
BU98R10_All_Command_Write
  ܣͬʱBU98R10оƬ0оƬ1д
  CmdҪд
ֵ
******************************************************************************/
void BU98R10_All_Command_Write(uint8_t Cmd)
{
  uint8_t i;

  //D/C = 0,ʾ
  BU98R10_0_SD  = 0;
  BU98R10_1_SD  = 0;
  
  BU98R10_0_SCL = 0;
  BU98R10_1_SCL = 0;
  
  BU98R10_0_CSB = 0;
  BU98R10_1_CSB = 0;
  
  nop();
  
  BU98R10_0_SCL = 1;
  BU98R10_1_SCL = 1;
  
  for (i = 0; i < 8; i++)
  {
    BU98R10_0_SCL = 0;
    BU98R10_1_SCL = 0;
    
    if (Cmd & 0x80)
    {
      BU98R10_0_SD = 1;
      BU98R10_1_SD = 1;
    }
    else
    {
      BU98R10_0_SD = 0;
      BU98R10_1_SD = 0;
    }
      
    nop();
    
    BU98R10_0_SCL = 1;
    BU98R10_1_SCL = 1;
    
    Cmd <<= 1;
  }
  
  BU98R10_0_CSB = 1;
  BU98R10_1_CSB = 1;
}

/******************************************************************************
BU98R10_All_Data_Write
  ܣͬʱBU98R10оƬ0оƬ1д
  Dat0ҪдBU98R10оƬ0
        Dat1ҪдBU98R10оƬ1
ֵ
******************************************************************************/
void BU98R10_All_Data_Write(uint8_t Dat0, uint8_t Dat1)
{
  uint8_t i;

  //D/C = 1,ʾ
  BU98R10_0_SD  = 1;
  BU98R10_1_SD  = 1;
  
  BU98R10_0_SCL = 0;
  BU98R10_1_SCL = 0;
  
  BU98R10_0_CSB = 0;
  BU98R10_1_CSB = 0;
  
  nop();
  
  BU98R10_0_SCL = 1;
  BU98R10_1_SCL = 1;
  
  for (i = 0; i < 8; i++)
  {
    BU98R10_0_SCL = 0;
    BU98R10_1_SCL = 0;
    
    if (Dat0 & 0x80)
      BU98R10_0_SD = 1;
    else
      BU98R10_0_SD = 0;
    
    if (Dat1 & 0x80)
      BU98R10_1_SD = 1;
    else
      BU98R10_1_SD = 0;
      
    nop();
    
    BU98R10_0_SCL = 1;
    BU98R10_1_SCL = 1;
    
    Dat0 <<= 1;
    Dat1 <<= 1;
  }
  
  BU98R10_0_CSB = 1;
  BU98R10_1_CSB = 1;
}
#endif
