/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import java.io.ByteArrayOutputStream;

public class MagnitudeDependentWriter {
    private final ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private byte byteBuf = 0;
    private int bitCount = 0;

    private void writeBit(int bit) {
        this.byteBuf = (byte)(this.byteBuf | bit << this.bitCount);
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.buf.write(this.byteBuf);
            this.byteBuf = 0;
            this.bitCount = 0;
        }
    }

    public void writeValue(int value) {
        if (value == 0) {
            this.writeBit(0);
        } else {
            int absValue = Math.abs(value);
            int i = 0;
            while (i < absValue) {
                this.writeBit(1);
                ++i;
            }
            this.writeBit(0);
            this.writeBit(value > 0 ? 0 : 1);
        }
    }

    public void flush() {
        if (this.bitCount > 0) {
            this.buf.write(this.byteBuf);
            this.byteBuf = 0;
            this.bitCount = 0;
        }
    }

    public byte[] toByteArray() {
        return this.buf.toByteArray();
    }
}

