/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.ByteArray;
import com.google.typography.font.sfntly.data.GrowableMemoryByteArray;
import com.google.typography.font.sfntly.data.MemoryByteArray;
import com.google.typography.font.sfntly.testutils.TestUtils;
import junit.framework.TestCase;

public class ByteArrayTests
extends TestCase {
    private static final int[] BYTE_ARRAY_SIZES = new int[]{1, 7, 127, 128, 129, 255, 256, 257, 666, 1023, 10000, 65535, 65536};

    public ByteArrayTests(String name) {
        super(name);
    }

    public void testMemoryByteArray() throws Exception {
        int[] nArray = BYTE_ARRAY_SIZES;
        int n = BYTE_ARRAY_SIZES.length;
        int n2 = 0;
        while (n2 < n) {
            int size = nArray[n2];
            this.byteArrayTester(ByteArrayTests.fillTestByteArray(new MemoryByteArray(size), size));
            ++n2;
        }
    }

    public void testGrowableMemoryByteArray() throws Exception {
        int[] nArray = BYTE_ARRAY_SIZES;
        int n = BYTE_ARRAY_SIZES.length;
        int n2 = 0;
        while (n2 < n) {
            int size = nArray[n2];
            this.byteArrayTester(ByteArrayTests.fillTestByteArray(new GrowableMemoryByteArray(), 100));
            ++n2;
        }
    }

    private void byteArrayTester(ByteArray<? extends ByteArray<?>> ba) throws Exception {
        this.copyTest(ba);
    }

    private void copyTest(ByteArray<? extends ByteArray<?>> ba) throws Exception {
        MemoryByteArray fixedCopy = new MemoryByteArray(ba.length());
        ba.copyTo(fixedCopy);
        ByteArrayTests.assertEquals(ba.length(), fixedCopy.length());
        this.readComparison(ba, fixedCopy);
        GrowableMemoryByteArray growableCopy = new GrowableMemoryByteArray();
        ba.copyTo(growableCopy);
        ByteArrayTests.assertEquals(ba.length(), growableCopy.length());
        this.readComparison(ba, growableCopy);
    }

    private void readComparison(ByteArray<? extends ByteArray<?>> ba1, ByteArray<? extends ByteArray<?>> ba2) throws Exception {
        int i = 0;
        while (i < ba1.length()) {
            int b = ba1.get(i);
            if (b != ba2.get(i)) {
                int n = 12;
            }
            ByteArrayTests.assertEquals(b, ba2.get(i));
            ++i;
        }
        int increments = Math.max(ba1.length() / 11, 1);
        int bufferSize = 1;
        while (bufferSize < ba1.length()) {
            byte[] buffer = new byte[bufferSize];
            byte[] b1 = ByteArrayTests.readByteArrayWithBuffer(ba1, buffer);
            byte[] b2 = ByteArrayTests.readByteArrayWithBuffer(ba2, buffer);
            ByteArrayTests.assertTrue(TestUtils.equals(b1, 0, b2, 0, ba1.length()));
            bufferSize += increments;
        }
        int windowSize = 1;
        while (windowSize < ba1.length()) {
            byte[] b1 = ByteArrayTests.readByteArrayWithSlidingWindow(ba1, windowSize);
            byte[] b2 = ByteArrayTests.readByteArrayWithSlidingWindow(ba2, windowSize);
            ByteArrayTests.assertTrue(TestUtils.equals(b1, 0, b2, 0, ba1.length()));
            windowSize += increments;
        }
    }

    private static byte[] readByteArrayWithBuffer(ByteArray<? extends ByteArray<?>> ba, byte[] buffer) {
        byte[] b = new byte[ba.length()];
        int index = 0;
        while (index < ba.length()) {
            int bytesRead = ba.get(index, buffer);
            System.arraycopy(buffer, 0, b, index, bytesRead);
            index += bytesRead;
        }
        return b;
    }

    private static byte[] readByteArrayWithSlidingWindow(ByteArray<? extends ByteArray<?>> ba, int windowSize) {
        byte[] b = new byte[ba.length()];
        int index = 0;
        while (index < ba.length()) {
            windowSize = Math.min(windowSize, b.length - index);
            int bytesRead = ba.get(index, b, index, windowSize);
            index += bytesRead;
        }
        return b;
    }

    private static ByteArray<? extends ByteArray<?>> fillTestByteArray(ByteArray<? extends ByteArray<?>> ba, int size) {
        int i = 0;
        while (i < size) {
            ba.put(i, (byte)(i % 256));
            ++i;
        }
        return ba;
    }
}

