/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype.component;

import com.google.typography.font.sfntly.table.opentype.AlternateSubst;
import com.google.typography.font.sfntly.table.opentype.ChainContextSubst;
import com.google.typography.font.sfntly.table.opentype.ClassDefTable;
import com.google.typography.font.sfntly.table.opentype.ContextSubst;
import com.google.typography.font.sfntly.table.opentype.CoverageTable;
import com.google.typography.font.sfntly.table.opentype.ExtensionSubst;
import com.google.typography.font.sfntly.table.opentype.LigatureSubst;
import com.google.typography.font.sfntly.table.opentype.LookupListTable;
import com.google.typography.font.sfntly.table.opentype.LookupTable;
import com.google.typography.font.sfntly.table.opentype.MultipleSubst;
import com.google.typography.font.sfntly.table.opentype.ReverseChainSingleSubst;
import com.google.typography.font.sfntly.table.opentype.SingleSubst;
import com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubClassRule;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubClassSet;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubClassSetArray;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubRule;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubRuleSet;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubRuleSetArray;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.CoverageArray;
import com.google.typography.font.sfntly.table.opentype.chaincontextsubst.InnerArraysFmt3;
import com.google.typography.font.sfntly.table.opentype.classdef.InnerArrayFmt1;
import com.google.typography.font.sfntly.table.opentype.component.GlyphGroup;
import com.google.typography.font.sfntly.table.opentype.component.GlyphList;
import com.google.typography.font.sfntly.table.opentype.component.GsubLookupType;
import com.google.typography.font.sfntly.table.opentype.component.NumRecord;
import com.google.typography.font.sfntly.table.opentype.component.NumRecordList;
import com.google.typography.font.sfntly.table.opentype.component.NumRecordTable;
import com.google.typography.font.sfntly.table.opentype.component.RangeRecord;
import com.google.typography.font.sfntly.table.opentype.component.RangeRecordTable;
import com.google.typography.font.sfntly.table.opentype.component.RecordsTable;
import com.google.typography.font.sfntly.table.opentype.component.Rule;
import com.google.typography.font.sfntly.table.opentype.component.RuleSegment;
import com.google.typography.font.sfntly.table.opentype.component.SubstLookupRecord;
import com.google.typography.font.sfntly.table.opentype.component.SubstLookupRecordList;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubClassRule;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubClassSet;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubClassSetArray;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubRule;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubRuleSet;
import com.google.typography.font.sfntly.table.opentype.contextsubst.SubRuleSetArray;
import com.google.typography.font.sfntly.table.opentype.ligaturesubst.Ligature;
import com.google.typography.font.sfntly.table.opentype.ligaturesubst.LigatureSet;
import com.google.typography.font.sfntly.table.opentype.singlesubst.HeaderFmt1;
import com.google.typography.font.sfntly.table.opentype.singlesubst.InnerArrayFmt2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class RuleExtractor {
    RuleExtractor() {
    }

    private static Set<Rule> extract(LigatureSubst table) {
        LinkedHashSet<Rule> allRules = new LinkedHashSet<Rule>();
        GlyphList prefixChars = RuleExtractor.extract(table.coverage());
        int i = 0;
        while (i < table.subTableCount()) {
            List<Rule> subRules = RuleExtractor.extract(table.subTableAt(i));
            subRules = Rule.prependToInput((int)((Integer)prefixChars.get(i)), subRules);
            allRules.addAll(subRules);
            ++i;
        }
        return allRules;
    }

    private static GlyphList extract(CoverageTable table) {
        switch (table.format) {
            case 1: {
                return RuleExtractor.extract(table.fmt1Table());
            }
            case 2: {
                RangeRecordTable array = table.fmt2Table();
                Map<Integer, GlyphGroup> map = RuleExtractor.extract(array);
                Collection<GlyphGroup> groups = map.values();
                GlyphList result = new GlyphList();
                for (GlyphGroup glyphIds : groups) {
                    glyphIds.copyTo(result);
                }
                return result;
            }
        }
        throw new IllegalArgumentException("unimplemented format " + table.format);
    }

    private static GlyphList extract(RecordsTable<NumRecord> table) {
        GlyphList result = new GlyphList();
        for (NumRecord record : table.recordList) {
            result.add(record.value);
        }
        return result;
    }

    private static Map<Integer, GlyphGroup> extract(RangeRecordTable table) {
        LinkedHashMap<Integer, GlyphGroup> result = new LinkedHashMap<Integer, GlyphGroup>();
        for (RangeRecord record : table.recordList) {
            if (!result.containsKey(record.property)) {
                result.put(record.property, new GlyphGroup());
            }
            GlyphGroup existingGlyphs = (GlyphGroup)result.get(record.property);
            existingGlyphs.addAll(RuleExtractor.extract(record));
        }
        return result;
    }

    private static GlyphGroup extract(RangeRecord record) {
        int len = record.end - record.start + 1;
        GlyphGroup result = new GlyphGroup();
        int i = record.start;
        while (i <= record.end) {
            result.add(i);
            ++i;
        }
        return result;
    }

    private static List<Rule> extract(LigatureSet table) {
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        int i = 0;
        while (i < table.subTableCount()) {
            Rule subRule = RuleExtractor.extract((Ligature)table.subTableAt(i));
            allRules.add(subRule);
            ++i;
        }
        return allRules;
    }

    private static Rule extract(Ligature table) {
        int glyphId = table.getField(0);
        RuleSegment subst = new RuleSegment(glyphId);
        RuleSegment input = new RuleSegment();
        for (NumRecord record : table.recordList) {
            input.add(record.value);
        }
        return new Rule(null, input, null, subst);
    }

    private static Set<Rule> extract(SingleSubst table) {
        switch (table.format) {
            case 1: {
                return RuleExtractor.extract(table.fmt1Table());
            }
            case 2: {
                return RuleExtractor.extract(table.fmt2Table());
            }
        }
        throw new IllegalArgumentException("unimplemented format " + table.format);
    }

    private static Set<Rule> extract(HeaderFmt1 fmt1Table) {
        GlyphList coverage = RuleExtractor.extract(fmt1Table.coverage);
        int delta = fmt1Table.getDelta();
        return Rule.deltaRules(coverage, delta);
    }

    private static Set<Rule> extract(InnerArrayFmt2 fmt2Table) {
        GlyphList coverage = RuleExtractor.extract(fmt2Table.coverage);
        GlyphList substs = RuleExtractor.extract((RecordsTable<NumRecord>)fmt2Table);
        return Rule.oneToOneRules(coverage, substs);
    }

    private static Set<Rule> extract(MultipleSubst table) {
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        GlyphList coverage = RuleExtractor.extract(table.coverage());
        int i = 0;
        for (NumRecordTable glyphIds : table) {
            RuleSegment input = new RuleSegment((Integer)coverage.get(i));
            GlyphList glyphList = RuleExtractor.extract(glyphIds);
            RuleSegment subst = new RuleSegment(glyphList);
            Rule rule = new Rule(null, input, null, subst);
            result.add(rule);
            ++i;
        }
        return result;
    }

    private static Set<Rule> extract(AlternateSubst table) {
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        GlyphList coverage = RuleExtractor.extract(table.coverage());
        int i = 0;
        for (NumRecordTable glyphIds : table) {
            RuleSegment input = new RuleSegment((Integer)coverage.get(i));
            GlyphList glyphList = RuleExtractor.extract(glyphIds);
            GlyphGroup glyphGroup = new GlyphGroup(glyphList);
            RuleSegment subst = new RuleSegment(glyphGroup);
            Rule rule = new Rule(null, input, null, subst);
            result.add(rule);
            ++i;
        }
        return result;
    }

    private static Set<Rule> extract(ContextSubst table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        switch (table.format) {
            case 1: {
                return RuleExtractor.extract(table.fmt1Table(), lookupListTable, allLookupRules);
            }
            case 2: {
                return RuleExtractor.extract(table.fmt2Table(), lookupListTable, allLookupRules);
            }
        }
        throw new IllegalArgumentException("unimplemented format " + table.format);
    }

    private static Set<Rule> extract(SubRuleSetArray table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        GlyphList coverage = RuleExtractor.extract(table.coverage);
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        int i = 0;
        for (SubRuleSet subRuleSet : table) {
            Set<Rule> subRules = RuleExtractor.extract((Integer)coverage.get(i), subRuleSet, lookupListTable, allLookupRules);
            result.addAll(subRules);
            ++i;
        }
        return result;
    }

    private static Set<Rule> extract(Integer firstGlyph, SubRuleSet table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        for (SubRule subRule : table) {
            Set<Rule> subrules = RuleExtractor.extract(firstGlyph, subRule, lookupListTable, allLookupRules);
            if (subrules == null) {
                return null;
            }
            result.addAll(subrules);
        }
        return result;
    }

    private static Set<Rule> extract(Integer firstGlyph, SubRule table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        RuleSegment inputRow = new RuleSegment(firstGlyph);
        for (NumRecord record : table.inputGlyphs) {
            inputRow.add(record.value);
        }
        Rule ruleSansSubst = new Rule(null, inputRow, null, null);
        return RuleExtractor.applyChainingLookup(ruleSansSubst, table.lookupRecords, lookupListTable, allLookupRules);
    }

    private static Set<Rule> extract(SubClassSetArray table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        GlyphList coverage = RuleExtractor.extract(table.coverage);
        Map<Integer, GlyphGroup> classDef = RuleExtractor.extract(table.classDef);
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        int i = 0;
        for (SubClassSet subClassRuleSet : table) {
            if (subClassRuleSet != null) {
                Set<Rule> subRules = RuleExtractor.extract(subClassRuleSet, i, classDef, lookupListTable, allLookupRules);
                result.addAll(subRules);
            }
            ++i;
        }
        return result;
    }

    private static Set<Rule> extract(SubClassSet table, int firstInputClass, Map<Integer, GlyphGroup> inputClassDef, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        for (SubClassRule subRule : table) {
            Set<Rule> subRules = RuleExtractor.extract(subRule, firstInputClass, inputClassDef, lookupListTable, allLookupRules);
            result.addAll(subRules);
        }
        return result;
    }

    private static Set<Rule> extract(SubClassRule table, int firstInputClass, Map<Integer, GlyphGroup> inputClassDef, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        RuleSegment input = RuleExtractor.extract(firstInputClass, table.inputClasses(), inputClassDef);
        Rule ruleSansSubst = new Rule(null, input, null, null);
        return RuleExtractor.applyChainingLookup(ruleSansSubst, table.lookupRecords, lookupListTable, allLookupRules);
    }

    private static Set<Rule> extract(ChainContextSubst table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        switch (table.format) {
            case 1: {
                return RuleExtractor.extract(table.fmt1Table(), lookupListTable, allLookupRules);
            }
            case 2: {
                return RuleExtractor.extract(table.fmt2Table(), lookupListTable, allLookupRules);
            }
            case 3: {
                return RuleExtractor.extract(table.fmt3Table(), lookupListTable, allLookupRules);
            }
        }
        throw new IllegalArgumentException("unimplemented format " + table.format);
    }

    private static Set<Rule> extract(ChainSubRuleSetArray table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        GlyphList coverage = RuleExtractor.extract(table.coverage);
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        int i = 0;
        for (ChainSubRuleSet subRuleSet : table) {
            Set<Rule> subRules = RuleExtractor.extract((Integer)coverage.get(i), subRuleSet, lookupListTable, allLookupRules);
            result.addAll(subRules);
            ++i;
        }
        return result;
    }

    private static Set<Rule> extract(Integer firstGlyph, ChainSubRuleSet table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        for (ChainSubRule subRule : table) {
            result.addAll(RuleExtractor.extract(firstGlyph, subRule, lookupListTable, allLookupRules));
        }
        return result;
    }

    private static Set<Rule> extract(Integer firstGlyph, ChainSubRule table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        RuleSegment inputRow = new RuleSegment(firstGlyph);
        for (NumRecord record : table.inputClasses) {
            inputRow.add(record.value);
        }
        RuleSegment backtrack = RuleExtractor.ruleSegmentFromGlyphs(table.backtrackGlyphs);
        RuleSegment lookAhead = RuleExtractor.ruleSegmentFromGlyphs(table.lookAheadGlyphs);
        Rule ruleSansSubst = new Rule(backtrack, inputRow, lookAhead, null);
        return RuleExtractor.applyChainingLookup(ruleSansSubst, table.lookupRecords, lookupListTable, allLookupRules);
    }

    private static RuleSegment ruleSegmentFromGlyphs(NumRecordList records) {
        RuleSegment segment = new RuleSegment();
        for (NumRecord record : records) {
            segment.add(new GlyphGroup(record.value));
        }
        return segment;
    }

    private static Set<Rule> extract(ChainSubClassSetArray table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        Map<Integer, GlyphGroup> backtrackClassDef = RuleExtractor.extract(table.backtrackClassDef);
        Map<Integer, GlyphGroup> inputClassDef = RuleExtractor.extract(table.inputClassDef);
        Map<Integer, GlyphGroup> lookAheadClassDef = RuleExtractor.extract(table.lookAheadClassDef);
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        int i = 0;
        for (ChainSubClassSet chainSubRuleSet : table) {
            if (chainSubRuleSet != null) {
                result.addAll(RuleExtractor.extract(chainSubRuleSet, backtrackClassDef, i, inputClassDef, lookAheadClassDef, lookupListTable, allLookupRules));
            }
            ++i;
        }
        return result;
    }

    private static Map<Integer, GlyphGroup> extract(ClassDefTable table) {
        switch (table.format) {
            case 1: {
                return RuleExtractor.extract(table.fmt1Table());
            }
            case 2: {
                return RuleExtractor.extract(table.fmt2Table());
            }
        }
        throw new IllegalArgumentException("unimplemented format " + table.format);
    }

    private static Map<Integer, GlyphGroup> extract(InnerArrayFmt1 table) {
        HashMap<Integer, GlyphGroup> result = new HashMap<Integer, GlyphGroup>();
        int glyphId = table.getField(0);
        for (NumRecord record : table) {
            int classId = record.value;
            if (!result.containsKey(classId)) {
                result.put(classId, new GlyphGroup());
            }
            ((GlyphGroup)result.get(classId)).add(glyphId);
            ++glyphId;
        }
        return result;
    }

    private static List<Rule> extract(ChainSubClassSet table, Map<Integer, GlyphGroup> backtrackClassDef, int firstInputClass, Map<Integer, GlyphGroup> inputClassDef, Map<Integer, GlyphGroup> lookAheadClassDef, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (ChainSubClassRule chainSubRule : table) {
            result.addAll(RuleExtractor.extract(chainSubRule, backtrackClassDef, firstInputClass, inputClassDef, lookAheadClassDef, lookupListTable, allLookupRules));
        }
        return result;
    }

    private static Set<Rule> extract(ChainSubClassRule table, Map<Integer, GlyphGroup> backtrackClassDef, int firstInputClass, Map<Integer, GlyphGroup> inputClassDef, Map<Integer, GlyphGroup> lookAheadClassDef, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        RuleSegment backtrack = RuleExtractor.ruleSegmentFromClasses(table.backtrackGlyphs, backtrackClassDef);
        RuleSegment inputRow = RuleExtractor.extract(firstInputClass, table.inputClasses, inputClassDef);
        RuleSegment lookAhead = RuleExtractor.ruleSegmentFromClasses(table.lookAheadGlyphs, lookAheadClassDef);
        Rule ruleSansSubst = new Rule(backtrack, inputRow, lookAhead, null);
        return RuleExtractor.applyChainingLookup(ruleSansSubst, table.lookupRecords, lookupListTable, allLookupRules);
    }

    private static RuleSegment extract(int firstInputClass, NumRecordList inputClasses, Map<Integer, GlyphGroup> classDef) {
        RuleSegment input = new RuleSegment(classDef.get(firstInputClass));
        for (NumRecord inputClass : inputClasses) {
            int classId = inputClass.value;
            GlyphGroup glyphs = classDef.get(classId);
            if (glyphs == null && classId == 0) {
                glyphs = GlyphGroup.inverseGlyphGroup(classDef.values());
            }
            input.add(glyphs);
        }
        return input;
    }

    private static RuleSegment ruleSegmentFromClasses(NumRecordList classes, Map<Integer, GlyphGroup> classDef) {
        RuleSegment segment = new RuleSegment();
        for (NumRecord classRecord : classes) {
            int classId = classRecord.value;
            GlyphGroup glyphs = classDef.get(classId);
            if (glyphs == null && classId == 0) {
                glyphs = GlyphGroup.inverseGlyphGroup(classDef.values());
            }
            segment.add(glyphs);
        }
        return segment;
    }

    private static Set<Rule> extract(InnerArraysFmt3 table, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        RuleSegment backtrackContext = RuleExtractor.extract(table.backtrackGlyphs);
        RuleSegment input = RuleExtractor.extract(table.inputGlyphs);
        RuleSegment lookAheadContext = RuleExtractor.extract(table.lookAheadGlyphs);
        Rule ruleSansSubst = new Rule(backtrackContext, input, lookAheadContext, null);
        Set<Rule> result = RuleExtractor.applyChainingLookup(ruleSansSubst, table.lookupRecords, lookupListTable, allLookupRules);
        return result;
    }

    private static Set<Rule> extract(ReverseChainSingleSubst table) {
        GlyphList coverage = RuleExtractor.extract(table.coverage);
        RuleSegment backtrackContext = new RuleSegment();
        backtrackContext.addAll(RuleExtractor.extract(table.backtrackGlyphs));
        RuleSegment lookAheadContext = new RuleSegment();
        lookAheadContext.addAll(RuleExtractor.extract(table.lookAheadGlyphs));
        GlyphList substs = RuleExtractor.extract(table.substitutes);
        return Rule.oneToOneRules(backtrackContext, coverage, lookAheadContext, substs);
    }

    private static Set<Rule> applyChainingLookup(Rule ruleSansSubst, SubstLookupRecordList lookups, LookupListTable lookupListTable, Map<Integer, Set<Rule>> allLookupRules) {
        LinkedList<Rule> targetRules = new LinkedList<Rule>();
        targetRules.add(ruleSansSubst);
        for (SubstLookupRecord lookup : lookups) {
            int at = lookup.sequenceIndex;
            int lookupIndex = lookup.lookupListIndex;
            Set<Rule> rulesToApply = RuleExtractor.extract(lookupListTable, allLookupRules, lookupIndex);
            if (rulesToApply == null) {
                throw new IllegalArgumentException("Out of bound lookup index for chaining lookup: " + lookupIndex);
            }
            LinkedList<Rule> newRules = Rule.applyRulesOnRules(rulesToApply, targetRules, at);
            LinkedList<Rule> result = new LinkedList<Rule>();
            result.addAll(newRules);
            result.addAll(targetRules);
            targetRules = result;
        }
        LinkedHashSet<Rule> result = new LinkedHashSet<Rule>();
        for (Rule rule : targetRules) {
            if (rule.subst == null) continue;
            result.add(rule);
        }
        return result;
    }

    static Map<Integer, Set<Rule>> extract(LookupListTable table) {
        TreeMap<Integer, Set<Rule>> allRules = new TreeMap<Integer, Set<Rule>>();
        int i = 0;
        while (i < table.subTableCount()) {
            RuleExtractor.extract(table, allRules, i);
            ++i;
        }
        return allRules;
    }

    private static Set<Rule> extract(LookupListTable lookupListTable, Map<Integer, Set<Rule>> allRules, int i) {
        if (allRules.containsKey(i)) {
            return allRules.get(i);
        }
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
        LookupTable lookupTable = (LookupTable)lookupListTable.subTableAt(i);
        GsubLookupType lookupType = lookupTable.lookupType();
        for (SubstSubtable substSubtable : lookupTable) {
            GsubLookupType subTableLookupType = lookupType;
            if (lookupType == GsubLookupType.GSUB_EXTENSION) {
                ExtensionSubst extensionSubst = (ExtensionSubst)substSubtable;
                substSubtable = extensionSubst.subTable();
                subTableLookupType = extensionSubst.lookupType();
            }
            Set<Rule> subrules = null;
            switch (subTableLookupType) {
                case GSUB_LIGATURE: {
                    subrules = RuleExtractor.extract((LigatureSubst)substSubtable);
                    break;
                }
                case GSUB_SINGLE: {
                    subrules = RuleExtractor.extract((SingleSubst)substSubtable);
                    break;
                }
                case GSUB_ALTERNATE: {
                    subrules = RuleExtractor.extract((AlternateSubst)substSubtable);
                    break;
                }
                case GSUB_MULTIPLE: {
                    subrules = RuleExtractor.extract((MultipleSubst)substSubtable);
                    break;
                }
                case GSUB_REVERSE_CHAINING_CONTEXTUAL_SINGLE: {
                    subrules = RuleExtractor.extract((ReverseChainSingleSubst)substSubtable);
                    break;
                }
                case GSUB_CHAINING_CONTEXTUAL: {
                    subrules = RuleExtractor.extract((ChainContextSubst)substSubtable, lookupListTable, allRules);
                    break;
                }
                case GSUB_CONTEXTUAL: {
                    subrules = RuleExtractor.extract((ContextSubst)substSubtable, lookupListTable, allRules);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (subrules == null) {
                throw new IllegalStateException();
            }
            rules.addAll(subrules);
        }
        if (rules.size() == 0) {
            System.err.println("There are no rules in lookup " + i);
        }
        allRules.put(i, rules);
        return rules;
    }

    private static RuleSegment extract(CoverageArray table) {
        RuleSegment result = new RuleSegment();
        for (CoverageTable coverage : table) {
            GlyphGroup glyphGroup = new GlyphGroup();
            glyphGroup.addAll(RuleExtractor.extract(coverage));
            result.add(glyphGroup);
        }
        return result;
    }
}

