#include <hidef.h>           /* common defines and macros */

#include "API_BD8379.h"

void delay_ns(INT32U time)
{
    INT32U i;
    for(i = 0; i < time; i++)
    {
        asm NOP;
        _FEED_COP();
        //wdt_reset();
    }
}

void DB8379_Init(void)
{
    DB8379_OE_P = 0;
    DB8379_RST_P = 0;
    delay_ns(30);
    DB8379_RST_P = 1;
}


 /*----------BD8379оƬ  data0data1data2ֱΪһڶ͵оƬ-------------*/
/*-----------------------------------------------------------------------------------------------*/
void DB8379_WriteData(INT32U  data0, INT32U  data1)
{
    INT8U i = 0;
    INT8U num = 0; 
    INT32U tmp[3];
    INT32U mask = 0x80000000;      


    tmp[0] = data1;
    tmp[1] = data0;

    DB8379_SIN_P = 0;
    DB8379_CLK_P = 0;
    DB8379_LE_P = 0;

    for(num = 0; num < 2; num++)  
    {
        for(i = 0; i < 12; i++)                   //ߵ12λҪһ
        {
            if(tmp[num] & mask)            DB8379_SIN_P = 1;
            else                           DB8379_SIN_P = 0;

            delay_ns(8);
            DB8379_CLK_P = 1;

            delay_ns(28);
            DB8379_CLK_P = 0;
            mask >>= 1;
        }

        mask = 0x80000000;       
    }
    DB8379_LE_P = 1;
    delay_ns(14);
    DB8379_LE_P = 0;
}