/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyph;

public class CompositeBitmapGlyph
extends BitmapGlyph {
    private int numComponentsOffset;
    private int componentArrayOffset;

    protected CompositeBitmapGlyph(ReadableFontData data, int format) {
        super(data, format);
        this.initialize(format);
    }

    private void initialize(int format) {
        if (format == 8) {
            this.numComponentsOffset = BitmapGlyph.Offset.glyphFormat8_numComponents.offset;
            this.componentArrayOffset = BitmapGlyph.Offset.glyphFormat8_componentArray.offset;
        } else if (format == 9) {
            this.numComponentsOffset = BitmapGlyph.Offset.glyphFormat9_numComponents.offset;
            this.componentArrayOffset = BitmapGlyph.Offset.glyphFormat9_componentArray.offset;
        } else {
            throw new IllegalStateException("Attempt to create a Composite Bitmap Glyph with a non-composite format.");
        }
    }

    public int numComponents() {
        return this.data.readUShort(this.numComponentsOffset);
    }

    public Component component(int componentNum) {
        int componentOffset = this.componentArrayOffset + componentNum * BitmapGlyph.Offset.ebdtComponentLength.offset;
        return new Component(this.data.readUShort(componentOffset + BitmapGlyph.Offset.ebdtComponent_glyphCode.offset), this.data.readChar(componentOffset + BitmapGlyph.Offset.ebdtComponent_xOffset.offset), this.data.readChar(componentOffset + BitmapGlyph.Offset.ebdtComponent_yOffset.offset));
    }

    public static class Builder
    extends BitmapGlyph.Builder<CompositeBitmapGlyph> {
        protected Builder(WritableFontData data, int format) {
            super(data, format);
        }

        protected Builder(ReadableFontData data, int format) {
            super(data, format);
        }

        @Override
        protected CompositeBitmapGlyph subBuildTable(ReadableFontData data) {
            return new CompositeBitmapGlyph(data, this.format());
        }
    }

    public static final class Component {
        private final int glyphCode;
        private int xOffset;
        private int yOffset;

        protected Component(int glyphCode, int xOffset, int yOffset) {
            this.glyphCode = glyphCode;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        public int glyphCode() {
            return this.glyphCode;
        }

        public int xOffset() {
            return this.xOffset;
        }

        public int yOffset() {
            return this.yOffset;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.glyphCode;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Component)) {
                return false;
            }
            Component other = (Component)obj;
            return this.glyphCode == other.glyphCode;
        }
    }
}

