/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalDeviceMetricsTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.tools.conversion.eot.MagnitudeDependentWriter;

public class HdmxEncoder {
    private static int HEADER_SIZE = 8;
    private static int RECORD_SIZE = 2;

    public WritableFontData encode(Font sourceFont) {
        HorizontalDeviceMetricsTable hdmx = (HorizontalDeviceMetricsTable)sourceFont.getTable(Tag.hdmx);
        HorizontalMetricsTable hmtx = (HorizontalMetricsTable)sourceFont.getTable(Tag.hmtx);
        MaximumProfileTable maxp = (MaximumProfileTable)sourceFont.getTable(Tag.maxp);
        FontHeaderTable head = (FontHeaderTable)sourceFont.getTable(Tag.head);
        int unitsPerEm = head.unitsPerEm();
        int numRecords = hdmx.numRecords();
        int numGlyphs = maxp.numGlyphs();
        MagnitudeDependentWriter magWriter = new MagnitudeDependentWriter();
        int i = 0;
        while (i < numRecords) {
            int ppem = hdmx.pixelSize(i);
            int j = 0;
            while (j < numGlyphs) {
                int roundedTtAw = ((64 * ppem * hmtx.advanceWidth(j) + unitsPerEm / 2) / unitsPerEm + 32) / 64;
                int surprise = hdmx.width(i, j) - roundedTtAw;
                magWriter.writeValue(surprise);
                ++j;
            }
            ++i;
        }
        magWriter.flush();
        byte[] magBytes = magWriter.toByteArray();
        int resultSize = magBytes.length + HEADER_SIZE + RECORD_SIZE * numRecords;
        WritableFontData result = WritableFontData.createWritableFontData(resultSize);
        result.writeUShort(0, 0);
        result.writeUShort(2, numRecords);
        result.writeLong(4, hdmx.recordSize());
        int i2 = 0;
        while (i2 < numRecords) {
            result.writeByte(HEADER_SIZE + RECORD_SIZE * i2, (byte)hdmx.pixelSize(i2));
            result.writeByte(HEADER_SIZE + RECORD_SIZE * i2 + 1, (byte)hdmx.maxWidth(i2));
            ++i2;
        }
        result.writeBytes(HEADER_SIZE + RECORD_SIZE * numRecords, magBytes);
        return result;
    }
}

