/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.ByteArray;
import java.io.IOException;
import java.io.OutputStream;

final class MemoryByteArray
extends ByteArray<MemoryByteArray> {
    private byte[] b;

    public MemoryByteArray(int length) {
        this(new byte[length], 0);
    }

    public MemoryByteArray(byte[] b) {
        this(b, b.length);
    }

    public MemoryByteArray(byte[] b, int filledLength) {
        super(filledLength, b.length);
        this.b = b;
    }

    @Override
    protected void internalPut(int index, byte b) {
        this.b[index] = b;
    }

    @Override
    protected int internalPut(int index, byte[] b, int offset, int length) {
        System.arraycopy(b, offset, this.b, index, length);
        return length;
    }

    @Override
    protected int internalGet(int index) {
        return this.b[index];
    }

    @Override
    protected int internalGet(int index, byte[] b, int offset, int length) {
        System.arraycopy(this.b, index, b, offset, length);
        return length;
    }

    @Override
    public void close() {
        this.b = null;
    }

    @Override
    public int copyTo(OutputStream os, int offset, int length) throws IOException {
        os.write(this.b, offset, length);
        return length;
    }
}

