/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.tools.subsetter.HorizontalMetricsTableBuilder;
import java.util.ArrayList;
import junit.framework.TestCase;

public class HorizontalMetricsTableBuilderTest
extends TestCase {
    public void testHorizontalMetricsTableBuilder() {
        FontFactory fontFactory = FontFactory.getInstance();
        Font.Builder fontBuilder = fontFactory.newFontBuilder();
        HorizontalHeaderTable.Builder hheaBuilder = (HorizontalHeaderTable.Builder)fontBuilder.newTableBuilder(Tag.hhea);
        ArrayList<HorizontalMetricsTableBuilder.LongHorMetric> metrics = new ArrayList<HorizontalMetricsTableBuilder.LongHorMetric>();
        metrics.add(new HorizontalMetricsTableBuilder.LongHorMetric(123, 42));
        metrics.add(new HorizontalMetricsTableBuilder.LongHorMetric(123, 43));
        metrics.add(new HorizontalMetricsTableBuilder.LongHorMetric(789, 44));
        metrics.add(new HorizontalMetricsTableBuilder.LongHorMetric(789, 45));
        new HorizontalMetricsTableBuilder(fontBuilder, metrics).build();
        MaximumProfileTable.Builder maxpBuilder = (MaximumProfileTable.Builder)fontBuilder.newTableBuilder(Tag.maxp);
        maxpBuilder.setNumGlyphs(4);
        Font font = fontBuilder.build();
        HorizontalMetricsTable hmtxTable = (HorizontalMetricsTable)font.getTable(Tag.hmtx);
        HorizontalMetricsTableBuilderTest.assertEquals(3, hmtxTable.numberOfHMetrics());
        HorizontalMetricsTableBuilderTest.assertEquals(1, hmtxTable.numberOfLSBs());
        HorizontalMetricsTableBuilderTest.assertEquals(123, hmtxTable.advanceWidth(0));
        HorizontalMetricsTableBuilderTest.assertEquals(42, hmtxTable.leftSideBearing(0));
        HorizontalMetricsTableBuilderTest.assertEquals(123, hmtxTable.advanceWidth(1));
        HorizontalMetricsTableBuilderTest.assertEquals(43, hmtxTable.leftSideBearing(1));
        HorizontalMetricsTableBuilderTest.assertEquals(789, hmtxTable.advanceWidth(2));
        HorizontalMetricsTableBuilderTest.assertEquals(44, hmtxTable.leftSideBearing(2));
        HorizontalMetricsTableBuilderTest.assertEquals(789, hmtxTable.advanceWidth(3));
        HorizontalMetricsTableBuilderTest.assertEquals(45, hmtxTable.leftSideBearing(3));
    }
}

