/********************************************************************************/
/*  CONFIDENTIAL                                                                */
/*  Copyright (C) 2011 Yamaha Corporation. All rights reserved.                 */
/*  Module          : $Workfile: YGV642_SPI_Flash_S25FL256S.h $                 */
/*  Description     : Pattern memory S25FL256S driver include header            */
/*  Version         : $Rev: 145 $                                               */
/*  Last UpDate Time: $Date:: 2012-08-24 13:55:38#$                             */
/*  FOOT NOTE       : adjust 2tab                                               */
/*  AUTHOR          : H.Katayama                                                */
/********************************************************************************/
#ifndef _YGV642_SPI_FLASH_W25Q256FV_H_
#define _YGV642_SPI_FLASH_W25Q256FV_H_

#include "YGV642.h"

enum PM_W25Q256FV_CMD
{
  PM_W25Q256FV_CMD_READ_JEDEC_ID,
  
  PM_W25Q256FV_CMD_WRITE_ENABLE,
  PM_W25Q256FV_CMD_4_BYTE_ADDR_MODE,
	PM_W25Q256FV_CMD_WRITE_STATUS2,
	PM_W25Q256FV_CMD_READ_STATUS1,
	PM_W25Q256FV_CMD_READ_STATUS3,
	PM_W25Q256FV_CMD_Q_IO_READ,
	PM_W25Q256FV_CMD_CHIP_ERASE,
	PM_W25Q256FV_CMD_SECTOR_ERASE,
	PM_W25Q256FV_CMD_PAGE_PROGRAM,
};

/*------------------------------------------------------------------------------*/
/*                      D E F I N E                                             */
/*------------------------------------------------------------------------------*/

#define PM_W25Q256FV_READACS_PMRREQ         (0x80)
#define PM_W25Q256FV_READACS_PWBUSY         (0x40)
#define PM_W25Q256FV_READACS_CSNEG          (0x10)

#define PM_W25Q256FV_MANUFACTURER_ID        (0xEF)
#define PM_W25Q256FV_DEVICE_ID_MSB          (0x40)
#define PM_W25Q256FV_DEVICE_ID_LSB          (0x19)  

/*------------------------------------------------------------------------------*/
/*                      V A R I A B L E S                                       */
/*------------------------------------------------------------------------------*/

/*	VC1N Pattern Memory Control Registers
 *
 *				      +-------+-------+-------+-------+-------+-------+-------+-------+
 *	R#85(0x55)	|  "0"  |  "0"  |INSKIP |  "0"  |    CAP[1:0]   |   MMOD[1:0]   |
 *			      	+-------+-------+-------+-------+-------+-------+-------+-------+
 *	R#86(0x56)	|  NMBIT[1:0]   |       CSTIM[2:0]      |       DTTIM[2:0]      |
 *			      	+-------+-------+-------+-------+-------+-------+-------+-------+
 *	R#87(0x57)	|  "0"  |  "0"  |       ADTIM[2:0]      |       MBTIM[2:0]      |
 *			      	+-------+-------+-------+-------+-------+-------+-------+-------+
 *	R#88(0x58)	|                   DMTIM[5:0]                  | INTIM[1:0]    |
 *			      	+-------+-------+-------+-------+-------+-------+-------+-------+
 *	R#89(0x59)	|                          INCOD[7:0]                           |
 *			      	+-------+-------+-------+-------+-------+-------+-------+-------+
 *	R#90(0x5A)	|                          DMBIT[15:8]                          |
 *	R#91(0x5B)	|                          DMBIT[7:0]                           |
 *			      	+-------+-------+-------+-------+-------+-------+-------+-------+
 */
 
static const uint8_t PMW25Q256FVCmdData[][7 + 1] =
{
/*  R#55h R#56h R#57h R#58h R#59h R#5Ah R#5Bh P#3 */
  { 0x06, 0x1B, 0x00, 0x03, 0x9F, 0x00, 0x00, 0x00 }, /* Read JEDEC ID           */
  
	{ 0x06, 0x18, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00 }, /* Write Enable            */
	{ 0x06, 0x18, 0x00, 0x03, 0xB7, 0x00, 0x00, 0x00 }, /* Enter 4-Byte Addr Mode  */
	{ 0x06, 0x1B, 0x00, 0x03, 0x31, 0x00, 0x00, 0x00 }, /* Write Status Register-2 */
	{ 0x06, 0x03, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00 }, /* Read  Status Register-1 */
	{ 0x06, 0x03, 0x00, 0x03, 0x15, 0x00, 0x00, 0x00 }, /* Read  Status Register-3 */
	{ 0x06, 0x81, 0x22, 0x13, 0xEC, 0x00, 0x00, 0x00 }, /* Fast Read QuadI/O       */
	{ 0x06, 0x18, 0x00, 0x03, 0xC7, 0x00, 0x00, 0x00 }, /* Chip Erase              */
	{ 0x06, 0x18, 0x18, 0x03, 0x20, 0x00, 0x00, 0x00 }, /* Sector Erase            */
	{ 0x06, 0x19, 0x18, 0x03, 0x32, 0x00, 0x00, 0x00 }, /* Page Program            */
};

/*------------------------------------------------------------------------------*/
/*                      F U N C T I O N S                                       */
/*------------------------------------------------------------------------------*/
uint8_t PM_W25Q256FV_ID_Check(void);
void PM_W25Q256FV_Init(void);
void PM_W25Q256FV_Set_Pattern_Memory_Addr(uint32_t Addr);
void PM_W25Q256FV_Write_Cmd(uint8_t CmdNo, uint8_t NumCmd, uint8_t Send);
uint8_t PM_W25Q256FV_Read_Reg(uint8_t CmdNo, uint8_t NumCmd);
void PM_W25Q256FV_Wait_Clear_Flag(uint8_t Mask);
#endif
