
#include "Radar_R3.h"


RadarR3DataBufferUnion        RadarR3Data;
RadarR3ReceivingCtrlStruct    RadarR3ReceivingCtrl;

void Radar_R3_Init(void)
{
  RadarR3ReceivingCtrl.Enable   = 0;
  RadarR3ReceivingCtrl.SelfTest = 0;
  RadarR3ReceivingCtrl.Ptr      = 0;
  RadarR3ReceivingCtrl.Len      = 0;
  RadarR3ReceivingCtrl.Complete = 0;
  RadarR3ReceivingCtrl.Counter  = 0;
  
  RADAR_VALID            = 0;
  RADAR_SELF_TEST_PASSED = 0;
  RADAR_SYS_FAULT        = 0;
  RADAR_SOUND            = RADAR_SND_MUTE;
  
  RADAR_SENSOR_FL  = 0;
  RADAR_SENSOR_FLM = 0;
  RADAR_SENSOR_FRM = 0;
  RADAR_SENSOR_FR  = 0;

  RADAR_SENSOR_RL  = 0;
  RADAR_SENSOR_RLM = 0;
  RADAR_SENSOR_RRM = 0;
  RADAR_SENSOR_RR  = 0;
}

//10ms
void Radar_R3_Receiving_Service(void)
{
#if 0
  uint16_t Counter;
  uint8_t  SelfTestResult;
  
  if (RadarR3ReceivingCtrl.Enable)
  {
    if (LINE_IN_GEAR_R_SIGNAL)
    {
      RADAR_VALID = (RADAR_REAR_VALID_FLAG | RADAR_FRONT_VALID_FLAG) ;
    
      if (RadarR3ReceivingCtrl.Timer < 0xFFFF)
        RadarR3ReceivingCtrl.Timer++;
      
      if (RadarR3ReceivingCtrl.Timer >= (RADAR_R3_MSG_LOST_THRESHOLD * 100))
        RADAR_SYS_FAULT |=  RADAR_MSG_LOST_BIT;
      else
        RADAR_SYS_FAULT &= ~RADAR_MSG_LOST_BIT;
      
      if (RadarR3ReceivingCtrl.Complete)
      {
        RadarR3ReceivingCtrl.Complete = 0;
        RadarR3ReceivingCtrl.Timer    = 0;
        
        if (RadarR3Data.Frame.Type == RADAR_R3_MESSAGE_FRAME)
        {
          if (RadarR3ReceivingCtrl.SelfTest == 1)     //״״Լ
          {
            RadarR3ReceivingCtrl.SelfTest = 2;
            SelfTestResult                = 0;
            
            SelfTestResult |= RADAR_SENSOR_FL;  
            SelfTestResult |= RADAR_SENSOR_FLM; 
            SelfTestResult |= RADAR_SENSOR_FRM; 
            SelfTestResult |= RADAR_SENSOR_FR;  
            
            SelfTestResult |= RADAR_SENSOR_RL;  
            SelfTestResult |= RADAR_SENSOR_RLM; 
            SelfTestResult |= RADAR_SENSOR_RRM; 
            SelfTestResult |= RADAR_SENSOR_RR;
            
            if (SelfTestResult == 0)
              RADAR_SELF_TEST_PASSED = 1;
          }
          RADAR_SOUND      = RadarR3Data.Msg.Snd;
          
          RADAR_SENSOR_FL  = RadarR3Data.Msg.FL;
          RADAR_SENSOR_FLM = RadarR3Data.Msg.FLM;
          RADAR_SENSOR_FRM = RadarR3Data.Msg.FRM;
          RADAR_SENSOR_FR  = RadarR3Data.Msg.FR;

          RADAR_SENSOR_RL  = RadarR3Data.Msg.RL;
          RADAR_SENSOR_RLM = RadarR3Data.Msg.RLM;
          RADAR_SENSOR_RRM = RadarR3Data.Msg.RRM;
          RADAR_SENSOR_RR  = RadarR3Data.Msg.RR;

        }
        else if (RadarR3Data.Frame.Type == RADAR_R3_SELF_TEST_FRAME)
        {
          if (RadarR3ReceivingCtrl.SelfTest == 0)     //״,δԼ
            RadarR3ReceivingCtrl.SelfTest = 1;
          
          if (RadarR3Data.SelfTest.FLFault)
            RADAR_SENSOR_FL = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_FL = 0;
          
          if (RadarR3Data.SelfTest.FLMFault)
            RADAR_SENSOR_FLM = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_FLM = 0;
          
          if (RadarR3Data.SelfTest.FRMFault)
            RADAR_SENSOR_FRM = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_FRM = 0;
          
          if (RadarR3Data.SelfTest.FRFault)
            RADAR_SENSOR_FR = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_FR = 0;
          
          if (RadarR3Data.SelfTest.RLFault)
            RADAR_SENSOR_RL = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_RL  = 0;
          
          if (RadarR3Data.SelfTest.RLMFault)
            RADAR_SENSOR_RLM = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_RLM = 0;
          
          if (RadarR3Data.SelfTest.RRMFault)
            RADAR_SENSOR_RRM = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_RRM = 0;
          
          if (RadarR3Data.SelfTest.RRFault)
            RADAR_SENSOR_RR = RADAR_SENSOR_FAULT;
          else
            RADAR_SENSOR_RR  = 0;
        }
      }
      else
      {
        Counter = API_ROLLING_COUNTER;
        if (Counter - RadarR3ReceivingCtrl.Counter >= (10000 / API_INT_CYCLE))
          RadarR3ReceivingCtrl.Ptr = 0;
      }
    }
    else
    {
      if (RADAR_VALID)
      {
        RadarR3ReceivingCtrl.SelfTest = 0;
        RadarR3ReceivingCtrl.Ptr      = 0;
        RadarR3ReceivingCtrl.Complete = 0;
        RadarR3ReceivingCtrl.Timer    = 0;
        
        RADAR_VALID            = 0;
        RADAR_SELF_TEST_PASSED = 0;
        RADAR_SYS_FAULT        = 0;
        RADAR_SOUND            = RADAR_SND_MUTE;
        
        RADAR_SENSOR_FL  = 0;
        RADAR_SENSOR_FLM = 0;
        RADAR_SENSOR_FRM = 0;
        RADAR_SENSOR_FR  = 0;

        RADAR_SENSOR_RL  = 0;
        RADAR_SENSOR_RLM = 0;
        RADAR_SENSOR_RRM = 0;
        RADAR_SENSOR_RR  = 0;
      }
    }
  }
#endif  
}

void Radar_R3_Receive_Enable(uint8_t En)
{
  if (En)
    En = 1;
  
  if (RadarR3ReceivingCtrl.Enable != En)
  {
    RadarR3ReceivingCtrl.SelfTest = 0;
    RadarR3ReceivingCtrl.Enable   = En;
    RadarR3ReceivingCtrl.Timer    = 0;
    
    RADAR_SELF_TEST_PASSED = 0;
    RADAR_SYS_FAULT        = 0;
    RADAR_SOUND            = RADAR_SND_MUTE;
    
    RADAR_SENSOR_FL  = 0;
    RADAR_SENSOR_FLM = 0;
    RADAR_SENSOR_FRM = 0;
    RADAR_SENSOR_FR  = 0;

    RADAR_SENSOR_RL  = 0;
    RADAR_SENSOR_RLM = 0;
    RADAR_SENSOR_RRM = 0;
    RADAR_SENSOR_RR  = 0;
    
    if (RadarR3ReceivingCtrl.Enable == 0)
      RADAR_VALID    = 0;
  }
}

void Radar_R3_Receive_Data(uint8_t Data, uint8_t Parity)
{
  uint16_t Counter;
  
  if ((RadarR3ReceivingCtrl.Enable) && (RADAR_VALID))
  {
    if (RadarR3ReceivingCtrl.Complete)
      return;
    
    Counter = API_ROLLING_COUNTER;
    RadarR3Data.Byte[RadarR3ReceivingCtrl.Ptr] = Data;
    
    if (RadarR3ReceivingCtrl.Ptr == 0)
    {
      if (RadarR3Data.Frame.Type == RADAR_R3_MESSAGE_FRAME)
      {
        RadarR3ReceivingCtrl.Ptr     = 1;
        RadarR3ReceivingCtrl.Len     = 5;
        RadarR3ReceivingCtrl.Counter = Counter;
      }
      else if (RadarR3Data.Frame.Type == RADAR_R3_SELF_TEST_FRAME)
      {
        RadarR3ReceivingCtrl.Ptr     = 1;
        RadarR3ReceivingCtrl.Len     = 3;
        RadarR3ReceivingCtrl.Counter = Counter;
      }
    }
    else
    {
      // 1ʱ10ms(10,000 us) 2У ½
      if ((Counter - RadarR3ReceivingCtrl.Counter >= (10000 / API_INT_CYCLE)) || \
          (Parity != 0))
      {
        RadarR3ReceivingCtrl.Ptr = 0;
        return;       
      }
      
      RadarR3ReceivingCtrl.Counter = Counter;
      RadarR3ReceivingCtrl.Ptr++;
      if (RadarR3ReceivingCtrl.Ptr >= RadarR3ReceivingCtrl.Len)
      {
        if (((RadarR3Data.Frame.Type == RADAR_R3_MESSAGE_FRAME) && \
             (RadarR3Data.Msg.EOF == RADAR_R3_EOF_MESSAGE)) || \
            ((RadarR3Data.Frame.Type == RADAR_R3_SELF_TEST_FRAME) && \
             (RadarR3Data.SelfTest.EOF == RADAR_R3_EOF_SELF_TEST)))
        {             
          RadarR3ReceivingCtrl.Complete = 1;
        }

        RadarR3ReceivingCtrl.Ptr = 0;
      }
    }
  }
}
