/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.OS2Table;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import com.google.typography.font.sfntly.testutils.TestUtils;
import java.io.File;
import java.util.EnumSet;
import junit.framework.TestCase;

public class OS2Tests
extends TestCase {
    private static final File TEST_FONT_FILE = TestFont.TestFontNames.OPENSANS.getFile();
    private static final byte[] achVendId_a = new byte[]{97};
    private static final byte[] achVendId_a_pad = new byte[]{97, 32, 32, 32};
    private static final byte[] achVendId_abcd = new byte[]{97, 98, 99, 100};

    public OS2Tests() {
    }

    public OS2Tests(String name) {
        super(name);
    }

    public void testAchVendId() throws Exception {
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(TEST_FONT_FILE);
        OS2Table.Builder os2TableBuilder = (OS2Table.Builder)fontBuilder.getTableBuilder(Tag.OS_2);
        os2TableBuilder.setAchVendId(achVendId_a);
        OS2Tests.assertTrue(TestUtils.equals(achVendId_a_pad, 0, os2TableBuilder.achVendId(), 0, achVendId_a_pad.length));
        os2TableBuilder.setAchVendId(achVendId_abcd);
        OS2Tests.assertTrue(TestUtils.equals(achVendId_abcd, 0, os2TableBuilder.achVendId(), 0, achVendId_abcd.length));
        os2TableBuilder.setAchVendId(achVendId_a);
        OS2Tests.assertTrue(TestUtils.equals(achVendId_a_pad, 0, os2TableBuilder.achVendId(), 0, achVendId_a_pad.length));
    }

    public void testUnicodeRange() throws Exception {
        EnumSet<OS2Table.UnicodeRange> urSet = OS2Tests.makeUnicodeRangeSet(false);
        long[] urArray = OS2Table.UnicodeRange.asArray(urSet);
        EnumSet<OS2Table.UnicodeRange> urSetCopy = OS2Table.UnicodeRange.asSet(urArray[0], urArray[1], urArray[2], urArray[3]);
        OS2Tests.assertEquals(urSet, urSetCopy);
    }

    public void testCodePageRange() throws Exception {
        EnumSet<OS2Table.CodePageRange> urSet = OS2Tests.makeCodePageRangeSet(false);
        long[] cprArray = OS2Table.CodePageRange.asArray(urSet);
        EnumSet<OS2Table.CodePageRange> urSetCopy = OS2Table.CodePageRange.asSet(cprArray[0], cprArray[1]);
        OS2Tests.assertEquals(urSet, urSetCopy);
    }

    private static EnumSet<OS2Table.UnicodeRange> makeUnicodeRangeSet(boolean odd) {
        EnumSet<OS2Table.UnicodeRange> rSet = EnumSet.noneOf(OS2Table.UnicodeRange.class);
        OS2Table.UnicodeRange[] unicodeRangeArray = OS2Table.UnicodeRange.values();
        int n = unicodeRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OS2Table.UnicodeRange r = unicodeRangeArray[n2];
            if (odd) {
                rSet.add(r);
            }
            odd = !odd;
            ++n2;
        }
        return rSet;
    }

    private static EnumSet<OS2Table.CodePageRange> makeCodePageRangeSet(boolean odd) {
        EnumSet<OS2Table.CodePageRange> rSet = EnumSet.noneOf(OS2Table.CodePageRange.class);
        OS2Table.CodePageRange[] codePageRangeArray = OS2Table.CodePageRange.values();
        int n = codePageRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OS2Table.CodePageRange r = codePageRangeArray[n2];
            if (odd) {
                rSet.add(r);
            }
            odd = !odd;
            ++n2;
        }
        return rSet;
    }
}

