/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.SubTableContainerTable;
import com.google.typography.font.sfntly.table.core.CMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class CMapTable
extends SubTableContainerTable
implements Iterable<CMap> {
    public static final int NOTDEF = 0;

    private CMapTable(Header header, ReadableFontData data) {
        super(header, data);
    }

    public int version() {
        return this.data.readUShort(Offset.version.offset);
    }

    public int numCMaps() {
        return this.data.readUShort(Offset.numTables.offset);
    }

    public int getCmapIndex(CMapId id) {
        int index = 0;
        while (index < this.numCMaps()) {
            if (id.equals(this.cmapId(index))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static int offsetForEncodingRecord(int index) {
        return Offset.encodingRecordStart.offset + index * Offset.encodingRecordSize.offset;
    }

    public CMapId cmapId(int index) {
        return CMapId.getInstance(this.platformId(index), this.encodingId(index));
    }

    public int platformId(int index) {
        return this.data.readUShort(Offset.encodingRecordPlatformId.offset + CMapTable.offsetForEncodingRecord(index));
    }

    public int encodingId(int index) {
        return this.data.readUShort(Offset.encodingRecordEncodingId.offset + CMapTable.offsetForEncodingRecord(index));
    }

    public int offset(int index) {
        return this.data.readULongAsInt(Offset.encodingRecordOffset.offset + CMapTable.offsetForEncodingRecord(index));
    }

    @Override
    public Iterator<CMap> iterator() {
        return new CMapIterator();
    }

    public Iterator<CMap> iterator(CMapFilter filter) {
        return new CMapIterator(filter);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" = { ");
        int i = 0;
        while (i < this.numCMaps()) {
            block5: {
                CMap cmap;
                try {
                    cmap = this.cmap(i);
                }
                catch (IOException e) {
                    break block5;
                }
                sb.append("[0x");
                sb.append(Integer.toHexString(this.offset(i)));
                sb.append(" = ");
                sb.append(cmap);
                if (i < this.numCMaps() - 1) {
                    sb.append("], ");
                } else {
                    sb.append("]");
                }
            }
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }

    public CMap cmap(int index) throws IOException {
        CMap.Builder<? extends CMap> builder = Builder.cmapBuilder(this.readFontData(), index);
        return (CMap)builder.build();
    }

    public CMap cmap(int platformId, int encodingId) {
        return this.cmap(CMapId.getInstance(platformId, encodingId));
    }

    public CMap cmap(final CMapId cmapId) {
        Iterator<CMap> cmapIter = this.iterator(new CMapFilter(){

            @Override
            public boolean accept(CMapId foundCMapId) {
                return cmapId.equals(foundCMapId);
            }
        });
        if (cmapIter.hasNext()) {
            return cmapIter.next();
        }
        return null;
    }

    /* synthetic */ CMapTable(Header header, ReadableFontData readableFontData, CMapTable cMapTable) {
        this(header, readableFontData);
    }

    public static class Builder
    extends SubTableContainerTable.Builder<CMapTable> {
        private int version = 0;
        private Map<CMapId, CMap.Builder<? extends CMap>> cmapBuilders;

        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        protected static CMap.Builder<? extends CMap> cmapBuilder(ReadableFontData data, int index) {
            if (index < 0 || index > Builder.numCMaps(data)) {
                throw new IndexOutOfBoundsException("CMap table is outside the bounds of the known tables.");
            }
            int platformId = data.readUShort(Offset.encodingRecordPlatformId.offset + CMapTable.offsetForEncodingRecord(index));
            int encodingId = data.readUShort(Offset.encodingRecordEncodingId.offset + CMapTable.offsetForEncodingRecord(index));
            int offset = data.readULongAsInt(Offset.encodingRecordOffset.offset + CMapTable.offsetForEncodingRecord(index));
            CMapId cmapId = CMapId.getInstance(platformId, encodingId);
            CMap.Builder<CMap> builder = CMap.Builder.getBuilder(data, offset, cmapId);
            return builder;
        }

        @Override
        protected void subDataSet() {
            this.cmapBuilders = null;
            super.setModelChanged(false);
        }

        private void initialize(ReadableFontData data) {
            this.cmapBuilders = new HashMap<CMapId, CMap.Builder<? extends CMap>>();
            int numCMaps = Builder.numCMaps(data);
            int i = 0;
            while (i < numCMaps) {
                CMap.Builder<? extends CMap> cmapBuilder = Builder.cmapBuilder(data, i);
                this.cmapBuilders.put(cmapBuilder.cmapId(), cmapBuilder);
                ++i;
            }
        }

        private Map<CMapId, CMap.Builder<? extends CMap>> getCMapBuilders() {
            if (this.cmapBuilders != null) {
                return this.cmapBuilders;
            }
            this.initialize(this.internalReadData());
            this.setModelChanged();
            return this.cmapBuilders;
        }

        private static int numCMaps(ReadableFontData data) {
            if (data == null) {
                return 0;
            }
            return data.readUShort(Offset.numTables.offset);
        }

        public int numCMaps() {
            return this.getCMapBuilders().size();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.cmapBuilders == null || this.cmapBuilders.size() == 0) {
                return 0;
            }
            boolean variable = false;
            int size = Offset.encodingRecordStart.offset + this.cmapBuilders.size() * Offset.encodingRecordSize.offset;
            for (CMap.Builder<? extends CMap> b : this.cmapBuilders.values()) {
                int cmapSize = b.subDataSizeToSerialize();
                size += Math.abs(cmapSize);
                variable |= cmapSize <= 0;
            }
            return variable ? -size : size;
        }

        @Override
        protected boolean subReadyToSerialize() {
            if (this.cmapBuilders == null) {
                return false;
            }
            for (CMap.Builder<? extends CMap> b : this.cmapBuilders.values()) {
                if (b.subReadyToSerialize()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            int size = newData.writeUShort(Offset.version.offset, this.version());
            int indexOffset = size += newData.writeUShort(Offset.numTables.offset, this.cmapBuilders.size());
            size += this.cmapBuilders.size() * Offset.encodingRecordSize.offset;
            for (CMap.Builder<? extends CMap> b : this.cmapBuilders.values()) {
                indexOffset += newData.writeUShort(indexOffset, b.platformId());
                indexOffset += newData.writeUShort(indexOffset, b.encodingId());
                indexOffset += newData.writeULong(indexOffset, size);
                size += b.subSerialize(newData.slice(size));
            }
            return size;
        }

        @Override
        protected CMapTable subBuildTable(ReadableFontData data) {
            return new CMapTable(this.header(), data, null);
        }

        public Iterator<? extends CMap.Builder<? extends CMap>> iterator() {
            return this.getCMapBuilders().values().iterator();
        }

        public int version() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public CMap.Builder<? extends CMap> newCMapBuilder(CMapId cmapId, ReadableFontData data) throws IOException {
            WritableFontData wfd = WritableFontData.createWritableFontData(data.size());
            data.copyTo(wfd);
            CMap.Builder<CMap> builder = CMap.Builder.getBuilder(wfd, 0, cmapId);
            Map<CMapId, CMap.Builder<? extends CMap>> cmapBuilders = this.getCMapBuilders();
            cmapBuilders.put(cmapId, builder);
            return builder;
        }

        public CMap.Builder<? extends CMap> newCMapBuilder(CMapId cmapId, CMap.CMapFormat cmapFormat) {
            CMap.Builder<CMap> builder = CMap.Builder.getBuilder(cmapFormat, cmapId);
            Map<CMapId, CMap.Builder<? extends CMap>> cmapBuilders = this.getCMapBuilders();
            cmapBuilders.put(cmapId, builder);
            return builder;
        }

        public CMap.Builder<? extends CMap> cmapBuilder(CMapId cmapId) {
            Map<CMapId, CMap.Builder<? extends CMap>> cmapBuilders = this.getCMapBuilders();
            return cmapBuilders.get(cmapId);
        }
    }

    public static interface CMapFilter {
        public boolean accept(CMapId var1);
    }

    public static final class CMapId
    implements Comparable<CMapId> {
        public static final CMapId WINDOWS_BMP = CMapId.getInstance(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value());
        public static final CMapId WINDOWS_UCS4 = CMapId.getInstance(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS4.value());
        public static final CMapId MAC_ROMAN = CMapId.getInstance(Font.PlatformId.Macintosh.value(), Font.MacintoshEncodingId.Roman.value());
        private final int platformId;
        private final int encodingId;

        public static CMapId getInstance(int platformId, int encodingId) {
            return new CMapId(platformId, encodingId);
        }

        private CMapId(int platformId, int encodingId) {
            this.platformId = platformId;
            this.encodingId = encodingId;
        }

        public int platformId() {
            return this.platformId;
        }

        public int encodingId() {
            return this.encodingId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CMapId)) {
                return false;
            }
            CMapId otherKey = (CMapId)obj;
            return otherKey.platformId == this.platformId && otherKey.encodingId == this.encodingId;
        }

        public int hashCode() {
            return this.platformId << 8 | this.encodingId;
        }

        @Override
        public int compareTo(CMapId o) {
            return this.hashCode() - o.hashCode();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("pid = ");
            b.append(this.platformId);
            b.append(", eid = ");
            b.append(this.encodingId);
            return b.toString();
        }
    }

    private class CMapIterator
    implements Iterator<CMap> {
        private int tableIndex = 0;
        private CMapFilter filter;

        private CMapIterator() {
        }

        private CMapIterator(CMapFilter filter) {
            this.filter = filter;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.filter != null) ** GOTO lbl6
            return this.tableIndex < CMapTable.this.numCMaps();
lbl-1000:
            // 1 sources

            {
                if (this.filter.accept(CMapTable.this.cmapId(this.tableIndex))) {
                    return true;
                }
                ++this.tableIndex;
lbl6:
                // 2 sources

                ** while (this.tableIndex < CMapTable.this.numCMaps())
            }
lbl7:
            // 1 sources

            return false;
        }

        @Override
        public CMap next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return CMapTable.this.cmap(this.tableIndex++);
            }
            catch (IOException e) {
                NoSuchElementException newException = new NoSuchElementException("Error during the creation of the CMap.");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a CMap table from an existing font.");
        }
    }

    static enum Offset {
        version(0),
        numTables(2),
        encodingRecordStart(4),
        encodingRecordPlatformId(0),
        encodingRecordEncodingId(2),
        encodingRecordOffset(4),
        encodingRecordSize(8),
        format(0),
        format0Format(0),
        format0Length(2),
        format0Language(4),
        format0GlyphIdArray(6),
        format2Format(0),
        format2Length(2),
        format2Language(4),
        format2SubHeaderKeys(6),
        format2SubHeaders(518),
        format2SubHeader_firstCode(0),
        format2SubHeader_entryCount(2),
        format2SubHeader_idDelta(4),
        format2SubHeader_idRangeOffset(6),
        format2SubHeader_structLength(8),
        format4Format(0),
        format4Length(2),
        format4Language(4),
        format4SegCountX2(6),
        format4SearchRange(8),
        format4EntrySelector(10),
        format4RangeShift(12),
        format4EndCount(14),
        format4FixedSize(16),
        format6Format(0),
        format6Length(2),
        format6Language(4),
        format6FirstCode(6),
        format6EntryCount(8),
        format6GlyphIdArray(10),
        format8Format(0),
        format8Length(4),
        format8Language(8),
        format8Is32(12),
        format8nGroups(8204),
        format8Groups(8208),
        format8Group_startCharCode(0),
        format8Group_endCharCode(4),
        format8Group_startGlyphId(8),
        format8Group_structLength(12),
        format10Format(0),
        format10Length(4),
        format10Language(8),
        format10StartCharCode(12),
        format10NumChars(16),
        format10Glyphs(20),
        format12Format(0),
        format12Length(4),
        format12Language(8),
        format12nGroups(12),
        format12Groups(16),
        format12Groups_structLength(12),
        format12_startCharCode(0),
        format12_endCharCode(4),
        format12_startGlyphId(8),
        format13Format(0),
        format13Length(4),
        format13Language(8),
        format13nGroups(12),
        format13Groups(16),
        format13Groups_structLength(12),
        format13_startCharCode(0),
        format13_endCharCode(4),
        format13_glyphId(8),
        format14Format(0),
        format14Length(2);

        final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

