/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.fontinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataDisplayTable {
    private List<String> header;
    private List<List<String>> data;
    private List<Integer> maxColLengths;
    private List<Align> displayAlignment;
    private int numCols;
    private int numRows;

    public DataDisplayTable(List<String> header) {
        if (header.size() < 1) {
            throw new UnsupportedOperationException("Table must have at least one column");
        }
        this.header = Collections.unmodifiableList(new ArrayList<String>(header));
        this.data = new ArrayList<List<String>>();
        this.numCols = header.size();
        this.numRows = 0;
        this.maxColLengths = new ArrayList<Integer>(this.numCols);
        int i = 0;
        while (i < this.numCols) {
            this.maxColLengths.add(header.get(i).length());
            ++i;
        }
        this.displayAlignment = new ArrayList<Align>(this.numCols);
        i = 0;
        while (i < this.numCols) {
            this.displayAlignment.add(Align.Left);
            ++i;
        }
    }

    public void setAlignment(List<Align> alignment) {
        if (alignment.size() != this.numCols) {
            throw new UnsupportedOperationException("Array is wrong size");
        }
        this.displayAlignment = Collections.unmodifiableList(new ArrayList<Align>(alignment));
    }

    public void add(List<String> row) {
        if (row.size() != this.numCols) {
            throw new UnsupportedOperationException("Array is wrong size");
        }
        this.data.add(Collections.unmodifiableList(new ArrayList<String>(row)));
        ++this.numRows;
        int i = 0;
        while (i < this.numCols) {
            if (row.get(i).length() > this.maxColLengths.get(i)) {
                this.maxColLengths.set(i, row.get(i).length());
            }
            ++i;
        }
    }

    public List<String> getHeader() {
        return this.header;
    }

    public List<List<String>> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public int getNumColumns() {
        return this.numCols;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public List<Integer> getMaxColLengths() {
        return Collections.unmodifiableList(this.maxColLengths);
    }

    public List<Align> getDisplayAlignment() {
        return this.displayAlignment;
    }

    public String prettyString() {
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < this.numCols - 1) {
            output.append(DataDisplayTable.padString(this.header.get(i), this.displayAlignment.get(i), this.maxColLengths.get(i))).append("  ");
            ++i;
        }
        if (this.displayAlignment.get(this.numCols - 1) == Align.Left) {
            output.append(this.header.get(this.numCols - 1));
        } else {
            output.append(DataDisplayTable.padString(this.header.get(this.numCols - 1), this.displayAlignment.get(this.numCols - 1), this.maxColLengths.get(this.numCols - 1)));
        }
        output.append("\n");
        output.append(DataDisplayTable.repeatCharacter('-', this.maxColLengths.get(0)));
        i = 1;
        while (i < this.numCols) {
            output.append("  ").append(DataDisplayTable.repeatCharacter('-', this.maxColLengths.get(i)));
            ++i;
        }
        output.append("\n");
        for (List<String> row : this.data) {
            int i2 = 0;
            while (i2 < this.numCols - 1) {
                output.append(DataDisplayTable.padString(row.get(i2), this.displayAlignment.get(i2), this.maxColLengths.get(i2))).append("  ");
                ++i2;
            }
            if (this.displayAlignment.get(this.numCols - 1) == Align.Left) {
                output.append(row.get(this.numCols - 1));
            } else {
                output.append(DataDisplayTable.padString(row.get(this.numCols - 1), this.displayAlignment.get(this.numCols - 1), this.maxColLengths.get(this.numCols - 1)));
            }
            output.append("\n");
        }
        return output.toString();
    }

    public void prettyPrint() {
        System.out.println(this.prettyString());
    }

    public String csvString() {
        String[] csvArr = this.csvStringArray();
        StringBuilder output = new StringBuilder();
        String[] stringArray = csvArr;
        int n = csvArr.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            output.append(row).append('\n');
            ++n2;
        }
        return output.toString();
    }

    public String[] csvStringArray() {
        String[] output = new String[this.numRows + 1];
        StringBuilder rowString = new StringBuilder(DataDisplayTable.csvFormat(this.header.get(0)));
        int i = 1;
        while (i < this.numCols) {
            rowString.append(",").append(DataDisplayTable.csvFormat(this.header.get(i)));
            ++i;
        }
        output[0] = rowString.toString();
        i = 0;
        while (i < this.numRows) {
            List<String> row = this.data.get(i);
            rowString = new StringBuilder(DataDisplayTable.csvFormat(row.get(0)));
            int j = 1;
            while (j < this.numCols) {
                rowString.append(",").append(DataDisplayTable.csvFormat(row.get(j)));
                ++j;
            }
            output[i + 1] = rowString.toString();
            ++i;
        }
        return output;
    }

    private static String csvFormat(String s) {
        if (s.contains("\"") || s.contains("\n") || s.contains(",")) {
            return "\"" + s.replace("\"", "\"\"") + "\"";
        }
        return s;
    }

    public String toString() {
        StringBuilder debugString = new StringBuilder();
        debugString.append(this.numRows).append("x").append(this.numCols).append(" table, ");
        debugString.append("header=[").append(this.header.get(0));
        int i = 1;
        while (i < this.numCols) {
            debugString.append(", ").append(this.header.get(i));
            ++i;
        }
        debugString.append("]");
        return debugString.toString();
    }

    private static String padString(String s, Align alignment, int minLength) {
        if (alignment == Align.Left) {
            return DataDisplayTable.padRight(s, minLength);
        }
        if (alignment == Align.Right) {
            return DataDisplayTable.padLeft(s, minLength);
        }
        throw new IndexOutOfBoundsException("Invalid alignment");
    }

    private static String padLeft(String s, int minLength) {
        return String.format("%1$" + minLength + "s", s);
    }

    private static String padRight(String s, int minLength) {
        return String.format("%1$-" + minLength + "s", s);
    }

    private static String repeatCharacter(char c, int frequency) {
        StringBuilder output = new StringBuilder(frequency);
        int i = 0;
        while (i < frequency) {
            output.append(c);
            ++i;
        }
        return output.toString();
    }

    public static enum Align {
        Left,
        Right;

    }
}

