/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;

public final class CMapFormat2
extends CMap {
    protected CMapFormat2(ReadableFontData data, CMapTable.CMapId cmapId) {
        super(data, CMap.CMapFormat.Format2.value, cmapId);
    }

    private int subHeaderOffset(int subHeaderIndex) {
        int subHeaderOffset = this.data.readUShort(CMapTable.Offset.format2SubHeaderKeys.offset + subHeaderIndex * FontData.DataSize.USHORT.size());
        return subHeaderOffset;
    }

    private int firstCode(int subHeaderIndex) {
        int subHeaderOffset = this.subHeaderOffset(subHeaderIndex);
        int firstCode = this.data.readUShort(subHeaderOffset + CMapTable.Offset.format2SubHeaderKeys.offset + CMapTable.Offset.format2SubHeader_firstCode.offset);
        return firstCode;
    }

    private int entryCount(int subHeaderIndex) {
        int subHeaderOffset = this.subHeaderOffset(subHeaderIndex);
        int entryCount = this.data.readUShort(subHeaderOffset + CMapTable.Offset.format2SubHeaderKeys.offset + CMapTable.Offset.format2SubHeader_entryCount.offset);
        return entryCount;
    }

    private int idRangeOffset(int subHeaderIndex) {
        int subHeaderOffset = this.subHeaderOffset(subHeaderIndex);
        int idRangeOffset = this.data.readUShort(subHeaderOffset + CMapTable.Offset.format2SubHeaderKeys.offset + CMapTable.Offset.format2SubHeader_idRangeOffset.offset);
        return idRangeOffset;
    }

    private int idDelta(int subHeaderIndex) {
        int subHeaderOffset = this.subHeaderOffset(subHeaderIndex);
        int idDelta = this.data.readShort(subHeaderOffset + CMapTable.Offset.format2SubHeaderKeys.offset + CMapTable.Offset.format2SubHeader_idDelta.offset);
        return idDelta;
    }

    public int bytesConsumed(int character) {
        int highByte = character >> 8 & 0xFF;
        int offset = this.subHeaderOffset(highByte);
        if (offset == 0) {
            return 1;
        }
        return 2;
    }

    @Override
    public int glyphId(int character) {
        if (character > 65535) {
            return 0;
        }
        int highByte = character >> 8 & 0xFF;
        int lowByte = character & 0xFF;
        int offset = this.subHeaderOffset(highByte);
        if (offset == 0) {
            lowByte = highByte;
            highByte = 0;
        }
        int firstCode = this.firstCode(highByte);
        int entryCount = this.entryCount(highByte);
        if (lowByte < firstCode || lowByte >= firstCode + entryCount) {
            return 0;
        }
        int idRangeOffset = this.idRangeOffset(highByte);
        int pLocation = offset + CMapTable.Offset.format2SubHeader_idRangeOffset.offset + idRangeOffset + (lowByte - firstCode) * FontData.DataSize.USHORT.size();
        int p = this.data.readUShort(pLocation);
        if (p == 0) {
            return 0;
        }
        if (offset == 0) {
            return p;
        }
        int idDelta = this.idDelta(highByte);
        return (p + idDelta) % 65536;
    }

    @Override
    public int language() {
        return this.data.readUShort(CMapTable.Offset.format2Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CMap.CharacterIterator(0, 65535);
    }

    public static class Builder
    extends CMap.Builder<CMapFormat2> {
        protected Builder(WritableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readUShort(offset + CMapTable.Offset.format2Length.offset)), CMap.CMapFormat.Format2, cmapId);
        }

        protected Builder(ReadableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readUShort(offset + CMapTable.Offset.format2Length.offset)), CMap.CMapFormat.Format2, cmapId);
        }

        @Override
        protected CMapFormat2 subBuildTable(ReadableFontData data) {
            return new CMapFormat2(data, this.cmapId());
        }
    }
}

