/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype.component;

import com.google.typography.font.sfntly.table.core.PostScriptTable;
import com.google.typography.font.sfntly.table.opentype.component.GlyphGroup;
import com.google.typography.font.sfntly.table.opentype.component.GlyphList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

class RuleSegment
extends LinkedList<GlyphGroup> {
    private static final long serialVersionUID = 4563803321401665616L;

    RuleSegment() {
    }

    RuleSegment(GlyphGroup glyphGroup) {
        this.addInternal(glyphGroup);
    }

    RuleSegment(int glyph) {
        GlyphGroup glyphGroup = new GlyphGroup(glyph);
        this.addInternal(glyphGroup);
    }

    RuleSegment(GlyphList glyphs) {
        Iterator iterator = glyphs.iterator();
        while (iterator.hasNext()) {
            int glyph = (Integer)iterator.next();
            GlyphGroup glyphGroup = new GlyphGroup(glyph);
            this.addInternal(glyphGroup);
        }
    }

    @Override
    boolean add(int glyph) {
        GlyphGroup glyphGroup = new GlyphGroup(glyph);
        return this.addInternal(glyphGroup);
    }

    @Override
    public boolean addAll(Collection<? extends GlyphGroup> glyphGroups) {
        for (GlyphGroup glyphGroup : glyphGroups) {
            if (glyphGroup != null) continue;
            throw new IllegalArgumentException("Null GlyphGroup not allowed");
        }
        return super.addAll(glyphGroups);
    }

    private boolean addInternal(GlyphGroup glyphGroup) {
        if (glyphGroup == null) {
            throw new IllegalArgumentException("Null GlyphGroup not allowed");
        }
        return super.add(glyphGroup);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GlyphGroup glyphGroup : this) {
            sb.append(glyphGroup.toString());
        }
        return sb.toString();
    }

    String toString(PostScriptTable post) {
        StringBuilder sb = new StringBuilder();
        for (GlyphGroup glyphGroup : this) {
            sb.append(glyphGroup.toString(post));
            sb.append(" ");
        }
        return sb.toString();
    }
}

