/******************************************************************************
  SCI0_UART.c
UARTģʽSCI0ļ
    ߣ
    V1.0
    ڣ2016.11.17
******************************************************************************/

#include "SCI0_UART.h"

SCI0TxBufferStruct  SCI0TxBuffer;

/******************************************************************************
SCI0_UART_Byte_Rx
  ܣUARTֽڽպ
        ڸúϲĽպ,ϲָʾѽյ,Data
  Dataյ
ֵ
******************************************************************************/
void SCI0_UART_Byte_Rx(uint8_t Data)
{
  uint8_t Parity;

  Parity = SCI0SR1_PF;
}

/******************************************************************************
SCI0_UART_Byte_Tx
  ܣUARTֽڷͺ
        һֽ,ô˺֮ǰ,ȷBufferǿյ,
        ݵĶʧ
  DataҪ͵
ֵ
******************************************************************************/
void SCI0_UART_Byte_Tx(uint8_t Data)
{
  SCI0DRL = Data;
}

/******************************************************************************
SCI0_UART_Block_Tx
  ܣUART鷢ͺ
        Nֽ,ô˺֮ǰ,ȷBufferǿյ,
        ݵĶʧ
  DataҪ͵
        Len Ҫ͵ݳ
ֵ
******************************************************************************/
void SCI0_UART_Block_Tx(uint8_t *Data, uint8_t Len)
{
  uint8_t i;

  SCI0TxBuffer.Len = Len - 1;
  for (i = 0; i < Len; i++)
    SCI0TxBuffer.Data[Len - i - 1] = Data[i];

  SCI0DRL = SCI0TxBuffer.Data[SCI0TxBuffer.Len];  //͵һֽ
  SCI0CR2_TIE = 1;                                //ʹܷBufferж
}

/******************************************************************************
SCI0_UART_Get_Tx_Buffer_Status
  ܣȡBufferĵǰ״̬
  
ֵ0 - Ŀǰûڷ
        1 - Ŀǰڷ
******************************************************************************/
uint8_t SCI0_UART_Get_Tx_Buffer_Status(void)
{
  if ((SCI0SR1_TDRE != 0) && (SCI0TxBuffer.Len == 0))
    return 0;
  return 1;
}

/******************************************************************************
SCI0_UART_Init
  ܣʼSCI0ΪUARTģʽ,SCI0_UART.hõUART
  
ֵ
******************************************************************************/
void SCI0_UART_Init(void)                          ////////////Ա
{
  uint8_t m16;
  m16 = 104;
  SCI0BDH = (INT8U)((m16 >> 8));
  SCI0BDL = (INT8U)(m16);
  SCI0CR1 = 0x00;  // 8 Data Bits, 1 Start Bit, 1 Stop Bit, No Parity
  SCI0CR2 = 0x0C;  // Enable Tx and Rx
}

#pragma CODE_SEG __NEAR_SEG NON_BANKED   	//жϺFLASHķǷҳ

/******************************************************************************
SCI0_ISR
  ܣSCI0жϷ,ڽ
  
ֵ
******************************************************************************/
void interrupt SCI0_ISR(void)
{
}

#pragma CODE_SEG DEFAULT
