/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;

public class OTFBasicEditingTests
extends TestCase {
    private static final File TEST_FONT_FILE = TestFont.TestFontNames.OPENSANS.getFile();

    public OTFBasicEditingTests(String name) {
        super(name);
    }

    public void testBuildersToTables() throws Exception {
        Font[] originalFont = TestFontUtils.loadFont(TEST_FONT_FILE);
        long originalChecksum = originalFont[0].checksum();
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(TEST_FONT_FILE);
        HashSet<Integer> builderTags = new HashSet<Integer>(fontBuilder.tableBuilderMap().keySet());
        FontHeaderTable.Builder headerBuilder = (FontHeaderTable.Builder)fontBuilder.getTableBuilder(Tag.head);
        long modDate = headerBuilder.modified();
        headerBuilder.setModified(modDate + 1L);
        Font font = fontBuilder.build();
        Iterator<? extends Table> iter = font.iterator();
        while (iter.hasNext()) {
            Table table = iter.next();
            Header header = table.header();
            OTFBasicEditingTests.assertTrue(builderTags.contains(header.tag()));
            builderTags.remove(header.tag());
        }
        OTFBasicEditingTests.assertTrue(builderTags.isEmpty());
        FontHeaderTable header = (FontHeaderTable)font.getTable(Tag.head);
        long afterModDate = header.modified();
        OTFBasicEditingTests.assertEquals(modDate + 1L, afterModDate);
        long fontChecksum = font.checksum();
        OTFBasicEditingTests.assertEquals(originalChecksum + 1L, fontChecksum);
    }

    public void testChecksum() throws Exception {
        long originalChecksum;
        Font originalFont = TestFontUtils.loadFont(TEST_FONT_FILE)[0];
        long expectedChecksum = originalChecksum = originalFont.checksum();
        long originalChecksumAdjustment = ((FontHeaderTable)originalFont.getTable(Tag.head)).checkSumAdjustment();
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(TEST_FONT_FILE);
        for (int tag : fontBuilder.tableBuilderMap().keySet()) {
            Table.Builder<? extends Table> tableBuilder = fontBuilder.getTableBuilder(tag);
            WritableFontData data = tableBuilder.data();
            int l = data.readULongAsInt(0);
            data.writeULong(0, l + 1);
            tableBuilder.setData(data);
            ++expectedChecksum;
        }
        Font builtFont = fontBuilder.build();
        long builtChecksum = builtFont.checksum();
        OTFBasicEditingTests.assertEquals(expectedChecksum, builtChecksum);
        FontHeaderTable header = (FontHeaderTable)builtFont.getTable(Tag.head);
        long headerAdjustment = 2981146554L - builtChecksum & 0xFFFFFFFFFFFFFFFFL;
        long checksumAdjustment = header.checkSumAdjustment();
        OTFBasicEditingTests.assertEquals(headerAdjustment, header.checkSumAdjustment());
    }
}

