/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.sfntly.table.core.PostScriptTable;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import com.google.typography.font.tools.subsetter.RenumberingSubsetter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.TestCase;

public class RenumberingSubsetTest
extends TestCase {
    private static final File fontFile = TestFont.TestFontNames.OPENSANS.getFile();
    Font dstFont;

    @Override
    public void setUp() throws IOException {
        Font srcFont = TestFontUtils.loadFont(fontFile)[0];
        FontFactory factory = FontFactory.getInstance();
        RenumberingSubsetter subsetter = new RenumberingSubsetter(srcFont, factory);
        ArrayList<Integer> glyphs = new ArrayList<Integer>();
        glyphs.add(0);
        glyphs.add(67);
        glyphs.add(68);
        glyphs.add(162);
        subsetter.setGlyphs(glyphs);
        HashSet<Integer> removeTables = new HashSet<Integer>();
        removeTables.add(Tag.GPOS);
        removeTables.add(Tag.GSUB);
        removeTables.add(Tag.kern);
        subsetter.setRemoveTables(removeTables);
        Font.Builder dstFontBuilder = subsetter.subset();
        this.dstFont = dstFontBuilder.build();
    }

    public void testNumGlyphs() {
        MaximumProfileTable maxpTable = (MaximumProfileTable)this.dstFont.getTable(Tag.maxp);
        RenumberingSubsetTest.assertEquals(4, maxpTable.numGlyphs());
        LocaTable locaTable = (LocaTable)this.dstFont.getTable(Tag.loca);
        RenumberingSubsetTest.assertEquals(4, locaTable.numGlyphs());
    }

    public void testCmap() throws IOException {
        CMapTable cmapTable = (CMapTable)this.dstFont.getTable(Tag.cmap);
        RenumberingSubsetTest.assertEquals(1.0f, (float)cmapTable.numCMaps(), 1.0f);
        CMap cmap = cmapTable.cmap(0);
        RenumberingSubsetTest.assertEquals(CMapTable.CMapId.WINDOWS_BMP, cmap.cmapId());
        RenumberingSubsetTest.assertEquals(1, cmap.glyphId(96));
        RenumberingSubsetTest.assertEquals(2, cmap.glyphId(97));
        RenumberingSubsetTest.assertEquals(3, cmap.glyphId(224));
    }

    public void testHorizontalMetrics() {
        HorizontalMetricsTable hmtxTable = (HorizontalMetricsTable)this.dstFont.getTable(Tag.hmtx);
        RenumberingSubsetTest.assertEquals(1229, hmtxTable.advanceWidth(0));
        RenumberingSubsetTest.assertEquals(193, hmtxTable.leftSideBearing(0));
        RenumberingSubsetTest.assertEquals(1182, hmtxTable.advanceWidth(1));
        RenumberingSubsetTest.assertEquals(393, hmtxTable.leftSideBearing(1));
        RenumberingSubsetTest.assertEquals(1139, hmtxTable.advanceWidth(2));
        RenumberingSubsetTest.assertEquals(94, hmtxTable.leftSideBearing(2));
        RenumberingSubsetTest.assertEquals(1139, hmtxTable.advanceWidth(3));
        RenumberingSubsetTest.assertEquals(94, hmtxTable.leftSideBearing(3));
    }

    public void testHorizontalHeader() {
        HorizontalHeaderTable hheaTable = (HorizontalHeaderTable)this.dstFont.getTable(Tag.hhea);
        RenumberingSubsetTest.assertEquals(3, hheaTable.numberOfHMetrics());
        RenumberingSubsetTest.assertEquals(1229, hheaTable.advanceWidthMax());
    }

    public void testPostScriptTable() {
        PostScriptTable postTable = (PostScriptTable)this.dstFont.getTable(Tag.post);
        RenumberingSubsetTest.assertEquals(4, postTable.numberOfGlyphs());
        RenumberingSubsetTest.assertEquals(".notdef", postTable.glyphName(0));
        RenumberingSubsetTest.assertEquals("grave", postTable.glyphName(1));
        RenumberingSubsetTest.assertEquals("a", postTable.glyphName(2));
        RenumberingSubsetTest.assertEquals("agrave", postTable.glyphName(3));
    }

    public void testSimpleGlyph1() {
        Glyph glyph = RenumberingSubsetTest.getGlyph(this.dstFont, 1);
        RenumberingSubsetTest.assertEquals((Object)Glyph.GlyphType.Simple, (Object)glyph.glyphType());
        SimpleGlyph simple = (SimpleGlyph)glyph;
        RenumberingSubsetTest.assertEquals(1, simple.numberOfContours());
        RenumberingSubsetTest.assertEquals(10, simple.numberOfPoints(0));
        RenumberingSubsetTest.assertEquals(19, simple.instructionSize());
        RenumberingSubsetTest.assertTrue(simple.onCurve(0, 0));
        RenumberingSubsetTest.assertEquals(786, simple.xCoordinate(0, 0));
        RenumberingSubsetTest.assertEquals(1241, simple.yCoordinate(0, 0));
        RenumberingSubsetTest.assertTrue(simple.onCurve(0, 1));
        RenumberingSubsetTest.assertEquals(676, simple.xCoordinate(0, 1));
        RenumberingSubsetTest.assertEquals(1241, simple.yCoordinate(0, 1));
        RenumberingSubsetTest.assertTrue(simple.onCurve(0, 9));
        RenumberingSubsetTest.assertEquals(786, simple.xCoordinate(0, 9));
        RenumberingSubsetTest.assertEquals(1266, simple.yCoordinate(0, 9));
        RenumberingSubsetTest.assertEquals(0, simple.padding());
    }

    public void testSimpleGlyph2() {
        Glyph glyph = RenumberingSubsetTest.getGlyph(this.dstFont, 2);
        RenumberingSubsetTest.assertEquals((Object)Glyph.GlyphType.Simple, (Object)glyph.glyphType());
        SimpleGlyph simple = (SimpleGlyph)glyph;
        RenumberingSubsetTest.assertEquals(2, simple.numberOfContours());
        RenumberingSubsetTest.assertEquals(26, simple.numberOfPoints(0));
        RenumberingSubsetTest.assertEquals(11, simple.numberOfPoints(1));
        RenumberingSubsetTest.assertEquals(71, simple.instructionSize());
        RenumberingSubsetTest.assertEquals(0, simple.padding());
    }

    public void testCompositeGlyph() {
        Glyph glyph = RenumberingSubsetTest.getGlyph(this.dstFont, 3);
        RenumberingSubsetTest.assertEquals((Object)Glyph.GlyphType.Composite, (Object)glyph.glyphType());
        CompositeGlyph composite = (CompositeGlyph)glyph;
        RenumberingSubsetTest.assertEquals(2, composite.numGlyphs());
        RenumberingSubsetTest.assertEquals(2, composite.glyphIndex(0));
        RenumberingSubsetTest.assertEquals(0, composite.argument1(0));
        RenumberingSubsetTest.assertEquals(0, composite.argument2(0));
        RenumberingSubsetTest.assertEquals(1, composite.glyphIndex(1));
        RenumberingSubsetTest.assertEquals(-114, composite.argument1(1));
        RenumberingSubsetTest.assertEquals(0, composite.argument2(1));
        RenumberingSubsetTest.assertEquals(8, composite.instructionSize());
        RenumberingSubsetTest.assertEquals(0, composite.padding());
    }

    public void testTablesRemoved() {
        RenumberingSubsetTest.assertNull(this.dstFont.getTable(Tag.GPOS));
        RenumberingSubsetTest.assertNull(this.dstFont.getTable(Tag.GSUB));
        RenumberingSubsetTest.assertNull(this.dstFont.getTable(Tag.kern));
    }

    private static Glyph getGlyph(Font font, int glyphId) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyfTable = (GlyphTable)font.getTable(Tag.glyf);
        int offset = locaTable.glyphOffset(glyphId);
        int length = locaTable.glyphLength(glyphId);
        return glyfTable.glyph(offset, length);
    }
}

