/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.testutils;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.ibm.icu.charset.CharsetICU;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class TestUtils {
    private static final char EXTENSION_SEPARATOR = '.';

    private TestUtils() {
    }

    public static boolean equals(byte[] b1, int offset1, byte[] b2, int offset2, int length) {
        int i = 0;
        while (i < length) {
            if (b1[i + offset1] != b2[i + offset2]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static FileChannel createFileChannelForWriting(File file) throws IOException {
        TestUtils.createNewFile(file);
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        return raf.getChannel();
    }

    public static void createNewFile(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
    }

    public static OutputStream createOutputStream(File file) throws IOException {
        TestUtils.createNewFile(file);
        return new FileOutputStream(file);
    }

    public static String dumpLongAsString(int i) {
        String s;
        byte[] b = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        try {
            s = new String(b, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Guaranteed encoding US-ASCII missing.");
        }
        return s;
    }

    public static long checkSum(byte[] b, int offset, int length) {
        long checkSum = 0L;
        int i = offset;
        while (i < length) {
            int j = 0;
            while (j < 4) {
                if (j + i < length) {
                    checkSum += (long)((b[j + i] & 0xFF) << 24 - 8 * j);
                }
                ++j;
            }
            i += 4;
        }
        return checkSum & 0xFFFFFFFFL;
    }

    public static int encodeOneChar(CharsetEncoder encoder, int uchar) {
        ByteBuffer bb = ByteBuffer.allocate(10);
        CharBuffer cb = CharBuffer.wrap(new char[]{(char)uchar});
        CoderResult result = encoder.encode(cb, bb, true);
        if (result.isError()) {
            return 0;
        }
        if (bb.position() > 4) {
            return 0;
        }
        int encChar = 0;
        int position = 0;
        while (position < bb.position()) {
            encChar <<= 8;
            encChar |= bb.get(position) & 0xFF;
            ++position;
        }
        return encChar;
    }

    public static CharsetEncoder getEncoder(String charsetName) {
        if (charsetName == null || charsetName.equals("")) {
            return null;
        }
        Charset cs = CharsetICU.forNameICU(charsetName);
        return cs.newEncoder();
    }

    public static String extension(File file) {
        String ext = file.getName();
        int extPosition = ext.lastIndexOf(46);
        if (extPosition == -1) {
            return "";
        }
        return ext.substring(extPosition);
    }

    public static byte[] readFile(File file) throws IOException {
        int length = (int)file.length();
        byte[] b = new byte[length];
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            while (length > 0) {
                length -= fis.read(b, b.length - length, length);
            }
            byte[] byArray = b;
            return byArray;
        }
    }

    public static boolean equals(int offset1, ReadableFontData rfd1, int offset2, ReadableFontData rfd2, int length) {
        int i = 0;
        while (i < length) {
            int b2;
            int b1 = rfd1.readByte(i + offset1);
            if (b1 != (b2 = rfd2.readByte(i + offset2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsNullOk(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

