
#ifndef _GUI_H_
#define _GUI_H_

#include "Data_Processor.h"
#include "CRG.h"
#include "Non_volatile_Memorys.h"
#include "System_Status_Monitor.h"
#include "TFT_LCD.h"
#include "stdint.h"
#include "IO_Manager.h"
#include "Popup_List.h"
#include "Telltales.h"
#include "Unit_Conv.h"
#include "Popup_Scheduler.h"
#include "Gauges.h"       //----hyq--20190430

//#include "Radar_R3.h"
extern uint16_t  Vspeed_Seg_Disp[];
//extern uint16_t  Espeed_Seg_Disp[];
/******************************************************************************
ʾģʽ
******************************************************************************/

#define   GUI_DISP_MODE_NORMAL              0x00    //
#define   GUI_DISP_MODE_NEGATIVE            0x01    //
#define   GUI_DISP_MODE_BLANK               0x02    //հ
#define   GUI_DISP_MODE_INVALID             0x03    //Ч

/*** ȫֱ ***/
extern uint8_t  DataAmbientTempDispMode;
extern uint8_t  DataAmbientTemp;
extern uint8_t  DataAmbientTempUnit;

#define  DATA_AMBIENT_TEMP_DISP_MODE        DataAmbientTempDispMode
#define  DATA_AMBIENT_TEMP                  DataAmbientTemp
#define  DATA_AMBIENT_TEMP_UNIT             DataAmbientTempUnit

/***************************гʱ***************************************/
//ʱ
static const uint16_t GUIBGClockHourPosX[]   = {288, 271};
static const uint16_t GUIBGClockMinutePosX[] = {330, 313};
//ѹ
static const uint16_t GUIBatPosX[]  = {95, 82, 69};
//¶
static const uint16_t GUITempPosX[] = {485, 468};
//ѹ
static const uint16_t GUIVolPosX[]  = {198, 187, 176};
//
static const uint16_t GUICurPosX[]  = {88, 76, 64};
//ODO
static const uint16_t GUIODOPosX[]  = {174, 157, 140, 123, 106, 89};
//TRIP
static const uint16_t GUITirpPosX[] = {717, 692, 675, 658};

static const uint16_t GUIBGClockHour25PosY[]   = {147, 188};
static const uint16_t GUIBGClockMinute25PosY[] = {41, 82};

static const uint16_t GUIBGClockSecondPosy[] = {135, 155}; //
//
static const uint16_t GUIVehPosX3[] = {397, 340, 283};
static const uint16_t GUIVehPosX2[] = {120, 78};
static const uint16_t GUIVehPosX1[] = {340};
//ת
static const uint16_t GUIEngPosX[]  = {407, 356};
//OFF 
static const uint16_t GUICharging[] = {49, 41, 33};

static const uint16_t GUIFuelAvePosy[] = {23, 112, 181};

//
static const uint16_t GUIDTEPosX3[] = {321, 302, 282, 262};

//ƽͺ
static const uint16_t GUIRAFCPosX[]  = {406, 376, 356};
//˲ʱͺ
static const uint16_t GUICurONPosX3[] = {505, 475, 455};
//
static const uint16_t GUICurONPosX2[] = {407, 373};
//ADAS
static const uint16_t GUIADASPosX[] = {286, 271};
//̥ѹ
static const uint16_t GUICurTPLPosX2[] = {309, 289};
//̥ѹ
static const uint16_t GUICurTPRPosX2[] = {462, 442};
//̥
static const uint16_t GUICurTTLPosX3[] = {309, 296};
//̥
static const uint16_t GUICurTTRPosX3[] = {461, 449};
/*************************************************************************
гб
*************************************************************************/
#define   GUI_DRIVE_INFO_AVG_FUEL_CONS      0x00
#define   GUI_DRIVE_INFO_INST_FUEL_CONS     0x01
#define   GUI_DRIVE_INFO_DTE                0x02
#define   GUI_DRIVE_INFO_DRIVING_TIME       0x03
#define   GUI_DRIVE_INFO_TPMS               0x04
#define   GUI_DRIVE_INFO_WARNING            0x05

#define   DATA_GEAR_P1                      0x01
#define   DATA_GEAR_R1                      0x02
#define   DATA_GEAR_N1                      0x03
#define   DATA_GEAR_D1                      0x04
#define   DATA_GEAR_S1                      0xF3
#define   DATA_GEAR_L1                      0xF4
#define   DATA_GEAR_VALID                   0xFF

#define   DATA_GEAR_11                      0x01
#define   DATA_GEAR_21                      0x02
#define   DATA_GEAR_31                      0x03
#define   DATA_GEAR_41                      0x04
#define   DATA_GEAR_51                      0x05
#define   DATA_GEAR_61                      0x06

/*** ʾ״̬ṹ ***/
typedef struct
{
  uint8_t Warning;
  uint8_t PressureStatus;
  uint8_t TemperatureStatus;
} GUITPMSTireStruct;

/*** ʾ״̬ ***/
#define   GUI_TPMS_DIGIT_NORMAL             0x00
#define   GUI_TPMS_DIGIT_INVALID            0x01
#define   GUI_TPMS_DIGIT_BLANK              0x02
#define   GUI_TPMS_DIGIT_RED                0x80

/*** ʾʽ ***/
#define   GUI_TPMS_NO_WARNING               0x00
#define   GUI_TPMS_WARNING_WITH_DIGIT       0x01
#define   GUI_TPMS_WARNING_WITHOUT_DIGIT    0x02

/*** бṹ ***/
typedef struct
{
  uint16_t  Text;
  uint16_t  X13;
  uint16_t  Y13;
} GUITPMSTextStruct;

/*===============================================================================
                             TPMS״̬б
---------------------------------------------------------------------------------
               |                                |
           |                        |
               |                                | x | y
---------------------------------------------------------------------------------*/

/*************************************************************************
̥ѹѧϰģʽ
*************************************************************************/
 #define Learnfailed   0
 #define Learning      1
 #define Learnfanish   2
/******************************************************************************

******************************************************************************/
#define DIGIT_FONT_TIME			         SN_NB_16_00_png            //ʱʾ
#define DIGIT_FONT_VEHICLE           SN_NB_55_00_png            //
#define DIGIT_FONT_ENGINE            SN_NB_32_5_00_png          //ת
#define DIGIT_FONT_DTE               SN_NB_17_00_png            //
/******************************************************************************

******************************************************************************/
typedef struct
{
  uint8_t Status;
  uint8_t FrameCnt;
  uint8_t Timer;
} GUIAnimationPlayStruct;

/******************************************************************************

******************************************************************************/
typedef struct
{
  uint16_t       HImage;     //ᳵͼƬ/ֶ
  uint16_t       SImage;
} GUIGeneralPopupStruct;

/*typedef struct
{
  const uint16_t *pText;    //
  uint16_t       HImage;    //ᳵͼƬ
  //uint16_t       SImage;    //ᳵͼƬ
}GUIGeneralPopupStruct;   */                                      
/*===============================================================================================
                                       Ϣ
-------------------------------------------------------------------------------------------------
          *          |                      |  | Ӣ
-----------------------------------------------------------------------------------------------*/
static const uint16_t  GUIPopupTextPosX[] =    {  265,   136, };
static const uint16_t  GUIPopupTextPosY[] =    {  140,    48, };

static const uint16_t  GUIPopupTextcanPosX[] = {  199,    23, };
static const uint16_t  GUIPopupTextcanPosY[] = {  32,    130, };

static const uint16_t  GUIPopupTextwenziPosX[] = { 136,    23, };
static const uint16_t  GUIPopupTextwenziPosY[] = {  48,   130, };
/*===========================================================================================================*/

/*************************************************************************************************************
ʾ      hyq
*************************************************************************************************************/
static const GUIGeneralPopupStruct GUIGeneralPopupTable[] =
{
  /* |            ͼƬ              |    |                            |*/
  // { 0,                                                    0 },                                         
  // { 0,                                                    0 },                                         
  // { 0,                                                    0 },                          
  // { 0,                                                    0 },           
  // { 0,                                                    0 },            
  // { 0,                                                    0 },            
  // { 0,                                                    0 },            
  // { 0,                                                    0 },            
  // { 0,                                                    0 },                                     
  // { 0,                                                    0 },                                     
  // { 0,                                                    0 }, 
  { SN_ALARM_14_png,                                   0xFF },
  { SN_ALARM_13_png,                                   0xFF },
  { SN_ALARM_20_png,                                   0xFF },
  { SN_ALARM_19_png,                                   0xFF },
  { SN_ALARM_10_png,                                   0xFF },
  { SN_ALARM_07_png,                                   0xFF }, //6
  { SN_ALARM_11_png,                                   0xFF }, 
  { SN_ALARM_17_png,                                   0xFF }, 
  { SN_ALARM_09_png,                                   0xFF },
  { SN_ALARM_15_png,                                   0xFF },
  
  { SN_ALARM_25_png,                        SN_ALARM_22_png },  
  { SN_ALARM_12_png,                                   0xFF },   
  { SN_qingcaixiashacheshifangzhuche_png,              0xFF }, 
  { SN_GasPressLow_png,                                0xFF }, 
  { SN_running_staus_err_png,                          0xFF },                                
  /*==========================================================================================================*/
};
/***************************************Ӧú***********************************************************/
void Clear_TFT(void);
//----
void GUI_Animation_Frame_Display(uint8_t Frame);
//----ʱʾ    
void GUI_BG_Clock_Display(uint8_t Mode);
void GUI_BG_TEMP_Display(uint8_t Mode);
void GUI_BG_Gear_Alarm_Display(uint8_t Mode);      
void GUI_BG_Gear_Display(uint8_t Mode);     
void GUI_BG_TRIP_A_Display(uint8_t ValidA, uint16_t TripA, uint8_t TripA_Mode) ;
void GUI_BG_ODO_Display(uint8_t Valid, uint32_t Mileage) ;

void GUI_BG_Oil_Temp_Display(uint8_t Mode, uint8_t Temp);
void GUI_Cruise_SET(uint8_t Speednum);
void GUI_General_Digit_Display(uint32_t Digit, uint16_t Font, uint8_t Len, uint8_t Blank, uint8_t Layer, const uint16_t *px, uint16_t y, uint8_t Scale);
//void GUI_General_Digit_Display(uint32_t Digit, uint16_t Font, uint8_t Len, uint8_t Blank, uint8_t Layer, const uint16_t x, uint16_t *py, uint8_t Scale);
/******************************************************************************************************/
void GUI_General_Popup_Display(uint8_t PopupID);
void GUI_General_Charging_Popup_Display(uint8_t PopupID);
void GUI_RADAR_Display(uint8_t PopupID);
void GUI_HOOVES_Display(uint8_t PopupMsg);
void GUI_Door_Open_Display(uint8_t PwrMode, uint8_t PopupMsg);
/****************************************г********************************************************/
void GUI_BG_Vehicle_Display(uint8_t SegNum);
void SEG_LCD_Vehicle_Speed_Num_Display(uint16_t Value);

void GUI_BG_Engine_Display(uint8_t SegNum);
void SEG_LCD_Engine_Speed_Num_Display(uint16_t Value);

void GUI_BG_GAS1_Display(uint8_t SegNum);
void GUI_BG_GAS2_Display(uint8_t SegNum);

 void  GUI_TPMS_Display(uint8_t PopupID);
/********************************************************************************************************/

void Gauges_VSpeed_LCD_Status(void);
void Gauges_ESpeed_LCD_Status(void);
void Gauges_GAS1_LCD_Status(void);
void Gauges_GAS2_LCD_Status(void);
void Telltale_LCD_Display(void);
void Menu1_1_Display(void);
void Menu2_3_Display(void);
void Menu2_4_Display(void);
void GUI_ADAS_Display(void);
#endif