/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import junit.framework.TestCase;

public class HheaTests
extends TestCase {
    public void testAdvanceWidthMax() throws Exception {
        FontFactory factory = FontFactory.getInstance();
        Font.Builder fontBuilder = factory.newFontBuilder();
        HorizontalHeaderTable.Builder hheaBuilder = (HorizontalHeaderTable.Builder)fontBuilder.newTableBuilder(Tag.hhea);
        hheaBuilder.setAdvanceWidthMax(1234);
        Font font = fontBuilder.build();
        HorizontalHeaderTable hheaTable = (HorizontalHeaderTable)font.getTable(Tag.hhea);
        HheaTests.assertEquals(1234, hheaTable.advanceWidthMax());
    }

    public void testNumHMetrics() throws Exception {
        FontFactory factory = FontFactory.getInstance();
        Font.Builder fontBuilder = factory.newFontBuilder();
        HorizontalHeaderTable.Builder hheaBuilder = (HorizontalHeaderTable.Builder)fontBuilder.newTableBuilder(Tag.hhea);
        hheaBuilder.setNumberOfHMetrics(12);
        Font font = fontBuilder.build();
        HorizontalHeaderTable hheaTable = (HorizontalHeaderTable)font.getTable(Tag.hhea);
        HheaTests.assertEquals(12, hheaTable.numberOfHMetrics());
    }
}

