#ifndef _NM_PROTOCOL_DEF_H_
#define _NM_PROTOCOL_DEF_H_

typedef union {
	struct {
		unsigned char DestID     :8;
		unsigned char Opcode     :8;
		unsigned char NM_Data0  :8;
		unsigned char NM_Data1  :8;
		unsigned char NM_Data2  :8;
		unsigned char NM_Data3  :8;
		unsigned char Reserved0  :8;
		unsigned char Reserved1  :8;
		unsigned char SourceID   :8;
		unsigned char ProceF     :8;
	}bits;
	unsigned char msg[10];
}_NMPDU;

typedef struct {
	unsigned char NMactive;
	unsigned char bussleep;
	unsigned char BusOffEvent; //bus off emerge set 1 to BusOffEvent
	unsigned char WakeupEvent; //Wakeup
	unsigned char APPactive;
}_NetWorkStatus;

typedef struct {
	unsigned char ind;
	unsigned char ack;
}_SleepStatus;

typedef struct {
	unsigned char limphome;
	unsigned char stable;
}_MarkerStatus;

  
typedef struct {
	unsigned int OverTmaxTime;
	unsigned int TmaxTime;
	
	unsigned int OverTtypTime;
	unsigned int TtypTime;
	
	unsigned int OverTwbsTime;
	unsigned int TwbsTime;
	
	unsigned int OverSleepTime;
	unsigned int SleepTime;
	
	unsigned char TtypEnable;
	
	unsigned char TmaxEnable;
	
	unsigned char TwbsEnable;
	
	unsigned char SleepEnable;
	
	unsigned int NM_CheckTime;
}_NM_TimeInfo;

#endif
