/****************************************************************************************************************************************************
    GPIO.h
  GPIOӳ估GPIOʼͷļ
      ߣ
      V1.0
      ڣ2016.11.1
 ****************************************************************************************************************************************************/
#ifndef _GPIO_H_
#define _GPIO_H_

#include "stdint.h"
#include "mc9s12xhy128.h"

/****************************************************************************************************************************************************
  GPIOӳ
 ****************************************************************************************************************************************************/

/*===================================================================================================================================================
  PORTA ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      |         ˿       |    |    |  ֵ    |  ˵
  ===================================================================================================================================================*/
#define     LINE_IN_Brake_Fluid         PORTA_PA0    // 87       IN 	    0         ƶϼ
#define     LED_LOW_BATTERY_R           PORTA_PA1    // 88       OUT	    0         007ŵ
#define     LED_CRUISE_G                PORTA_PA2    // 89       OUT	    0         008Ѳָʾ
#define     LED_EBD_Y                   PORTA_PA3    // 90       OUT	    0         009EBDϵ-ƶ()
#define     LED_SOC_Y                   PORTA_PA4    // 91       OUT	    0         010ߵ
#define     LED_PARK_R                  PORTA_PA5    // 92       OUT	    0         011פƶ
#define     LED_Charging_B              PORTA_PA6    // 93       OUT	    0         012س״̬
#define     LED_EX_BREAK_G              PORTA_PA7    // 94       OUT	    0         013е

/*===================================================================================================================================================
  PORTB ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ    |  ˵
  ===================================================================================================================================================*/
//#define    N.C.                      PORTB_PB0  	 // 86       OUT	    0        
//#define    N.C.                      PORTB_PB1  	 // 95       OUT	    0        
#define     EEPROM_SCL		              PORTB_PB2    // 96       IN	      0         EEPROM SDAź
#define     EEPROM_SDA					        PORTB_PB3    // 97       IN       0         EEPROM SCLź
//#define    N.C.                      PORTB_PB4  	 // 100      OUT	    0        
//#define    N.C.                      PORTB_PB5  	 // 101      OUT	    0       
//#define    N.C.                      PORTB_PB6  	 // 102      OUT	    0         
//#define    N.C.                      PORTB_PB7  	 // 103      OUT	    0         

/*===================================================================================================================================================
  PTT ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
#define    SPI_MOSI                   PTT_PTT0        // 52       OUT      0	  	   0             0       
#define    AUDIO_nCS                  PTT_PTT1        // 53       OUT      0	  	   0             0       
#define    SPI_SCLK                   PTT_PTT2        // 54       OUT      0	  	   0             0      TFT_SCLK ĻоƬ   
#define    SPI_MISO                   PTT_PTT3        // 55       IN       0	  	   0             0       
#define    LCD_nCS                    PTT_PTT4        // 57       OUT      0	  	   0             0      Ƭѡ   TFT_CSB
#define    LINE_IN_AirBagn            PTT_PTT5        // 58       IN       0	  	   0             0      ȫҼ 
#define    LINE_IN_PTO                PTT_PTT6        // 59       IN       0	  	   0             0      PTOƼ 
#define    LINE_IN_DOOR_OPEN          PTT_PTT7        // 60       IN       0	  	   0             0      δؼ 

/*===================================================================================================================================================
  PTS ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
//#define    DEBUG_RXD                  PTS_PTS0        // 39       IN       0	  	   0             0         
//#define    DEBUG_TXD                  PTS_PTS1        // 40       IN       0	  	   0             0         
#define    CAN0_RXD                   PTS_PTS2        // 43       IN       0	  	   1             0         RXCAN
#define    CAN0_TXD                   PTS_PTS3        // 44       OUT      0	  	   0             0         TXCAN    
#define    TFT_MISO                   PTS_PTS4        // 47       IN       0	  	   0             0         
#define    TFT_MOSI                   PTS_PTS5        // 48       OUT      0	  	   0             0         
#define    TFT_SCLK                   PTS_PTS6        // 49       OUT      0	  	   0             0         
#define    TFT_nCS                    PTS_PTS7        // 50       OUT      0	  	   0             0         

/*===================================================================================================================================================
  PTP ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/   
#define    LED_AirBag                 PTP_PTP0        // 29       OUT     0	  	   0             0           ȫҵ
#define    BL                         PTP_PTP1        // 30       OUT     0	  	   0             0           Ǳ⣬岻
#define    PWR_3V3EN                  PTP_PTP2        // 31       OUT     0	  	   1             0           BD433ʹ lcdоƬ3.3vԴʹ	      
//#define    N.C.                     PTP_PTP3        // 32       OUT     0	  	   0             0                
#define    LINE_IN_LEFT               PTP_PTP4        // 33       IN      0	  	   0             0           ת    
#define    LINE_IN_RIGHT              PTP_PTP5        // 34       IN      0	  	   0             0           ת
#define    LCD_BL                     PTP_PTP6        // 35       OUT     0	  	   0             0           Ļ
#define    TFT_nRST                   PTP_PTP7        // 36       OUT     0	  	   0             0           ĻReset       

/*===================================================================================================================================================
  PTH ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
#define     LINE_IN_EBD_FAULTn        PTH_PTH0         // 63       IN       0	  	   1             0           EBDϵƼ
#define     LINE_IN_POSITION          PTH_PTH1         // 64       IN       1	  	   0             0           λõƼ
#define     LINE_PARK                 PTH_PTH2         // 65       IN       1	  	   1             0           פƶ
#define     LINE_IN_ABS               PTH_PTH3         // 66       IN       0	  	   0             0           ABS   
//#define    N.C.                     PTH_PTH4         // 75       IN       0	  	   0             0          
//#define    N.C.                     PTH_PTH5         // 76       IN       0	  	   0             0               
//#define    N.C.                     PTH_PTH6         // 83       OUT      0	  	   0             0           
//#define    N.C.                     PTH_PTH7         // 84       OUT      0	  	   0             0           
/*===================================================================================================================================================
  PT1AD ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  ˵
  ===================================================================================================================================================*/
//#define  N.C.					              PT1AD_PT1AD0	   // 108      OUT	    0        0                         
#define  LINE_IN_KEY1n				        PT1AD_PT1AD1	   // 109      IN       0        0	                       key2  ұ
#define  LINE_IN_KEY0n					      PT1AD_PT1AD2     // 110      IN       0        0                         key1  
#define  ADC_KL30                    	PT1AD_PT1AD3     // 111      IN       0        0                         30
#define  ADC_KL15                    	PT1AD_PT1AD4	   // 112      IN       0        0                         15
#define	 LED_SOC_CLOSE				        PT1AD_PT1AD5	   // 1        OUT      0        0                         000жϵ
#define	 LED_SOC_FAULT              	PT1AD_PT1AD6     // 2        OUT      0        0                         001عϵ                 
#define	 LED_MOTOR_TEMP			          PT1AD_PT1AD7     // 3        OUT      0        0                         002ȵ

/*===================================================================================================================================================
  PTR ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
#define	CAN0_STB               	     	PTR_PTR0          // 45       OUT      0	  	   0             0         CANշSTB
#define	TFT_nINT               	      PTR_PTR1          // 46       IN       0	  	   0             0			   YAMAHA_TFT_nINT
#define PWR_nVIOEN                    PTR_PTR2          // 37       OUT      0	  	   0             0         YAMAHA_CTL_ 
//#define  N.C.  				              PTR_PTR3          // 38       OUT      0	  	   0             0         Ƹߵ
#define	LINE_BUZZER                   PTR_PTR4          // 56       OUT      0	  	   1             0
#define	LINE_IN_SOC_WAKE              PTR_PTR5          // 61       IN       0	  	   1             0     	   绽Ѽ    
#define LINE_IN_Char_Sts				      PTR_PTR6          // 62       IN       0	  	   1             0			   ŵƼ
#define LED_ABS_FAULT_Y					      PTR_PTR7          // 85       OUT      0	  	   0             0         006ABS()

/*===================================================================================================================================================
  PTU ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
//#define    N.C.                      PTU_PTU0         // 9        OUT      0	  	   0             0       C_COS+    
//#define    N.C.                      PTU_PTU1         // 10       OUT      0	  	   0             0       C_COS-    
//#define    N.C.                      PTU_PTU2         // 11       OUT      0	  	   0             0       C_SIN+    
//#define    N.C.                      PTU_PTU3         // 12       OUT      0         0             0       C_SIN-    
//#define    N.C.                      PTU_PTU4         // 15       OUT      0         0             0       SOC_COS+    
//#define    N.C.                      PTU_PTU5         // 16       OUT      0         0             0       SOC_COS-    
//#define    N.C.                      PTU_PTU6         // 17       OUT      0         0             0       SOC_SIN+    
//#define    N.C.                      PTU_PTU7         // 18       OUT      0         0             0       SOC_SIN-   

/*===================================================================================================================================================
  PTV ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
//#define    N.C.                      PTV_PTV0         // 19       OUT      0	  	   0             0      S-COS+       
//#define    N.C.                      PTV_PTV1         // 20       OUT      0	  	   0             0      S_COS-       
//#define    N.C.                      PTV_PTV2         // 21       OUT      0	  	   0             0      S_SIN+       
//#define    N.C.                      PTV_PTV3         // 22       OUT      0	  	   0             0      S_SIN-       
//#define    N.C.                      PTV_PTV4         // 25       OUT      0	  	   0             0      Z_COS+       
//#define    N.C.                      PTV_PTV5         // 26       OUT      0	  	   0             0      Z_COS-       
//#define    N.C.                      PTV_PTV6         // 27       OUT      0	  	   0             0      Z_SIN+       
//#define    N.C.                      PTV_PTV7         // 28       OUT      0	  	   0             0      Z_SIN-       

/*===================================================================================================================================================
  PTM ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
#define    LINE_SPEED_IN               PTM_PTM0        // 69       IN       0	  	   0             0          
#define    LINE_SPEED_OUT              PTM_PTM1        // 70       OUT      0	  	   0             0          
#define       SEG_LCD_SD                      PTM_PTM2        // 71       OUT      0	  	   0             0             
#define       SEG_LCD_SCL                      PTM_PTM3        // 72       OUT      0	  	   0             0    
         
/*===================================================================================================================================================
  PT0AD ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  ˵
  ===================================================================================================================================================*/
#define	   LED_PTO_B		    			    PT0AD_PT0AD0     // 4        OUT      0	  	    0       003PTO
#define	     SEG_LCD_CSB					          PT0AD_PT0AD1     // 5        OUT      0         0
#define    LED_SYSTEM_FAULT					  PT0AD_PT0AD2     // 6        OUT      0         0       004ϵͳϵ
#define	   LINE_IN_SEATBELTn				  PT0AD_PT0AD3     // 7        IN       0         0       ȫ

/****************************************************************************************************************************************************
  
 ****************************************************************************************************************************************************/
void GPIO_Init(void);
void GPIO_OFF(void) ;

#endif
