/******************************************************************************
  SPI_Master.c
SPI ģʽͷļ
    ߣ
    V1.0
    ڣ2017.04.02
******************************************************************************/

#ifndef _SPI_MASTER_H_
#define _SPI_MASTER_H_

#include "stdint.h"
#include "mc9s12xhy128.h"
#include "CRG.h"

/******************************************************************************
SPI 
******************************************************************************/
#define   SPI_GPIO_SELECT                   SPI_PS4_PS7
#define   SPI_BAUD_RATE                     4000000         //޷Զ,SPI_Master_Startڶ

#define   SPI_DATA_BUFFER_SIZE              16

#define   SPI_CALL_DATA_BLOCK_TX_ISR        1               //ʹݿ鴫жϺ

#define   SPI_DUMMY_BYTE                    0xFF
#define   SPI_DUMMY_WORD                    0xFFFF

/******************************************************************************
SPIõGPIO
******************************************************************************/
#define   SPI_PS4_PS7                       0x00
#define   SPI_PH0_PH3                       0x10
#define   SPI_PHV_PV3                       0x20

/******************************************************************************
SPIģʽ
******************************************************************************/
#define   SPI_MODE_0                        0x00
#define   SPI_MODE_1                        0x04
#define   SPI_MODE_2                        0x08
#define   SPI_MODE_3                        0x0C

/******************************************************************************
SPIλ
******************************************************************************/
#define   SPI_MSB_FIRST                     0x00
#define   SPI_LSB_FIRST                     0x01

/******************************************************************************
SPIд״̬
******************************************************************************/
#define   SPI_WRITE_COMPLETE                0x00
#define   SPI_UNWRITABLE                    0x01
#define   SPI_WRITE_NOT_COMPLETE            0x01

/******************************************************************************
SPIȡ
******************************************************************************/
#define   SPI_READ_COMPLETE                 0x00
#define   SPI_READ_REQ_COMPLETE             0x00
#define   SPI_READ_NOT_COMPLETE             0x01

/******************************************************************************
SPIݿ״̬
******************************************************************************/
#define   SPI_DATA_BLOCK_IDLE               0x00
#define   SPI_DATA_BLOCK_WRITE              0x01
#define   SPI_DATA_BLOCK_READ               0x02

/******************************************************************************
SPIݿṹ
******************************************************************************/
typedef struct
{
  uint8_t   Status;
  uint8_t   ReadComplete;
  uint8_t   Ptr;
  uint8_t   Len;
  uint8_t   Data[SPI_DATA_BUFFER_SIZE];
} SPIDataBlockStruct;

/******************************************************************************

******************************************************************************/
void SPI_Master_Start(uint8_t Mode, uint8_t FirstBit);
void SPI_Master_Stop(void);
uint8_t SPI_Master_Get_Write_Status(void);

uint8_t SPI_Master_Byte_Write(uint8_t Data);
uint8_t SPI_Master_Byte_Read_Req(void);
uint8_t SPI_Master_Get_Read_Byte(uint8_t *pData);

uint8_t SPI_Master_Word_Write(uint16_t Data);
uint8_t SPI_Master_Word_Read_Req(void);
uint8_t SPI_Master_Get_Read_Word(uint16_t *pData);

uint8_t SPI_Master_Block_Write(uint8_t *pData, uint8_t Len);
uint8_t SPI_Master_Block_Read_Req(uint8_t Len);
uint8_t SPI_Master_Get_Read_Block(uint8_t *pData, uint8_t Len);

#if SPI_CALL_DATA_BLOCK_TX_ISR
void SPI_Master_Block_Transmit_ISR(void);
#endif

#endif