
#include "IO_Manager.h"
#include "Menus.h"
#include "Drive_Info.h"
#include "Popup_Scheduler.h"

volatile uint8_t            IODispFuncEnable;
volatile uint8_t            IODispFuncSwitch;
uint8_t                     IODriveInfoAutoSwitchEnable;
uint8_t                     IODriveInfoTimer;

volatile uint8_t            IOPopupMenuTipRunning;
volatile uint8_t            IOPopupMenuTipWarning;

IOManageStruct              IOManage;
IODispModeCtrlStruct        IODispModeCtrl;

volatile IOKeysRedirUnion   IOICUKeys;
volatile IOKeysRedirUnion   IOCANKeys;
volatile uint8_t            IODispMode;
volatile uint8_t            IOTFTLCDAccessRight;
uint8_t                     IOTimeCalEnable;
uint8_t  IOKeyDetFlag;

void IO_Trip_Key_Mask(uint8_t Mask)
{
  if (Mask)
    IOManage.TripEnable = 0;
  else
    IOManage.TripEnable = 1;
}
//״̬ʼ
void IO_Management_Init(void)
{
  IODispModeCtrl.IGNStatusBackup  = 0;
  IODispModeCtrl.SelfTestComplete = 0;
  IODispModeCtrl.SelfTestTimer    = IO_SELF_TEST_TIME / 20;
  IODispMode                      = IO_DISP_MODE_BLANK;
  IOTFTLCDAccessRight             = 0x00;

  IODispFuncEnable = IO_DISP_FUNC_NONE;
  IOPopupMenuTipRunning = 0;
  IOPopupMenuTipWarning = 0;

  IO_ICU_KEYS = 0x00;
  IOManage.TripEnable         = 1;
  IOManage.ICUKeysBackup.Byte = 0x00;
  IOKeyDetFlag = 0;
  IODriveInfoAutoSwitchEnable = 0;
  IODriveInfoTimer = 0;
}

//uint8_t ClrOdoEn = 0;

void IO_Management_Service(void)
{
  uint8_t   KeyValue;
  //ʾģʽ
  if (SYS_OPR_STAT_RUN)
  {
    if (SYS_OPR_STAT_IGN_ON)
    {
      if (IODispModeCtrl.IGNStatusBackup == 0)
      {
        IODispModeCtrl.SelfTestComplete = 0;
        IODispModeCtrl.SelfTestTimer    = IO_SELF_TEST_TIME / 20;
        IOTimeCalEnable                 = 1;
      }

      if (IODispModeCtrl.SelfTestComplete == 0)
      {
        if (IODispModeCtrl.SelfTestTimer)
          IODispModeCtrl.SelfTestTimer--;
        else
          IODispModeCtrl.SelfTestComplete = 1;
      }

      IODispModeCtrl.IGNStatusBackup = 1;
      if (IODispModeCtrl.SelfTestComplete) 
      {
        IODispMode = IO_DISP_MODE_IGN_ON;
        //TFT_LCD_Clear_Layer(LAYER_BEIJING);
        //TFT_LCD_Clear_Layer(LAYER_BEIJING1);
      }
      else
        IODispMode = IO_DISP_MODE_SELF_TEST;
    }
    else
    {
      IODispMode = IO_DISP_MODE_IGN_OFF;
      IODispModeCtrl.IGNStatusBackup = 0;
    }
  }
  else
  {
    IODispMode = IO_DISP_MODE_BLANK;
    IODispModeCtrl.IGNStatusBackup = 0;
  }

  if (IODispMode == IO_DISP_MODE_IGN_ON)
  { 
    if (IODriveInfoAutoSwitchEnable)
    {
      IODriveInfoTimer++;
      if (IODriveInfoTimer >= 14)
      {
        TFT_LCD_Clear_Layer(LAYER_BEIJING);
        TFT_LCD_Clear_Layer(LAYER_BEIJING1);
      }
      if (IODriveInfoTimer >= (uint8_t)(IO_DRIVE_INFO_AUTO_SWITCH_TIME / 20))
      {
        IODriveInfoAutoSwitchEnable = 0;
        IODriveInfoTimer = 0;
        IOTFTLCDAccessRight &= ~IO_ANIMATION_BIT; //IGN ONʾģʽ²ʾ,ϢָʾƳ
        IOTFTLCDAccessRight |= (IO_BG_INFO_BIT | IO_TELLTALE_BIT | IO_DRIVE_INFO_BIT );
      }
    }
/**********************************ɼ********************************************/
    KeyValue = Key_Get_Status(KEY_LEFT);   
    if ( KeyValue == IO_KEY_PRESS )
    {
      //KeyDelaytimer1 = 0 ; 
      IO_CAN_KEY_LEFT = IO_KEY_PRESS;
    } 
    else if ( KeyValue == IO_KEY_HOLD )   
    { 
      IO_CAN_KEY_LEFT = IO_KEY_HOLD; 
    }
    else if ( KeyValue == KEY_LONG )   
    { 
      IO_CAN_KEY_LEFT = IO_KEY_LONG; 
    }
    else 
    {
      IO_CAN_KEY_LEFT = IO_KEY_IDLE;
    }
    
    KeyValue = Key_Get_Status(KEY_RIGHT);
    if ( KeyValue == IO_KEY_PRESS )
    {
      //KeyDelaytimer2 = 0 ; 
      IO_CAN_KEY_RIGHT = IO_KEY_PRESS; 
    }
    else if ( KeyValue == IO_KEY_HOLD )   
    { 
      IO_CAN_KEY_RIGHT = IO_KEY_HOLD; 
    }
    else if ( KeyValue == KEY_LONG )   
    { 
      IO_CAN_KEY_RIGHT = IO_KEY_LONG; 
    } 
    else 
    {   
      IO_CAN_KEY_RIGHT = IO_KEY_IDLE;
    }
    
    KeyValue = Key_Get_Status(KEY_ENTER);
    
    if ( KeyValue == IO_KEY_PRESS )
    { 
      IO_CAN_KEY_ENTER = IO_KEY_PRESS;
      //ClrOdoEn = 1;
    }
    else if ( KeyValue == IO_KEY_HOLD )   
    { 
      IO_CAN_KEY_ENTER = IO_KEY_HOLD; 
    }
    else if ( KeyValue == KEY_LONG )   
    { 
      IO_CAN_KEY_ENTER = IO_KEY_LONG; 
    }
    else 
    {   
      IO_CAN_KEY_ENTER = IO_KEY_IDLE;
    }
/******************************************************************************/      
    //ʱ
    // if (((DataVSpeedDisp < 160 )||(DataESpeedDisp < 4480))) 
    // {
    if (IO_POPUP_DISPLAY_ENABLE)
    {
      if (IO_CAN_KEY_ENTER == IO_KEY_PRESS)
      {
        IO_CAN_KEY_ENTER = IO_KEY_IDLE;
        Popup_Mask_Request();
      } 
    }
    
    if ((IO_DRIVE_INFO_DISPLAY_ENABLE) && (!IO_POPUP_DISPLAY_ENABLE) && (IO_CAN_KEY_ENTER == IO_KEY_LONG))
    {
      IO_CAN_KEY_ENTER = IO_KEY_IDLE;
      IOTFTLCDAccessRight = 0x00;  
      IOTFTLCDAccessRight = (IO_TIME_BIT | IO_BG_INFO_BIT);
    }
  #if 0  
    if ((IO_DRIVE_INFO_DISPLAY_ENABLE) && (!IO_POPUP_DISPLAY_ENABLE) && (IO_CAN_KEY_LEFT == IO_KEY_LONG))
    {
      IO_CAN_KEY_LEFT = IO_KEY_IDLE;
      IOTFTLCDAccessRight = 0x00;  
      IOTFTLCDAccessRight = (IO_TIME_BIT | IO_BG_INFO_BIT);
      SetMenu = 3;
    }
  #endif
    if ((IO_DRIVE_INFO_DISPLAY_ENABLE) && (!IO_POPUP_DISPLAY_ENABLE) && (IO_CAN_KEY_RIGHT == IO_KEY_LONG))
    {
      IO_CAN_KEY_RIGHT = IO_KEY_IDLE;
      IOTFTLCDAccessRight = 0x00;  
      IOTFTLCDAccessRight = (IO_TIME_BIT | IO_BG_INFO_BIT);
      SetMenu = 2;
    }
    if (IO_BG_INFO_DISPLAY_ENABLE)
    {
      Time_Seting(); //Ϣ
      /************************ý*************************************/
      //----hyq--20180602
      // Time_Seting(); //Ϣ
      if (IO_TIME_DISPLAY_ENABLE)
      { 
        /*********************************˳************************************************/
        if ((!IO_POPUP_DISPLAY_ENABLE)) //Ǳ
        {
          if ((IO_CAN_KEY_LEFT == IO_KEY_IDLE) || (IO_CAN_KEY_RIGHT == IO_KEY_IDLE) || (IO_CAN_KEY_ENTER == IO_KEY_IDLE))
          {
            if (keytime < 1500)
              keytime++;
            else
            {
              if (SetMenu == 6) //ʱý
              {
                RTC_MINUTE = SetMinute_One + SetMinute_Ten * 10;
                RTC_HOUR   = SetHour_One + SetHour_Ten * 10 ;
              }
              keytime = 0;
              ClockPOS = 0;
              SetMenupage = 0;    
              SetMenu = 0;
              IODispFuncSwitch     = 1;
              IOTFTLCDAccessRight  = 0x00;
              IOTFTLCDAccessRight |= (IO_BG_INFO_BIT | IO_TELLTALE_BIT | IO_DRIVE_INFO_BIT);
              //TFT_LCD_Clear_Multi_Layer(LAYER_MENU01, LAYER_MENU16);
            }
          }
        }
      }
    }
  }
  else if (IODispMode == IO_DISP_MODE_IGN_OFF)
  {
    IODriveInfoAutoSwitchEnable = 0;
    IOTFTLCDAccessRight &= IO_POPUP_BIT; //ֻпʾϢ
    if (!IO_POPUP_DISPLAY_ENABLE)
      IODispFuncSwitch = 1;
  }
  else if (IODispMode == IO_DISP_MODE_SELF_TEST)
  {
    IODriveInfoAutoSwitchEnable = 1;
    IODriveInfoTimer = 0;
    IODispFuncSwitch = 0;
    IOTFTLCDAccessRight = IO_ANIMATION_BIT; //ֻʾ
    IO_ICU_KEYS      = 0x00;
  }
  else
  {
    IODriveInfoAutoSwitchEnable = 0;
    IOTFTLCDAccessRight = 0x00; //ʲôʾ
  }
}

void IO_Popups_Display_Request(void)
{
  if (IODispMode == IO_DISP_MODE_IGN_OFF)
  {
    if (!IO_POPUP_DISPLAY_ENABLE)
    {
      IODispFuncSwitch = 1;
      IOTFTLCDAccessRight  = 0x00;
      IOTFTLCDAccessRight |= IO_POPUP_BIT;
    }
  }
  else if (IODispMode == IO_DISP_MODE_IGN_ON)
  {
    if ((!IO_POPUP_DISPLAY_ENABLE))
    {
      IODispFuncSwitch = 1;
      IODriveInfoAutoSwitchEnable = 0;
      IOTFTLCDAccessRight  = 0x00;
      IOTFTLCDAccessRight |= (IO_BG_INFO_BIT | IO_TELLTALE_BIT | IO_POPUP_BIT);       
    }
  }
}

void IO_Popups_Display_Release(void)
{
  if (IODispMode == IO_DISP_MODE_IGN_OFF)
  {
    if (IO_POPUP_DISPLAY_ENABLE)
    {
      IODispFuncSwitch = 1;
      IOTFTLCDAccessRight = 0x00;
    }
  }
  else if (IODispMode == IO_DISP_MODE_IGN_ON)
  {
    if (IO_POPUP_DISPLAY_ENABLE)
    {
      IODispFuncSwitch     = 1;
      IOTFTLCDAccessRight  = 0x00;
      IOTFTLCDAccessRight |= (IO_BG_INFO_BIT | IO_TELLTALE_BIT | IO_DRIVE_INFO_BIT);  
    }
  }
}
void IO_Menus_Display_Release(void)
{
  if (IODispMode == IO_DISP_MODE_IGN_ON)
  {
    if (IO_TIME_DISPLAY_ENABLE)
    {
      IODispFuncSwitch     = 1;
      IOTFTLCDAccessRight  = 0x00;
      IOTFTLCDAccessRight |= (IO_BG_INFO_BIT | IO_TELLTALE_BIT | IO_DRIVE_INFO_BIT);
    }
  }
  
  //KEY_RIGHT_TURN = 0; 
  //KEY_LEFT_TURN  = 0;
  //IO_CAN_KEY_ENTER = IO_KEY_IDLE; 
  //IO_CAN_KEY_RIGHT = IO_KEY_IDLE;
  //IO_CAN_KEY_LEFT  = IO_KEY_IDLE;
}

