
#include "Sound_Scheduler.h"

uint8_t   SoundEnableCode[SND_TOTAL_NUMBER];
SoundSchedulingStruct       SoundScheduling;
SoundSeatbeltCtrlStruct     SoundSeatbelt;

void Sound_Scheduler_Init(void)
{
  uint8_t i;

  for (i = 0; i < SND_TOTAL_NUMBER; i++)
    SoundEnableCode[i] = 0;

  Sound_Clear();

  SoundScheduling.Current = SND_NONE;
  SoundScheduling.Next    = SND_NONE;
  SoundScheduling.ReqCode = 0;
  SoundScheduling.StopReq = 0;

  SoundSeatbelt.DrMode  = SND_SEATBELT_DISABLE;
  SoundSeatbelt.DrTimer = (uint16_t)(SND_SEATBELT_120s_TIME / 50);
  SoundSeatbelt.PaMode = SND_SEATBELT_DISABLE;
  SoundSeatbelt.PaTimer = (uint16_t)(SND_SEATBELT_120s_TIME / 50);
}

//ReqCode,0 - ʾЧ,󲥷
//                0ֵ - 󲥷,뽫¼,ֻһε,һ󲥷Ÿͬ
//                        Ͳٱظ

void Sound_Request(uint8_t Sound, uint8_t ReqCode)
{
  uint8_t PriorityRef;
  uint8_t PriorityNew;
 
  if ((Sound < SND_TOTAL_NUMBER) && (ReqCode))
  {
    if ((SoundEnableCode[Sound] != ReqCode) || (SoundList[Sound].Type != SND_TYPE_NORMAL))
    {
      /*
      if (SoundList[Sound].Type == SND_TYPE_SEATBELT) //ȫ
      {
        if (Sound == SND_FASTEN_SEATBELT_DR)
          SoundSeatbelt.DrMode = SND_SEATBELT_CONTINUOUS;
        else if (Sound == SND_FASTEN_SEATBELT_DR_120s)
        {
          if (SoundSeatbelt.DrMode == SND_SEATBELT_TIME_UP)
            return;

          SoundSeatbelt.DrMode = SND_SEATBELT_TIMING;
        }
        else if (Sound == SND_FASTEN_SEATBELT_PA)
          SoundSeatbelt.PaMode = SND_SEATBELT_CONTINUOUS;
        else if (Sound == SND_FASTEN_SEATBELT_PA_120s)
        {
          if (SoundSeatbelt.PaMode == SND_SEATBELT_TIME_UP)
            return;

          SoundSeatbelt.PaMode = SND_SEATBELT_TIMING;
        }

        Sound = SND_FASTEN_SEATBELT_DR;
      }
      */
      if (SoundScheduling.Next < SND_TOTAL_NUMBER)    //мҪŵ
      {
        if (Sound != SoundScheduling.Next)
        {
          PriorityRef = Sound_Priority_Query(SoundList[SoundScheduling.Next].Src);
          PriorityNew = Sound_Priority_Query(SoundList[Sound].Src);

          if (PriorityNew < PriorityRef)
          {
            SoundScheduling.Next = Sound;             //иߵȼ
            SoundScheduling.ReqCode = ReqCode;
          }
          else if (PriorityNew == PriorityRef)
          {
            if (SoundList[Sound].Type == SND_TYPE_RADAR)
            {
              SoundScheduling.Next = Sound;           //ͬȼ״໥
              SoundScheduling.ReqCode = ReqCode;
            }
          }
        }
      }
      else                                            //ûмҪŵ
      {
        if (Sound != SoundScheduling.Current)
        {
          PriorityRef = Sound_Priority_Query(SND_SRC_CURRENT);
          PriorityNew = Sound_Priority_Query(SoundList[Sound].Src);

          if (PriorityNew < PriorityRef)
          {
            SoundScheduling.Next = Sound;             //иߵȼ
            SoundScheduling.ReqCode = ReqCode;
          }
          else if (PriorityNew == PriorityRef)
          {
            if (SoundList[Sound].Type == SND_TYPE_RADAR)
            {
              SoundScheduling.Next = Sound;           //ͬȼ״໥
              SoundScheduling.ReqCode = ReqCode;
            }
          }
        }
      }
    }
  }
}

void Sound_Delete(uint8_t Sound)
{
  if (Sound < SND_TOTAL_NUMBER)
  {
    /*
    if (SoundList[Sound].Type == SND_TYPE_SEATBELT) //ȫ
    {
      if (Sound == SND_FASTEN_SEATBELT_DR)
      {
        if (SoundSeatbelt.DrMode == SND_SEATBELT_CONTINUOUS)
          SoundSeatbelt.DrMode = SND_SEATBELT_DISABLE;
      }
      else if (Sound == SND_FASTEN_SEATBELT_DR_120s)
      {
        if ((SoundSeatbelt.DrMode == SND_SEATBELT_TIMING) || (SoundSeatbelt.DrMode == SND_SEATBELT_TIME_UP))
        {
          SoundSeatbelt.DrMode  = SND_SEATBELT_DISABLE;
          SoundSeatbelt.DrTimer = (uint16_t)(SND_SEATBELT_120s_TIME / 50);
        }
      }
      else if (Sound == SND_FASTEN_SEATBELT_PA)
      {
        if (SoundSeatbelt.PaMode == SND_SEATBELT_CONTINUOUS)
          SoundSeatbelt.PaMode = SND_SEATBELT_DISABLE;
      }
      else if (Sound == SND_FASTEN_SEATBELT_PA_120s)
      {
        if ((SoundSeatbelt.PaMode == SND_SEATBELT_TIMING) || (SoundSeatbelt.PaMode == SND_SEATBELT_TIME_UP))
        {
          SoundSeatbelt.PaMode = SND_SEATBELT_DISABLE;
          SoundSeatbelt.PaTimer = (uint16_t)(SND_SEATBELT_120s_TIME / 50);
        }
      }

      if ((SoundSeatbelt.DrMode == SND_SEATBELT_DISABLE) && \
          (SoundSeatbelt.PaMode == SND_SEATBELT_DISABLE))
        Sound = SND_FASTEN_SEATBELT_DR;
      else
        return;
    }
    */
    if (SoundEnableCode[Sound])                      //ѲŹ
    {
      if (Sound == SoundScheduling.Current)
      {
        SoundScheduling.StopReq = 1;
        return;
      }

      if (Sound == SoundScheduling.Next)
        SoundScheduling.Next = SND_NONE;

      SoundEnableCode[Sound] = 0;
    }
  }
}

//50ms
void Sound_Scheduling_Service(void)
{
  //ֹͣ
  if (SoundScheduling.StopReq)
  {
    if (SoundScheduling.Current < SND_TOTAL_NUMBER)
    {
      if (Sound_Stop(SoundList[SoundScheduling.Current].Src) == 0)
      {
        SoundScheduling.StopReq = 0;
        SoundEnableCode[SoundScheduling.Current] = 0;
        SoundScheduling.Current = SND_NONE;
      }
    }
  }

  //ʹòѯȼ鿴ǰǷڲ
  if (SoundScheduling.Current < SND_TOTAL_NUMBER)
  {
    if (Sound_Priority_Query(SND_SRC_CURRENT) == 0xFF)
      SoundScheduling.Current = SND_NONE;
  }

  //
  if (SoundScheduling.Next < SND_TOTAL_NUMBER)
  {
    if (SoundScheduling.Current < SND_TOTAL_NUMBER)   //ǰڲ,ֹͣŸ
      Sound_Stop(SoundList[SoundScheduling.Current].Src);

    if (Sound_Play(SoundList[SoundScheduling.Next].Src) == 0)             //ųɹ
    {
      SoundEnableCode[SoundScheduling.Next] = SoundScheduling.ReqCode;    //Ѳ
      SoundScheduling.Current = SoundScheduling.Next;
      SoundScheduling.Next    = SND_NONE;
    }
  }

  /*
  //ȫʱ
  if (SoundScheduling.Current == SND_FASTEN_SEATBELT_DR)
  {
    if (SoundSeatbelt.DrMode == SND_SEATBELT_TIMING)
    {
      if (SoundSeatbelt.DrTimer)
        SoundSeatbelt.DrTimer--;
      else
      {
        SoundSeatbelt.DrMode  = SND_SEATBELT_TIME_UP;
        SoundSeatbelt.DrTimer = (uint16_t)(SND_SEATBELT_120s_TIME / 50);
      }
    }

    if (SoundSeatbelt.PaMode == SND_SEATBELT_TIMING)
    {
      if (SoundSeatbelt.PaTimer)
        SoundSeatbelt.PaTimer--;
      else
      {
        SoundSeatbelt.PaMode = SND_SEATBELT_TIME_UP;
        SoundSeatbelt.PaTimer = (uint16_t)(SND_SEATBELT_120s_TIME / 50);
      }
    }

    if (((SoundSeatbelt.DrMode == SND_SEATBELT_DISABLE)  || \
         (SoundSeatbelt.DrMode == SND_SEATBELT_TIME_UP)) && \
        ((SoundSeatbelt.PaMode == SND_SEATBELT_DISABLE)  || \
         (SoundSeatbelt.PaMode == SND_SEATBELT_TIME_UP)))
      SoundScheduling.StopReq = 1;
  }
  */
}
