
#ifndef _SYSTEM_STATUS_MONITOR_H_
#define _SYSTEM_STATUS_MONITOR_H_

#include "CRG.h"
#include "API.h"
#include "Communication_Over_CAN.h"
#include "Analog_Signal_Conversion.h"
#include "CAN_Communication_Matrix.h"
#include "Non_volatile_Memorys.h"

extern volatile uint8_t SysPowerStatus;
extern volatile uint8_t SysOperatingStatus;

/******************************************************************************
ϵͳ״̬б
******************************************************************************/

/*=================================================================================================================================
             Դ״̬            |               ״̬                |                        |
         (SysPowerStatus)        |         (SysOperatingStatus)          |        ϵͳ״̬        |              ˵
  -------------------------------+---------------------------------------|                        |
    OVP  |  LVP  |  LIM  |  RUN  |  OFF  |  ACC  |  IGN  |  CRK  |  ERR  |                        |
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |       |   X   |       |       |       |       |       | SYS_PWR_STAT_NORMAL    | Դѹ
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
     X   |   X   |   X   |       |       |       |       |       |       | SYS_PWR_STAT_ABNORMAL  | Դѹ쳣
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |   X   |       |       |       |       |       |       | SYS_PWR_STAT_LIMIT     | Դѹ,ֹ
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |   X   |       |       |       |       |       |       |       | SYS_PWR_STAT_LVP       | Դѹ,ѹ״̬
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
     X   |       |       |       |       |       |       |       |       | SYS_PWR_STAT_OVP       | Դѹ,ѹ״̬
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
     X   |   X   |       |       |       |       |       |       |       | SYS_PWR_STAT_PROTECT   | Դѹ߻,״̬
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |   X   |   X   |       |       |       |       |       | SYS_PWR_STAT_UNPROTECT | Ǳ״̬
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |       |       |   X   |   X   |   X   |   X   |       | SYS_OPR_STAT_RUN       | ϵͳ
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |       |       |       |       |       |       |   X   | SYS_OPR_STAT_HALT      | ϵͳֹͣ
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |       |       |   X   |       |       |       |       | SYS_OPR_STAT_OFF       | еԴر
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |       |       |       |   X   |   X   |       |       | SYS_OPR_STAT_ACC_ON    | ACCԴ
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |       |       |       |       |   X   |   X   |       | SYS_OPR_STAT_IGN_ON    | IGNԴ
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |       |       |   X   |   X   |       |       |       | SYS_OPR_STAT_IGN_OFF   | IGNԴر
  -------+-------+-------+-------+-------+-------+-------+-------+-------+------------------------+--------------------------------
         |       |       |       |       |       |       |   X   |       | SYS_OPR_STAT_CRANK     | 
  ---------------------------------------------------------------------------------------------------------------------------------
  1. ڵԴѹзΧ,Ž[SYS_PWR_STAT_NORMAL]״̬,״̬ͱ״̬[SYS_PWR_STAT_ABNORMAL]״̬
  2. [SYS_PWR_STAT_UNPROTECT]״̬Դѹ״̬״̬,Ե[SYS_PWR_STAT_PROTECT]״̬ѹѹ״̬
  3. [SYS_OPR_STAT_RUN]״̬ǽڵԴѹ½,ҲǵԴѹ״̬״̬ɽ,ȡϵͳ״̬,
     һ״ֱ̬ڵǰϵͳǷ,ϵͳʱ,[SYS_OPR_STAT_HALT]״̬
  4. [SYS_OPR_STAT_OFF]״̬ӳԿ״OFFλ,[SYS_OPR_STAT_IGN_OFF]״̬ͬ,ACC״̬ⱻʹʱ,ԿתACCλú,
     [SYS_OPR_STAT_OFF]״̬,ʱIGNԴδ[SYS_OPR_STAT_IGN_OFF]״̬Ч
  5. [SYS_OPR_STAT_RUN]״ָ̬Դѹ,ϵͳ,ǵָIGN״̬
  6. Ҫ ACC  CRANK ״̬,ϵͳ״̬ʹصļ⹦
  =================================================================================================================================*/
#define   SYS_PWR_STAT_NORMAL               (SysPowerStatus & 0x01)
#define   SYS_PWR_STAT_ABNORMAL             (SysPowerStatus & 0x0E)
#define   SYS_PWR_STAT_LIMIT                (SysPowerStatus & 0x02)
#define   SYS_PWR_STAT_LVP                  (SysPowerStatus & 0x04)
#define   SYS_PWR_STAT_OVP                  (SysPowerStatus & 0x08)
#define   SYS_PWR_STAT_PROTECT              (SysPowerStatus & 0x0C)
#define   SYS_PWR_STAT_UNPROTECT            (SysPowerStatus & 0x03)

#define   SYS_OPR_STAT_RUN                  (SysOperatingStatus & 0x0F)
#define   SYS_OPR_STAT_HALT                 (SysOperatingStatus & 0x80)
#define   SYS_OPR_STAT_OFF                  (SysOperatingStatus & 0x01)
#define   SYS_OPR_STAT_ACC_ON               (SysOperatingStatus & 0x06)
#define   SYS_OPR_STAT_IGN_ON               (SysOperatingStatus & 0x0C)
#define   SYS_OPR_STAT_IGN_OFF              (SysOperatingStatus & 0x03)
#define   SYS_OPR_STAT_CRANK                (SysOperatingStatus & 0x08)

/******************************************************************************
ϵͳ״̬ģʽ
******************************************************************************/
#define   SYS_STAT_UPDATE_MODE_NORMAL       0x00
#define   SYS_STAT_UPDATE_MODE_WAKEUP       0x01
#define   SYS_STAT_UPDATE_MODE_RECOVERY     0x02
#define   SYS_STAT_UPDATE_MODE_INIT         0x03

/******************************************************************************
Դ״̬λ
******************************************************************************/

/*====================================================================
     Bit 0   | SYS_PWR_STATUS_BIT_RUN | ״̬
  -----------+------------------------+-------------------------------
     Bit 1   | SYS_PWR_STATUS_BIT_LIM | ѹ,޵Դ״̬
  -----------+------------------------+-------------------------------
     Bit 2   | SYS_PWR_STATUS_BIT_LVP | ѹ״̬
  -----------+------------------------+-------------------------------
     Bit 3   | SYS_PWR_STATUS_BIT_OVP | ѹ״̬
  -----------+------------------------+-------------------------------
   Bit 4 - 7 | RSVD.                  | λ
  ====================================================================*/

#define   SYS_PWR_STATUS_BIT_RUN            0x01
#define   SYS_PWR_STATUS_BIT_LIM            0x02
#define   SYS_PWR_STATUS_BIT_LVP            0x04
#define   SYS_PWR_STATUS_BIT_OVP            0x08

/******************************************************************************
Դģʽ
******************************************************************************/
#define   SYS_PWR_NORMAL_MODE               0x00
#define   SYS_PWR_LVP_MODE                  0x01
#define   SYS_PWR_LIMIT_MODE                0x02
#define   SYS_PWR_OVP_MODE                  0x03

/******************************************************************************
Դ״̬
******************************************************************************/
/*#if (Power_Mod == Power_Version_24)
#define   SYS_LVP_ENTER_THRESHOLD           15500      //ѹֵ  6500
#define   SYS_LVP_EXIT_THRESHOLD            16000      //˳ѹֵ  7000

#define   SYS_LIMIT_ENTER_THRESHOLD         17000      //ϵͳѹرֵ
#define   SYS_LIMIT_EXIT_THRESHOLD          18000      //ϵͳֵ

#define   SYS_OVP_EXIT_THRESHOLD            32200     //˳ѹֵ   17500
#define   SYS_OVP_ENTER_THRESHOLD           32000     //ѹֵ

#else
#define   SYS_LVP_ENTER_THRESHOLD           6500      //ѹֵ  6500
#define   SYS_LVP_EXIT_THRESHOLD            7000      //˳ѹֵ  7000

#define   SYS_LIMIT_ENTER_THRESHOLD         9000      //ϵͳѹرֵ
#define   SYS_LIMIT_EXIT_THRESHOLD          9500      //ϵͳֵ

#define   SYS_OVP_EXIT_THRESHOLD            18200     //˳ѹֵ   17500
#define   SYS_OVP_ENTER_THRESHOLD           18000     //ѹֵ
#endif
*/
#define   SYS_PWR_DEBOUNCE_TIME              2000     //Դ״̬ʱ(ms)

#define   SYS_POWERED_BY_KL30_ONLY            0       //0 - KL15  KL30 ͬʱڹ
//1 -  KL30 

/******************************************************************************
ź״̬
******************************************************************************/
#define   SYS_SIG_STAT_INACTIVE             0x00
#define   SYS_SIG_STAT_ACTIVE               0x01

/******************************************************************************
״̬λ
******************************************************************************/

/*====================================================================
     Bit 0   | SYS_OPR_STATUS_BIT_OFF | еԴر
  -----------+------------------------+-------------------------------
     Bit 1   | SYS_OPR_STATUS_BIT_ACC | ACCԴ
  -----------+------------------------+-------------------------------
     Bit 2   | SYS_OPR_STATUS_BIT_IGN | IGNԴ
  -----------+------------------------+-------------------------------
     Bit 3   | SYS_OPR_STATUS_BIT_CRK | 
  -----------+------------------------+-------------------------------
   Bit 4 - 6 | RSVD.                  | λ
  -----------+------------------------+-------------------------------
     Bit 7   | SYS_OPR_STATUS_BIT_ERR | ״̬(,Դѹ쳣)
  ====================================================================*/

#define   SYS_OPR_STATUS_BIT_OFF            0x01
#define   SYS_OPR_STATUS_BIT_ACC            0x02
#define   SYS_OPR_STATUS_BIT_IGN            0x04
#define   SYS_OPR_STATUS_BIT_CRK            0x08
#define   SYS_OPR_STATUS_BIT_ERR            0x80

/******************************************************************************
״̬
******************************************************************************/
#define   SYS_OFF_THRESHOLD                 5500      //Դ(KL15)رֵ
#define   SYS_ON_THRESHOLD                  6000      //Դ(KL15)ֵ

#define   SYS_OPR_DEBOUNCE_TIME             120       //״̬ʱ(ms)

#define   SYS_RUNNING_IN_LIMIT_MODE         1         //Դģʽ³
#define   SYS_ACC_MODE_DET_ENABLE           0         //ACCģʽʹ(IGN OFFʱ)
#define   SYS_CRANK_MODE_DET_ENABLE         0         //CRANKģʽʹ

/******************************************************************************
Դģʽؽṹ
******************************************************************************/
typedef struct
{
  uint8_t   Mode;
  uint8_t   LVPTimer;
  uint8_t   LimitTimer;
  uint8_t   NormalTimer;
  uint8_t   OVPTimer;
} SysPwrModeStruct;

/******************************************************************************
ź״̬ṹ
******************************************************************************/
typedef struct
{
  uint8_t   Status;
  uint8_t   Timer;
} SysSignalStatusStruct;

/******************************************************************************

******************************************************************************/
void Sys_Status_Init(void);
void Sys_Status_Update_Mode_Set(uint8_t Mode);
void Sys_Status_Update_Service(void);

uint8_t Sys_ACC_Status_Detect(void);
uint8_t Sys_Crank_Status_Detect(void);

#endif