/******************************************************************************
  MSCAN0.h
MSCAN0շƺͷļ
    ߣ
    V1.0
    ڣ2016.11.5
******************************************************************************/

#ifndef _MSCAN0_H_
#define _MSCAN0_H_

#include "stdint.h"
#include "CRG.h"

extern uint8_t NM_RECEIVE;

/******************************************************************************

                                

===============================================================================
- MSCANͨԤƵʱTqΪCANźŵʱ

-  Bosch CAN 2.0A/B ׼, MSCAN/ÿһλʱ䱻Ϊ:

  ----------------------------------------------------------------------------
  | Sync_Seg |            Time Segment 1            |     Time Segment 2     |
  ----------------------------------------------------------------------------
  |<- 1 Tq ->|<------------  4 ~ 16 Tq  ----------->|<-----  2 ~ 8 Tq  ----->|
  |                                                                          |
  |<---------------------------  Total 8 ~ 25 Tq  -------------------------->|

  Sync_Segй̶1Tqʱ,CANźŵ½ڱβ(ʱ)
            (ʱ),־CANһλշĿʼ,ͬշ
  ʱ 1  ΰCAN׼PROP_SEGκPHASE_SEG1,ʱ,ݵĲڱ
            εĺοһδ,εʱΪ 4 ~ 16 Tq
  ʱ 2  ΰCAN׼PHASE_SEG2,εʱΪ 2 ~ 8 Tq

- ͬתSJWͬڼ,λñƶTq,ʱݶ
                   ֵΪͬת,ɱΪ 1 ~ 4 Tq

- ûȷλʱCAN׼
  --------------------------------------------------
       ʱ 1     |     ʱ 2     |  ͬת
  --------------------------------------------------
       5 ~ 10     |       2        |     1 ~ 2
       4 ~ 11     |       3        |     1 ~ 3
       5 ~ 12     |       4        |     1 ~ 4
       6 ~ 13     |       5        |     1 ~ 4
       7 ~ 14     |       6        |     1 ~ 4
       8 ~ 15     |       7        |     1 ~ 4
       9 ~ 16     |       8        |     1 ~ 4
  --------------------------------------------------
******************************************************************************/
#define   MSCAN0_BAUD_RATE                  500             //,λkbps

#define   MSCAN0_T_SEG1                     11              //ʱ1Tq
#define   MSCAN0_T_SEG2                     4               //ʱ2Tq

#define   MSCAN0_SAMPLE_POINT               MSCAN0_SAMPLE_1POINT
#define   MSCAN0_SJW                        3               //ͬת

/******************************************************************************
ѡ
******************************************************************************/
#define   MSCAN0_SAMPLE_1POINT              0x00            //ÿλ1(CANƼ)
#define   MSCAN0_SAMPLE_3POINT              0x80            //ÿλ3

/******************************************************************************
Bus-off
******************************************************************************/
#define   MSCAN0_BUS_OFF_AUTO_RECOVERY      0               //Bus-offԶָʹ

#define   MSCAN0_BUS_OFF_LV1_RECOVERY_TIME  100             //Bus-offָʱ,λms
#define   MSCAN0_BUS_OFF_LV2_RECOVERY_TIME  1000            //Bus-offָʱ,λms

#define   MSCAN0_BUS_LIMP_MODE_ENABLE       0               //ģʽʹ
#define   MSCAN0_BUS_LIMP_MODE_THRESHOLD    11              //ģʽ

/******************************************************************************
Ԥ
******************************************************************************/
#define   MSCAN0_PRESCALER    (OSCCLK / (1 + MSCAN0_T_SEG1 + MSCAN0_T_SEG2) / MSCAN0_BAUD_RATE / 1000)
#define   MSCAN0_BTR0_VALUE   ((uint8_t)((MSCAN0_SJW - 1) << 6) | (uint8_t)(MSCAN0_PRESCALER - 1))
#define   MSCAN0_BTR1_VALUE   (MSCAN0_SAMPLE_POINT | (uint8_t)((MSCAN0_T_SEG2 - 1) << 4) | (uint8_t)(MSCAN0_T_SEG1 - 1))

/******************************************************************************
Bus-off״̬
******************************************************************************/
#define   MSCAN0_BUS_STABLE                 0x00
#define   MSCAN0_BUS_OFF_LV1                0x01
#define   MSCAN0_BUS_OFF_LV2                0x02
#define   MSCAN0_BUS_LIMP                   0x03

/******************************************************************************
ķ״̬
******************************************************************************/
#define   COMPLETE                          0x00
#define   NOT_COMPLETE                      (!COMPLETE)

/******************************************************************************
Bus-offؽṹ
******************************************************************************/
typedef struct
{
  uint8_t  Status;
  uint8_t  Timer;
  uint8_t  Cnt;
} MSCAN0BusoffMonitorStruct;

/******************************************************************************

******************************************************************************/
void MSCAN0_L_Data_Request(uint32_t Identifier, uint8_t DLC, uint8_t *Data, uint8_t Priority);
void MSCAN0_L_Data_Indication(uint32_t Identifier, uint8_t DLC, uint8_t *Data);
void MSCAN0_L_Data_Confirm(uint32_t Identifier, uint8_t TransferStatus);

void bsp_CAN_SleepRelease ( void );
void bsp_tx_msgbuf_abort ( void );
void bsp_CAN_Sleep ( void );

void MSCAN0_Bus_Off_Monitoring_Service ( void );
uint8_t MSCAN0_Get_Bus_Status ( void );

void MSCAN0_Init ( void );
void MSCAN0_Enter_Low_Power_Mode ( void );
void MSCAN0_Exit_Low_Power_Mode ( void );
uint8_t MSCAN0_Get_Wake_Up_Flag ( void );
void MSCAN0_L_Data_Service(void);
#endif