
#ifndef _SOUND_SOURCE_H_
#define _SOUND_SOURCE_H_

#include "stdint.h"

/******************************************************************************
Դб

ע⣺ԴָӦλԱеһһӦ
******************************************************************************/
#define        SND_HI_COOLANT_TEMP_SPEED1           0x00  //ѹ
#define        SND_HI_PRESSURE_SPEED1               0x01  //ˮ±  
#define        SND_CAN_ERROR_SPEED1                 0x02  //can  
#define        SND_LOW_ADBLUE_SPEED1                0x03  //Һλͱ  
#define        SND_ADBLUE_ERROR1                    0x04  //
#define        SND_SRC_RADAR_1Hz                    0x05  //״ﱨ  
#define        SND_SRC_RADAR_2Hz                    0x06  //״ﱨ_2Hz  
#define        SND_SRC_RADAR_4Hz                    0x07  //״ﱨ_4Hz  
#define        SND_SRC_RADAR_CONTINUOUS             0x08  //״ﱨ_  
#define        SND_RADAR_SENSOR_FAILURE             0x09  //״  
#define        SND_YOUTIPIAN_ERROR1                 0x0A  //Ƭĥ
#define        SND_LF_HOOVES_ERROR1                 0x0B  //Ƭĥ
#define        SND_RF_HOOVES_ERROR1                 0x0C  //Ƭĥ
#define        SND_LR_HOOVES_ERROR1                 0x0D  //Ƭĥ
#define        SND_RR_HOOVES_ERROR1                 0x0E  //Ƭĥ  
#define        SND_LOW_OIL_SPEED1                   0x0F  //ѹ
#define        SND_LOW_FUEL_SPEED1                  0x10  //ȼ͵
#define        SND_SRC_TICK                         0x11  //ת򱨾
#define        SND_SRC_TOCK                         0x12  //ת򱨾
#define        SND_SEATBELT_SPEED1                  0x13  //ȫ
#define        SND_LOW_PBRAKE_SPEED1                0x14  //ƶҺλͱ
#define        SND_PPARK_SPEED1                     0x15  //פƶ           
#define        SND_DOOR_OPENED1                     0x16  //ſ
#define        SND_PTO1                             0x17  //
#define        SND_noKeyInCar1                      0x18  //
#define        SND_POffWithoutN1                    0x19  //
#define        SND_LockWithKeyInCar1                0x1A  //
#define        SND_BreakPressure1                   0x1B  //
#define        SND_OVER_SPEED1                      0x1C  //
#define        SND_SRC_AEB                          0x1D  //ת򱨾
#define        SND_SRC_Break_down                   0x1E  //
#define        SND_SRC_CNG_GasLeak                  0x1F  //
/******************************************************************************
αԴб
******************************************************************************/
#define   SND_SRC_NONE                      0xFF    //û
#define   SND_SRC_CURRENT                   0xFE    //ǰŵ

/******************************************************************************
Դѭ
******************************************************************************/
#define   SND_CYCLE_NONSTOP                 0xFF    //ͣ

/******************************************************************************
Դģʽ
******************************************************************************/
#define   SND_MODE_SINGLE                   0x00    //ʹISD_Play_Vp
#define   SND_MODE_LOOP                     0x01    //ʹISD_Play_Vp_Loop

/******************************************************************************
Խṹ
******************************************************************************/
typedef struct
{
  uint8_t  Index;
  uint8_t   Priority;
  uint8_t   Cycle;
  uint8_t   Mode;
  uint16_t  Period;
} SndAttributeStruct;

/******************************************************************************
ԴԱ
******************************************************************************/
static const SndAttributeStruct SndAttributeTable[] =
{
  /*=================================================================================================
                Դ            |Դ|ȼ|     ѭ     |     ģʽ      | (ms)
  -------------------------------------------------------------------------------------------------*/
  {/* SND_HI_COOLANT_TEMP_SPEED1 1 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_HI_PRESSURE_SPEED1     2 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_CAN_ERROR_SPEED1       3 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,     500,},
  {/* SND_LOW_ADBLUE_SPEED1      4 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,     500,},
  {/* SND_ADBLUE_ERROR1          5 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,     500,},
  {/* SND_RADAR_1Hz              6 */   0x02,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_RADAR_2Hz              7 */   0x02,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,     500,},
  {/* SND_RADAR_4Hz              8 */   0x02,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,     250,},
  {/* SND_RADAR_CONTINUOUS       9 */   0x02,      0, SND_CYCLE_NONSTOP,  SND_MODE_LOOP    ,       0,},
  {/* SND_RADAR_SENSOR_FAILURE  10 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,     500,},
  {/* SND_YOUTIPIAN_ERROR1      11 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,     500,},
  {/* SND_LF_HOOVES_ERROR1      12 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,     500,},
  {/* SND_RF_HOOVES_ERROR1      13 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,     500,},
  {/* SND_LR_HOOVES_ERROR1      14 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,     500,},
  {/* SND_RR_HOOVES_ERROR1      15 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,     500,},
  {/* SND_LOW_OIL_SPEED1        16 */   0x03,      0,                10,  SND_MODE_SINGLE  ,     500,},
  {/* SND_LOW_FUEL_SPEED1       17 */   0x01,      0,                 1,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_SRC_TICK                 */   0x05,      0,                 1,  SND_MODE_SINGLE  ,     100,},
  {/* SND_SRC_TOCK                 */   0x06,      0,                 1,  SND_MODE_SINGLE  ,     100,},
  {/* SND_SEATBELT_SPEED1       20 */   0x01,      0,                60,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_LOW_PBRAKE_SPEED1     21 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_PPARK_SPEED1          22 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_DOOR_OPENED1          23 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_PTO1                  24 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_noKeyInCar1           25 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_POffWithoutN1         26 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_LockWithKeyInCar1     27 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_BreakPressure1        28 */   0x01,      0,                90,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_OVER_SPEED1           29 */   0x01,      0,                3,   SND_MODE_SINGLE  ,    1000,},
  {/* SND_SRC_AEB               30 */   0x01,      0,                30,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_SRC_Break_down        31 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  {/* SND_SRC_CNG_GasLeak       32 */   0x01,      0, SND_CYCLE_NONSTOP,  SND_MODE_SINGLE  ,    1000,},
  /*==============================================================================================*/
};

#define   SND_TOTAL_NUM                     (sizeof(SndAttributeTable) / sizeof(SndAttributeStruct))

#endif
