/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.testutils;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.testutils.TestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Logger;

public class TestFontUtils {
    private static final Logger logger = Logger.getLogger(Font.class.getCanonicalName());
    private static final Comparator<Table> TABLE_COMPARATOR_BY_OFFSET = new Comparator<Table>(){

        @Override
        public int compare(Table o1, Table o2) {
            return o1.header().offset() - o2.header().offset();
        }
    };

    private TestFontUtils() {
    }

    public static Font[] loadFont(File file) throws IOException {
        return TestFontUtils.loadFont(file, true);
    }

    public static Font[] loadFont(File file, boolean fingerprint) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        fontFactory.fingerprintFont(fingerprint);
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            Font[] fontArray = fontFactory.loadFonts(is);
            return fontArray;
        }
    }

    public static Font[] loadFont(File file, byte[] ... expectedFingerprints) throws IOException {
        Font[] fonts = TestFontUtils.loadFont(file, true);
        int i = 0;
        while (i < Math.min(fonts.length, expectedFingerprints.length)) {
            if (expectedFingerprints[i] != fonts[i].digest()) {
                throw new IOException("Did not get the expected fingerprint for font#" + i + " in " + file.getPath() + " Has the file changed?");
            }
            ++i;
        }
        return fonts;
    }

    public static Font[] loadFontUsingByteArray(File file) throws IOException {
        return TestFontUtils.loadFontUsingByteArray(file, true);
    }

    public static Font[] loadFontUsingByteArray(File file, boolean fingerprint) throws IOException {
        byte[] b = TestUtils.readFile(file);
        FontFactory fontFactory = FontFactory.getInstance();
        fontFactory.fingerprintFont(fingerprint);
        return fontFactory.loadFonts(b);
    }

    public static Font[] buildAndCheckFont(FontFactory fontFactory, InputStream is, int debug) throws IOException {
        Font[] fontArray;
        Font[] fontArray2 = fontArray = fontFactory.loadFonts(is);
        int n = fontArray.length;
        int n2 = 0;
        while (n2 < n) {
            FontHeaderTable head;
            Font font = fontArray2[n2];
            if (debug >= 1) {
                logger.info(font.toString());
            }
            if ((head = (FontHeaderTable)font.getTable(Tag.head)) != null) {
                long magicNumber = head.magicNumber();
                if (1594834165L != magicNumber) {
                    throw new RuntimeException("Magic number is incorrect.");
                }
                if (debug >= 2) {
                    logger.fine("magic number = " + Long.toHexString(magicNumber));
                    MaximumProfileTable maxp = (MaximumProfileTable)font.getTable(Tag.maxp);
                    logger.fine("Number of glyphs = " + maxp.numGlyphs());
                    logger.fine("\n------ Tables by File Location");
                }
            } else {
                Object bhed = font.getTable(Tag.intValue("bhed"));
                if (bhed == null) {
                    throw new RuntimeException("No head table or bhed");
                }
            }
            TreeSet<Table> tables = new TreeSet<Table>(TABLE_COMPARATOR_BY_OFFSET);
            tables.addAll(font.tableMap().values());
            for (Table table : tables) {
                boolean csValid;
                if (debug >= 2) {
                    System.out.println(table);
                }
                Header header = table.header();
                boolean bl = csValid = table.calculatedChecksum() == header.checksum();
                if (csValid) continue;
                logger.severe("\t**** Checksum not valid!");
                logger.severe("\tcalculated = 0x" + Long.toHexString(table.calculatedChecksum()));
                logger.severe("\tread       = 0x" + Long.toHexString(header.checksum()));
                throw new RuntimeException("Checksum for table " + Tag.stringValue(header.tag()));
            }
            if (debug >= 2) {
                logger.fine("\n------ CMap Tables");
                CMapTable cmap = (CMapTable)font.getTable(Tag.cmap);
                for (CMap cmt : cmap) {
                    logger.fine(cmt.toString());
                    int c = 0;
                    while (c < 256) {
                        logger.finer(String.valueOf(c) + " = " + cmt.glyphId(c));
                        ++c;
                    }
                }
                logger.fine("\n----- Name Tables");
                NameTable name = (NameTable)font.getTable(Tag.name);
                for (NameTable.NameEntry entry : name) {
                    logger.finer(entry.toString());
                }
            }
            ++n2;
        }
        return fontArray;
    }

    public static File serializeFont(File fontFile) throws Exception {
        Font[] fonts = TestFontUtils.loadFont(fontFile);
        if (fonts == null || fonts.length != 1) {
            return null;
        }
        String extension = TestUtils.extension(fontFile);
        return TestFontUtils.serializeFont(fonts[0], extension);
    }

    public static File serializeFont(Font font, String extension) throws Exception {
        File serializedFontFile = File.createTempFile("serializedFont_", extension);
        return TestFontUtils.serializeFont(font, serializedFontFile);
    }

    public static File serializeFont(Font font, File serializedFontFile) throws Exception {
        serializedFontFile.mkdirs();
        serializedFontFile.createNewFile();
        try (OutputStream os = null;){
            os = TestUtils.createOutputStream(serializedFontFile);
            FontFactory factory = FontFactory.getInstance();
            factory.serializeFont(font, os);
        }
        return serializedFontFile;
    }

    public static Font.Builder builderForFontFile(File fontFile) throws IOException {
        return TestFontUtils.builderForFontFile(fontFile, true);
    }

    public static Font.Builder builderForFontFile(File fontFile, boolean fingerprint) throws IOException {
        FileInputStream is = new FileInputStream(fontFile);
        FontFactory otfFactory = FontFactory.getInstance();
        otfFactory.fingerprintFont(fingerprint);
        Font.Builder[] builder = otfFactory.loadFontsForBuilding(is);
        return builder[0];
    }
}

