/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.table.FontDataTable;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import java.io.File;
import java.util.Map;
import junit.framework.TestCase;

public class LoadingTests
extends TestCase {
    private static final File TEST_FONT_FILE = TestFont.TestFontNames.OPENSANS.getFile();

    public LoadingTests() {
    }

    public LoadingTests(String name) {
        super(name);
    }

    public void testLoadingComparison() throws Exception {
        Font[] sFonts = TestFontUtils.loadFont(TEST_FONT_FILE);
        Font[] bFonts = TestFontUtils.loadFontUsingByteArray(TEST_FONT_FILE);
        LoadingTests.assertEquals(sFonts.length, bFonts.length);
        int i = 0;
        while (i < sFonts.length) {
            Font streamFont = sFonts[i];
            Font byteFont = bFonts[i];
            LoadingTests.assertEquals(streamFont.numTables(), byteFont.numTables());
            Map<Integer, ? extends Table> streamTableMap = streamFont.tableMap();
            for (Map.Entry<Integer, ? extends Table> entry : streamTableMap.entrySet()) {
                int tag = entry.getKey();
                Table streamTable = entry.getValue();
                Object byteTable = byteFont.getTable(tag);
                LoadingTests.assertNotNull(byteTable);
                LoadingTests.assertEquals(streamTable.dataLength(), ((FontDataTable)byteTable).dataLength());
                LoadingTests.assertEquals(streamTable.calculatedChecksum(), ((Table)byteTable).calculatedChecksum());
                Header streamHeader = streamTable.header();
                Header byteHeader = ((Table)byteTable).header();
                LoadingTests.assertEquals(streamHeader.checksum(), byteHeader.checksum());
                LoadingTests.assertEquals(streamHeader.length(), byteHeader.length());
                LoadingTests.assertEquals(streamHeader.offset(), byteHeader.offset());
                LoadingTests.assertEquals(streamHeader.tag(), byteHeader.tag());
            }
            ++i;
        }
    }
}

